/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	stringListCheckItem.h 
*	
*	A simple case of subclassing used by groupModulesWin. Probably has  
*   application elsewhere as well.
*
*****************************************************************************/

#ifndef __stringListCheckItem_h 
#define __stringListCheckItem_h

class stringListCheckItem : public QCheckListItem
{
    public:
        stringListCheckItem(QStringList * stringlist, QListViewItem * groupToUse, const char * text)
            : QCheckListItem(groupToUse, text, QCheckListItem::CheckBox)
        {
            #ifdef DEBUG_CHECKLISTITEM
                debug("creating a checklistitem");
            #endif
            list = stringlist;
        }

    protected:
        void stateChange (bool state)
        {
            if (state == true && ! list->contains(text(0)))
            {
                list->append(text(0));
            }
            else if (state == false && list->contains(text(0)))
            {
                list->remove(text(0));
            }
        }

    private:
        QStringList * list;
};

#endif __stringListCheckItem_h 