/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	plugin.cc 
*	
*	the base class for all plugins. to be loadable, they must inherit this 
*	this class and reimplement all the virtual functions.
*
*****************************************************************************/

#ifndef __plugin_h
#define __plugin_h

#include "dlc_base.h"
#include "dlc_register.h"
#include "dlc_server.h"

#include "olympus.h"

#include "guisocket.h"
#include "hostObj.h"
#include "netmessage.h"
#include "commid.h"

class plugin: public DLC_BASE
{
    Q_OBJECT
  
    public:
        plugin() {}
        virtual ~plugin() {}

        // these return info on the plugin in question
        virtual char *name() { return "Base Plugin"; }
        virtual char *group() { return "Parent Of All"; }
        virtual char *desc() { return "One plugin to inherit them and in the darkness bind them"; }
        virtual char *credits() { return "Mount Linux Inc."; }
        virtual char *version() { return "0.1"; }

        // for receiving netmessage objects
        virtual void recv(netmessage *, int) { }

        // to get focus
        virtual void getFocus() { }
        
        // the "main" function for the plugin
        virtual void exec(hostObj *thisHost, unsigned int MID, moduleList *modItem) 
        { 
            moduleID = 0; 
            modItem = NULL;
            host = NULL;
            init(thisHost,MID,modItem);
        }

        void init(hostObj *initHost, unsigned int initID, moduleList *initModItem) 
        { 
            host = initHost; 
            moduleID = initID; 
            modItem = initModItem; 
        }

        hostObj	*host; // hostObj its connected to
        moduleList *modItem;
        unsigned int moduleID; // module ID
};

#endif // __plugin_h
