/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	ping.h 
*	
*   This pings the olympus server, for lag time and the such
*
*****************************************************************************/

#ifndef __ping_h
#define __ping_h

#include "forwardRefs.h"
#include "plugin.h"

class ping : QObject, plugin
{
    Q_OBJECT

    public:
        ping(hostObj * hostToPing);
        ~ping();

        virtual char * name() { return "Ping"; }
        virtual char * group() { return "n/a"; }
        virtual char * desc() { return "Pings a hosts' Olympus Server"; }
        virtual char * credits() { return "Mount Linux Inc."; }
        virtual char * version() { return "1"; }

        virtual void recv(netmessage *, int);
 
    public slots:
        void close();
        void pingSend();
        void commence();
        void cease(); 
        
    private:
        int sent;
        int recvd;
        long minTime;
        long maxTime;
        long totalTime;
        hostObj * host;
        unsigned int moduleID;
        QDialog * pingWindow;
        QTextView * pingResults;
        QTimer * timer;
        QString moduleIDStr;
};

#endif // __ping_h
