/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	module.h 
*	
*	a reference to a module .so that can be later loaded dynamically
*
*****************************************************************************/

#ifndef __pathValidor_h
#define __pathValidor_h

#include "forwardRefs.h"

#include <limits.h>
#include <qvalidator.h>

class pathValidator: public QValidator
{
    public:
        pathValidator(QWidget * parent, const char * name = 0) 
            : QValidator(parent, name) {}
        
        enum QValidator::State validate(class QString& path, int& pos) const
        {
            if (path.length() > PATH_MAX) { return QValidator::Valid; }
            if (path.right(1) != "/") { return QValidator::Valid; }
            return QValidator::Acceptable;
        }
    
        void fixup(QString& path)
        {
            if (path.length() > PATH_MAX) { path.truncate(PATH_MAX); }
            if (path.right(1) != "/") { path.append("/"); }
            if (path.length() > PATH_MAX) 
            { 
                path.truncate(PATH_MAX - 1); 
                path.append("/");
            }
        }
};

#endif
