/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	olympus.h 
*	
*   Description:
*	Global stuff... =)
*	We keep all of Olympus configuration info in here.
*
*****************************************************************************/

#ifndef __olympus_h
#define __olympus_h

#define DEBUG					// General debugging. Used for the entry and exit of constructor/deconstructors and functions.
//#define DEBUG_FILEIO			// Used during file operations and basic input/ouput.
//#define DEBUG_PREFERENCES		// Used for the debugging of dialogs.
//#define DEBUG_MODULE			// Used for the debugging of modules, moduleLists, etc...
//#define DEBUG_HOST			// Used for the debugging of hostObj, hostGroups, hostItems, etc...

#include "config.h"
#include "defs.h"
#include "forwardRefs.h"

#define DEBUG_OLYMPUSINLINED

#include <qdict.h>
#include <qobject.h>

class olympus : public QObject
{
    Q_OBJECT

    public:
       
        olympus();
        ~olympus();
        void init();

        QDict<QString> *prefs;

        QDict<module> *modules;         // keyed by module file name
        QDict<QString> *modulesByName;
        // File i/o stuff for modules and defaultModules
        void readOlympusFile(QTextStream *inPut);
        void writeOlympusFile(QTextStream *outPut);
        void readDefaultModulesFile();
        void writeDefaultModulesFile();
        void readHostsFile();
        void readHostsFile(QTextStream* inPut, groupObj* thisGroup = NULL);
        int  makeTempFile(QString* tempFileName);
        QString tabs(int depth);

        QString hostsFileName;
        QString authFileName;
        QString olympusFileName;
        QString modulesFileName;
        QString defaultModulesFileName;
	
        moduleList * defaultModules;	// hostObjs to draw on as defaults 

        void loginScreen();
        void firstLoginScreen();
        int  startupScreen();
		
        // stuff to enable modules across the application
        bool launchModule(moduleList * modRecord, hostObj * targetHost);
        bool deleteModule(unsigned int mid); // mid = module ID
        void loadModules();

        QDict<plugin> * openModules;	// keyed by Module ID
        unsigned int midCounter;

        QLineEdit * loginPassword; // used in the login screen     
        QLineEdit * loginPassword2; // used in the login screen     
        QLineEdit * loginUsername; // used in the login screen     
	
        QString * password;
        QString * username;
	
        TripleDES * clientCipher;
		
    	QPalette* listPalette;
    
        groupObj* hostRoot;
        
    public slots:
        void authLogin();
        void die();
        void execHelp();
        void firstAuthLogin();
        void lastChanceClean();
        void saveHostsFile();
        void setPassword();
        void setPasswordNoDelete(); 
        void startPing(hostObj * host);
};

// this is here 'cause Qt has a problem with QString::latin1
#define latin1 data

// Export the olympus class.. (Talk about a global variable)
extern Q_EXPORT olympus *client;

#endif  // __olympus_h
