/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	moduleList.h 
*	
*	a doubly linked list of modules for hostObjs
*
*****************************************************************************/

#ifndef __moduleList_h
#define __moduleList_h

#include "forwardRefs.h"

class moduleList {

    public:	
        moduleList(module *newModule,  moduleList *newPrevModule = NULL, moduleList *newNextModule = NULL);
        ~moduleList();

        void setNextModule(moduleList *newNextModule) { nextModule = newNextModule; }
        moduleList* getNextModule() { return nextModule; }
        void setPrevModule(moduleList *newPrevModule) { prevModule = newPrevModule; }
        moduleList* getPrevModule() { return prevModule; }
        QString* getModuleName();
        module* getModule() { return thisModule; }

        bool open;
        unsigned int mid;

    private:
        moduleList *nextModule;
        moduleList *prevModule;
        module *thisModule;

};

#endif // __moduleList_h
