/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	module.h 
*	
*	a reference to a module .so that can be later loaded dynamically
*
*****************************************************************************/

#ifndef __module_h
#define __module_h

#include "forwardRefs.h"

#include <qpixmap.h>

class module {

    public:
        module(char * newFileName, char * classname, char * newName, char * newDesc, char * groupName, char * newCredits = NULL, char * version = NULL, QPixmap newIconSmall = NULL, QPixmap newIconLarge = NULL, QPixmap logo = NULL);		
        module(QString * newFileName, QString * classname, QString * newName, QString * newDesc, QString * groupName, QString * newCredits = NULL, QString * version = NULL, QPixmap newIconSmall = NULL, QPixmap newIconLarge = NULL, QPixmap logo = NULL);		
        ~module();

        QString *getName() { return name; }
        QString *getGroup() { return group; }
        QString *getDescription() { return description; }
        QString *getFilename() { return filename; }	
        QString *getClassname() { return classname; }	
        QString *getCredits() { return credits; }	
        QString *getVersion() { return version; }	
        QPixmap getSmallIcon() { return *iconSmall; }
        QPixmap getLargeIcon() { return *iconLarge; }
        QPixmap getLogo() { return *logo; }  // a 150 x 100 picture

    private:
        module();

        QString *filename;
        QString *name;
        QString *group;
        QString *description;
        QString *credits;
        QString *classname;
        QString *version;
        QPixmap *iconSmall;
        QPixmap *iconLarge;
        QPixmap *logo;
};

#endif // __module_h
