/*****************************************************************************
*
*    Copyright (c) 1999-2000 Mountlinux Inc.
*    Licensed under the terms of the GPL
*
*    mainWindow.h
*
*    the main object for the application... QMainWindow with Toolbars
*    and Status bars and so forth and the main windows which is a splitter
*    with a QListView and QListBox as the main widgets...(if that makes any
*    sense ;)
*    gets called from main.cc
*
*****************************************************************************/

#ifndef __mainWindow_h
#define __mainWindow_h

#include "forwardRefs.h"

#include <qmainwindow.h>

class mainWindow : public QMainWindow
{
	
    Q_OBJECT

    public:
        mainWindow();
        mainListView* listview;
        mainListBox* listbox;
        ~mainWindow();

        void createModuleList(QListView* listview);

        // the menu bar, for all to have fun with
        QPopupMenu* newfileMenu;
        QPopupMenu* fileMenu;
        QPopupMenu* editMenu;
        QPopupMenu* viewMenu;
        QPopupMenu* hostMenu;
        QPopupMenu* helpMenu;
        
        // id of items in the Host menu
        int hostPropID, hostSyncID, hostConnectID, hostDisconnectID, hostPingID;

    public slots:
        void about();
        void aboutQt();

        void notimplemented();
        void boxandviewcommunication();

        void saveHostsFile();
        void preferences();
        void prefsApplyButtonPressed();
        void prefsModuleDirectorySelect();
        void enableHostPropItem(bool, bool);
        void prefsLoadPlugins();

    private:
        QTabDialog* prefs;
        QLineEdit* moduleLineEdit;

        QListView* defaultModulesList;

        QLineEdit *propBoxCommonName;
        QLineEdit *propBoxHostname;
        QLineEdit *propBoxPort;
        QLineEdit *propBoxUsername;
        QLineEdit *propBoxPassword;
        QCheckBox *propBoxSavePassword;
};

extern Q_EXPORT mainWindow *mW;

#endif // __mainWindow_h
