/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	listView.h 
*	
*	A class for groups of machines. They appear in the left pane of the main
*	client window.
*
*****************************************************************************/

#ifndef __mainListView_h 
#define __mainListView_h

#include "forwardRefs.h"

#include <qlistview.h>
#include <qlist.h>

class hostGroup;

class mainListView: public QListView
{
    Q_OBJECT

    public: 
        mainListView (QWidget *parent);
        ~mainListView();

        QListViewItem *currentItemGet();
        QListViewItem* nextGroupPos(char* name);
        QListViewItem* nextHostPos(char* name);
        bool currentItemSet(QListViewItem *newCurrent = NULL, bool selectIt = false);
        
    public slots:
        void groupProperties(); 
        void loadHosts(); 
        void loadGroups(); 
        void launchRightClickMenu( QListViewItem *, const QPoint & thePoint); 

        /* manage the tree items with these little puppies */
        void makeVisible(QListViewItem *newCurrent = NULL);
        void newHostItem(); 
        void newGroupItem(); 
        
        // to go through the list and see what needs to be axed
        void deleteItems();

        /* properties dialog box methods/slots */
        void hostProperties();  
        
        /* used to add/rem modules en mass to groups of hosts */
        void groupModules();
        
        // used by menus
        void newTopGroupItem(); 
        void newTopHostItem(); 
        void connectToHost(); 
        void disconnectFromHost(); 
        void checkConnection(); 
        void startPing();
        
    signals:
        void rightButtonOnGroup(QListViewItem *, const QPoint &);
        void rightButtonOnHost(QListViewItem *, const QPoint &);
        void itemSelected(groupObj*);
        void itemSelected(hostObj*);
        void enableHostPropItem(bool, bool);
        void enterLimbo();
        void exitLimbo();
        
    private:
        /* hide the default constructor */
        mainListView();

        /* misc. methods */
        void multiSelect(QListViewItem *fromItem, QListViewItem *toItem);
        void moveItems(QListViewItem* moveTo);

        /* menus... will be moved out eventually, i'm sure */
        QPopupMenu *rightClickNoneMenu;
        QPopupMenu *rightClickGroupMenu;
        QPopupMenu *rightClickHostMenu;

        /* mouse and keyboard event routines */
        void contentsMousePressEvent(QMouseEvent *e);
        void contentsMouseReleaseEvent(QMouseEvent *e);
        void contentsMouseMoveEvent(QMouseEvent *e);
        void wheelEvent(QWheelEvent *e);
        void keyPressEvent(QKeyEvent *e);

        /* objects, data members */
        QListViewItem *currentItem;
        QListViewItem *shiftStartItem;
        QListViewItem *finalItem;  // used as a last place keeper.
                                    // used in delete items right now
                                    // feel free to use it, but view it as temp
                                    // storage at best...
        QTimer *scrollTimer; // used for scrolling whilst dragging items
        QList<QListViewItem>* selectedItems;
        
        bool scrollTimerActive;
        bool shiftSelectionFlag;
        bool multiSelectFlag;
        bool dragging;
        bool limbo;

    private slots:
        void scrollUp() { scrollBy(0,-10); } 
        void scrollDown() { scrollBy(0,10); } 
};

#endif // __mainListView_h
