/*****************************************************************************
*
*    Copyright (c) 1999-2000 Mountlinux Inc.
*    Licensed under the terms of the GPL
*
*    mainListBoxItem.h
*
*    Description:...
*
*****************************************************************************/

#ifndef __mainListBoxItem_h
#define __mainListBoxItem_h

#include "forwardRefs.h"

#include <qlistbox.h>

class mainListBoxItem : public QObject, public QListBoxItem
{
    Q_OBJECT
    
    public:
        mainListBoxItem(QString s, const QPixmap p, QListBox *parent, hostObj* host);
        mainListBoxItem(QString s, const QPixmap p, QListBox *parent, groupObj* group);
        mainListBoxItem(QString s, const QPixmap p, QListBox *parent, moduleList *itemToDisplay);
        enum{GROUP,HOST,MODULE};
        hostObj* displayHost;
        groupObj* displayGroup;
        moduleList * displayModule;

        int typeIs()
        {
            return type;
        }

        bool isType(int checkType)
        {
            if (this->type == checkType) 
            {
                return true;
            }
            else
            {
                return false;
            }
        }

    public slots:
        void nameChanged();
        
    protected:
        virtual void paint( QPainter * );
        virtual int height( const QListBox* ) const;
        virtual int width( const QListBox* ) const;
        virtual const QPixmap *pixmap() { return &pm; }

    private:
        int type;	
        QPixmap pm;
};

#endif // __mainListBoxItem_h
