/*****************************************************************************
*
*    Copyright (c) 1999-2000 Mountlinux Inc.
*    Licensed under the terms of the GPL
*
*    mainListBox.h
*
*    This holds the right hand of the splitter ... b'ah...b'ah...b'ah
*
*****************************************************************************/

#ifndef __mainListBox_h
#define __mainListBox_h

#include "forwardRefs.h"

#include <qlistbox.h>

class mainListBox : public QListBox
{

    Q_OBJECT

    public:
        mainListBox(QWidget* parent);
        ~mainListBox();

        enum {dummy, Delete, DeleteAll, CancelDelete};

        hostObj* host() { return displayHost; }
        groupObj* group() { return displayGroup; }
        
    public slots:
        void launchRightClickMenu(mainListBoxItem *, const QPoint & thePoint);
        void setDisplayItem();
        void setDisplayItem(hostObj* hostToDisplay);
        void setDisplayItem(groupObj* groupToDisplay);
        void refreshList();
        void multiSelect(int fromItem, int toItem);
        void groupModules();
        void hostProperties();

    signals:
        void rightButtonOnGroup(mainListBoxItem *, const QPoint &);
        void rightButtonOnHost(mainListBoxItem *, const QPoint &);
        void statusMessage(const QString &);
        void enableHostPropItem(bool, bool);
        void launchModule(module *, hostObj *);		
		
    private:
        hostObj* displayHost;
        groupObj* displayGroup;
        
        int currentItem;
        int shiftStartItem;
        bool shiftSelectionFlag;
        bool multiSelectFlag;
        bool dragging;
        bool mouseHeld;
        bool limbo;
        void currentItemSet(int itemNom, bool select);
        void deleteItems();
        
        // mouse and key press methods
        void mousePressEvent(QMouseEvent *e);
        void mouseMoveEvent(QMouseEvent * e);
        void mouseReleaseEvent(QMouseEvent *e);
        void mouseDoubleClickEvent(QMouseEvent * e);
        void wheelEvent(QWheelEvent * e);
        void keyPressEvent(QKeyEvent *e);

        // menus... 
        QPopupMenu* rightClickNoneMenu;
        QPopupMenu* rightClickGroupMenu;
        QPopupMenu* rightClickHostMenu;

    private slots:
        void scrollUp() { scrollBy(0,-10); } 
        void scrollDown() { scrollBy(0,10); } 
};

#endif // __mainListBox_h
