/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	icons.h 
*	
*	this object holds all the icons.
*
*****************************************************************************/

#ifndef __icons_h
#define __icons_h

#include "forwardRefs.h"
#include <qdict.h>

class icons : private QDict<QPixmap>
{

    public:
        icons(char * path, int size = 9973);
        ~icons();

        bool insert(const char * key, const char * xpm[]);
        bool insert(const QString & key, const char * xpm[]);

        QPixmap * icons::find(const char * key);
        QPixmap * icons::find(const QString & key);

        bool icons::find(const char * key, QPixmap & pixmap);
        bool icons::find(const QString & key, QPixmap & pixmap);

    private:

        icons();

};

extern Q_EXPORT icons * icon_small;
extern Q_EXPORT icons * icon_large;

#endif // __icons_h
