/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	hostObj.h 
*	
*	this holds the information tied to each object
*
*****************************************************************************/

#ifndef __hostObj_h
#define __hostObj_h

#include "forwardRefs.h"

#include <qobject.h>

class hostObj : public QObject
{
	Q_OBJECT
	
	public:
		//  constructors, destructors
		hostObj(groupObj* parentObj, bool prompt, const char * newCommonName = NULL, const char * newHostname = NULL, unsigned short newPort = 0);
		hostObj(groupObj* parentObj, bool prompt, QString * newCommonName = NULL, QString* newHostname = NULL, unsigned short newPort =0);
 		hostObj(const hostObj&);
		~hostObj();
		
		//  network methods
		bool isConnected();
		void getLoginInfo();
		
		//  module maintenance methods
		void addModule(module * newModule);	
		void removeModule(const char * moduleName);
		void removeModule(QString * moduleName);
		bool moduleExists(const char * moduleName);
		bool moduleExists(QString * moduleName);
		moduleList * getFirstModule();
		void clearFirstModule();
		
		//  hostname methods
		void setHostname(const char * newHostname);
		void setHostname(QString * newHostname);
		QString * getHostname();
		
		//  commonName methods
		void setCommonName(const char * newCommonName);
		void setCommonName(QString * newCommonName);
		QString * getCommonName();
		
		//  username methods
		void setUsername(const char * newUsername);
		void setUsername(QString * newUsername);
		QString * getUsername();
		
		//  password methods
		void setPassword(const char * newPassword);
		void setPassword(QString * newPassword);
		QString * getPassword();
		
		//  port methods
		void setPort(const char * newPort);
		void setPort(unsigned short newPort);
		int getPort();
				
		//  password stuff
		void setPasswordSave(bool newSetting) { keepPassword = newSetting; }
		bool weSavePassword() { return keepPassword; }
		
		guisocket* network;
        transport* getRawSocket();
        
        // structure.cc
        hostObj* getNext() { return nextHost; }
        hostObj* getPrev() { return prevHost; }
        groupObj* getParent() { return parentGroup; }
        void setParent(groupObj* parent) { parentGroup = parent; }
        void setNext(hostObj* host);
        void setPrev(hostObj* host);
        bool isFirstChild();
        int destroy(int);
       
    signals:
        void connectionOpenned();
        void connectionClosed();
        void modulesChanged();
        void propsChanged();
        void doomed(bool);
        void lastCall();
        
	public slots:
		void connect();
		void disconnect();
		void getLoginUpdater();
		void setConnected(bool);
		void properties();
		void weAreDoomed(bool);
		
	protected:
	
	
	private:
		hostObj() {}
		
		hostObj* nextHost;
		hostObj* prevHost;
	    groupObj* parentGroup;
	    
		QString * username;
		QString * password;
		QString * hostname;
		QString * commonName;
		moduleList * firstModule;
		int port;
		bool keepPassword;
		bool connected;
		bool dirty;
		
		// used to get their login info via getLoginInfo()
		QLineEdit * newUsername;
		QLineEdit * newPassword;
};

#endif // __hostObj_h
