/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	hostGroup.h 
*	
*	A class for groups of machines. They appear in the left pane of the main
*	client window.
*
*****************************************************************************/

#ifndef __hostItem_h
#define __hostItem_h

#include "forwardRefs.h"

#include <qlistview.h>

class hostItem: public QObject, public QListViewItem 
{
    Q_OBJECT
    
    public: 
        // constructors/destructors
        hostItem(mainListView * listView, hostObj* object, const char * hostName);
        hostItem(hostGroup * hostGroup, hostObj* object, const char * hostName);

        ~hostItem();

        // methods
        hostObj * hostInfo() { return host; }
        bool isDoomed();
        
    public slots:
        void propsChanged();
        void doomed(bool);
    
    private:
        hostObj * host;
        hostItem();
        bool doom;
    
    private slots:
        void stateOpen();
        void stateClosed();
};

#endif // __hostItem_h
