/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	hostGroup.h 
*	
*	A class for groups of machines. They appear in the left pane of the main
*	client window.
*
*****************************************************************************/

#ifndef __hostGroup_h 
#define __hostGroup_h

#include "forwardRefs.h"
#include "olympus.h"

#include <qlistview.h>

class hostGroup: QObject, public QListViewItem
{
    Q_OBJECT
    
    public: 

        hostGroup (mainListView * listView, groupObj* thisObj, const char * groupName); 
        hostGroup (hostGroup * hostGroup, groupObj* thisObj, const char * groupName);
        ~hostGroup();
        
        enum { NONE, HOSTS, GROUPS, ALLCHILDREN };
        
        groupObj* getGroupObj() { return group; }
        QListViewItem* nextGroupPos(char* name);
        QListViewItem* nextHostPos(char* name);
        
        /* by sending a hostGroup into limbo with limboState(true)
           it will make it store any update until its un-limboed */
        bool inLimbo();
        
        void dirty(int whatIsDirty);
        int whatsDirty();
        
        bool isDoomed();
        
    public slots:
        void enterLimbo();
        void exitLimbo();
        void loadHosts();
        void loadGroups();
        void nameChange(QString*);
        void doomed(bool);
        
    private:
        groupObj* group;
        mainListView * mainList;
        bool limbo, dirtyHosts, dirtyGroups, doom;
};

#endif // __hostGroup_h
