/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   guisocket.h 
*   
*   A class that wraps Socket to make it interface with netmessage
*   It handles the 32 byte header on any stream and decides what to do with it
*   It is attatched to an instance of a plugin.
*
*****************************************************************************/

#ifndef __guisocket_h
#define __guisocket_h

#include "config.h"
#include "defs.h"
#include "forwardRefs.h"
#include <qlist.h>
#include <qobject.h>

#define MAXATTEMPTS 5

class guisocket : public QObject
{
    Q_OBJECT
    
    public:
        guisocket(hostObj* thisHost);
        ~guisocket();
        
        transport* getSocket() { return socket; }

        enum {
            CLOSED,
            CONNECTING,
            VEXINIT,
            VEXREPLY,
            ALGINIT,
            ALGREPLY,
            KEXINIT,
            KEXINIT2,
            KEXREPLY,
            SENDAUTH,
            AUTH,
            OPEN
        };
        
        void queueMessage(netmessage* messageToQueue);
        bool isConnected() 
            { 
                if (connectionState == CLOSED) { return false; }
                else { return true; }
            }
        
    signals:
        void connectionSignal(bool);
        void messageSent(unsigned long);
        
    public slots:
        void connect();
        void readSocket();
        void disconnect();
        void sendNextMessage();
        void timeout();    
        void cancelRequests(int);
        
    private:
        guisocket();
        
        int readHeader(void);
        netmessage * createNetmessage(int sessionID, int objectID);
        void loginFail(void);
        void connectError(int error);
        void socketError(int error);

        hostObj * host;
        transport * socket;

        int connectionState;

        unsigned char header[32];
        int hlen;

        uint32 opcode;
        uint32 sessionID;
        uint32 currentObjectID;

        netmessage * currentMessage;
        
        QSocketNotifier * readWatcher;
        QSocketNotifier * writeWatcher;
        QSocketNotifier * exceptionWatcher;
        QTimer * socketTimer;
        QList<netmessage> * messageQueue;
        unsigned long messageCount;
        int attempts;
};

#endif
