/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*   
*   groupObj.h 
*	
*	a class to hold together a tree of hostObjs
*
*   Aaron J. Seigo <aseigo@mountlinux.com>
*****************************************************************************/

#ifndef __groupobj_h
#define __groupobj_h

#include "forwardRefs.h"

#include <qobject.h>

class groupObj : public QObject
{
    Q_OBJECT
    
    public:
        groupObj(groupObj* parent = NULL, QString* newName = NULL);
        ~groupObj();
        
        hostObj* getFirstChild();
        groupObj* getChildGroup();
        
        groupObj* getNext();
        void setNext(groupObj* next);
        
        groupObj* getPrev();
        void setPrev(groupObj* prev);

        groupObj* getParentGroup();
        void setParentGroup(groupObj* parent);
        
        void parent(hostObj* child);
        void parent(groupObj* child);
        void deparent(hostObj* child);        
        void deparent(groupObj* child);
    
        QString* getName();
        void setName(QString* newName);
        void setName(char* newName);       
        
        void signalUpdatedAll() { emit updatedAll(); }
        void signalUpdatedHosts() { emit updatedHosts(); }
        void signalUpdatedGroups() { emit updatedGroups(); }
    
    public slots:
        void properties();
        void weAreDoomed(bool);
        int  destroy(int silentDelete);
        
    signals:
        void updatedHosts();
        void updatedGroups();
        void updatedAll();
        void nameChanged(QString*);
        void doomed(bool);
        void lastCall();
       
    private:
        groupObj* parentGroup; 
        groupObj* nextGroup;
        groupObj* prevGroup;
        groupObj* childGroup;
        hostObj*  firstChild;
        bool dirty;
        QString* name;
};

#endif