/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	groupModulesWin.h 
*	
*	A class that makes a window for and then actually does mass assignment
*   of modules to groups of items
*
*****************************************************************************/

#ifndef __groupModulesWin_h 
#define __groupModulesWin_h

#include "forwardRefs.h"

#include <qdialog.h>

class groupModulesWin : QDialog
{
    Q_OBJECT

    public:
        groupModulesWin(groupObj* useGroup);
        ~groupModulesWin();
        void closeEvent(QCloseEvent * closeEvent);
        
    private:
        groupObj * group;
        QListView * modulesList;
        QStringList * selectedModules; 
        
        
    private slots:
        void addModules();
        void addModules(groupObj* currentGroup);
        void removeModules();
        void removeModules(groupObj* currentGroup);
        void clickOn(QListViewItem*, const QPoint&, int);
};


#endif // __groupModulesWin_h