/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   insert.cc 
*
*   these methods insert icons into the icon object
*
*****************************************************************************/

#include "icons.h"

#include <qpixmap.h>
#include <qstring.h>

bool icons::insert(const char *key, const char *xpm[])  
{
    QString qkey(key);
    return insert(qkey,xpm);
}

bool icons::insert(const QString &key, const char *xpm[]) 
{
    if (xpm==NULL || *xpm==NULL)
    {
        return false;
    }  

    QPixmap *temp = new QPixmap(xpm);

    if (temp==NULL || temp->isNull())
    {
        return false;
    }  

    if (this->size()==this->count())
    {
        this->resize(this->size()+25);
    }

    this->QDict<QPixmap>::insert(key,temp);
 
    return true;
}
