/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   icons.cc 
*
*   this object holds all the icons.
*
*****************************************************************************/

#include "icons.h"

#include <qpixmap.h>

// xpm files of the actual icons
#include "checkmark.xpm"
#include "host.xpm"
#include "hostConnected.xpm"
#include "group.xpm"
#include "syncon.xpm"
#include "socket.xpm"
#include "xmark.xpm"

icons::icons(char *path, int size = 9973)
	: QDict<QPixmap>(size, false) 
{
    this->insert("checkmark", checkmark_xpm);
    this->insert("olympus", host_xpm);
    this->insert("olympus-defaultItem", host_xpm);
    this->insert("olympus-hostItem", host_xpm);
    this->insert("olympus-hostItemConnected", hostConnected_xpm);
    this->insert("olympus-groupItem", group_xpm);
    this->insert("olympus-syncon", syncon_xpm);
    this->insert("plugin-default", socket_xpm);
    this->insert("xmark", xmark_xpm);
    setAutoDelete(true);
}

icons::~icons(){
    this->QDict<QPixmap>::clear();
}
