/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   find.cc 
*   
*   these methods determine if an icon exists in the icon object
*
*****************************************************************************/

#include "icons.h"

#include <qpixmap.h>
#include <qstring.h>

QPixmap *icons::find(const char *key) 
{ 
    QString qkey(key);
    return find(qkey);
}

QPixmap *icons::find(const QString &key) 
{ 
    return this->QDict<QPixmap>::find(key);
}
  
bool icons::find(const char *key, QPixmap &pixmap) 
{
    QString qkey(key);
    return find(qkey,pixmap);
}

bool icons::find(const QString &key, QPixmap &pixmap) 
{
    if (key.isEmpty())
    {
        return false;
    }  

    QPixmap *temp = this->QDict<QPixmap>::find(key);

    if (temp && !temp->isNull())
    {
        pixmap = *temp;
        return true;
    }
    
    return false;
}
