/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   properties.cc 
*
*   a window to edit the properties of this host.
*
*****************************************************************************/
	

#include "olympus.h"
#include "hostObj.h"
#include "groupObj.h"
#include "module.h"
#include "moduleList.h"
#include "regexx.hh"
#include "split.hh"

#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qtabdialog.h>

void hostObj::properties()
{
    QTabDialog* propertyBox = new QTabDialog(0, "Properties of " + *commonName, true);
    propertyBox->setOkButton();
    propertyBox->setCancelButton();
    
    QWidget* propertyPage = new QWidget(0,"property page");
    
    QLabel*  commonNameLabel = new QLabel(propertyPage);
    commonNameLabel->setText("Name Of This Host");
    QLineEdit *propBoxCommonName = new QLineEdit(propertyPage,"newCommonName");
    propBoxCommonName->setText(*commonName);
    propBoxCommonName->selectAll();
    
    QLabel* hostnameLabel = new QLabel(propertyPage);
    hostnameLabel->setText("Hostname or IP Address");
    QLineEdit* propBoxHostname = new QLineEdit(propertyPage,"newHostname");
    propBoxHostname->setText(*hostname);
    
    QLabel*  portLabel = new QLabel(propertyPage);
    portLabel->setText("Port");
    QLineEdit* propBoxPort = new QLineEdit(propertyPage,"newPortName");
    QString currentPort;
    currentPort.setNum(port);
    propBoxPort->setText(currentPort);
    
    QLabel*  usernameLabel = new QLabel(propertyPage);
    usernameLabel->setText("Username");
    QLineEdit* propBoxUsername = new QLineEdit(propertyPage,"username");
    propBoxUsername->setText(*username);
    
    QLabel*  passwordLabel = new QLabel(propertyPage);
    passwordLabel->setText("Password");
    QLineEdit* propBoxPassword = new QLineEdit(propertyPage,"password");
    propBoxPassword->setText(*password);
    propBoxPassword->setEchoMode(QLineEdit::Password);
    
    QCheckBox* propBoxSavePassword = new QCheckBox("Save Password",propertyPage,"passwordCheck");
    if (keepPassword)
    {
        propBoxSavePassword->setChecked(true);
    }
    
    QGridLayout * propertyGrid = new QGridLayout(propertyPage,12,5);
    propertyGrid->addColSpacing(0,10);
    propertyGrid->addColSpacing(1,300);
    propertyGrid->addColSpacing(2,10);
    propertyGrid->addColSpacing(3,100);
    propertyGrid->addColSpacing(4,10);
    propertyGrid->addRowSpacing(0,10);
    propertyGrid->addWidget(commonNameLabel,1,1);
    propertyGrid->addWidget(propBoxCommonName, 2, 1);
    propertyGrid->addRowSpacing(3,10);
    propertyGrid->addWidget(hostnameLabel,4,1);
    propertyGrid->addWidget(propBoxHostname, 5, 1);
    propertyGrid->addWidget(portLabel,4,3);
    propertyGrid->addWidget(propBoxPort,5,3);
    propertyGrid->addRowSpacing(6,10);
    propertyGrid->addWidget(usernameLabel,7,1);
    propertyGrid->addWidget(propBoxUsername,8,1);
    propertyGrid->addRowSpacing(9,10);
    propertyGrid->addWidget(passwordLabel,10,1);
    propertyGrid->addWidget(propBoxPassword,11,1);
    propertyGrid->addWidget(propBoxSavePassword,11,3);
    propertyGrid->addRowSpacing(12,10);
    
    propertyBox->addTab(propertyPage,"Host Information");
    

    /*
    //  The modules tab...
    */

    QWidget * modulePage = new QWidget(0,"module page");
    QGridLayout *gridTwo = new QGridLayout(modulePage, 6, 0);

    QListView* defaultModulesList = new QListView(modulePage);
    defaultModulesList->addColumn("Plugin");
    defaultModulesList->addColumn("Description");
    defaultModulesList->setRootIsDecorated(true);
    
 
    defaultModulesList->setPalette(*client->listPalette);
    //defaultModulesList->setFrameStyle(StyledPanel | Sunken);

    ////////////////////////////////////////////////////////////////////////
    /// I consider this entire section to be a 'hack' eck! it works... but
    /// it really needs to me redone (Update... it's little better ;) still gross thou
    ////////////////////////////////////////////////////////////////////////
    QDictIterator<module> it(*client->modules);
    QListViewItem *thisNewGroup;
    QCheckListItem *thisNewItem;
    bool tempBool;

    thisNewGroup = new QListViewItem(defaultModulesList, "Olympus");
    thisNewGroup->setOpen(true);
    thisNewGroup->setExpandable(true);
    thisNewGroup = new QListViewItem(thisNewGroup, "Olympus Admin");
    thisNewGroup->setText(1,*client->modules->find("Olympus Admin")->getDescription());
    
    for ( ; it.current(); ++it )
    {
        if (*it.current()->getName() == "Olympus Admin") { continue; }
        
        tempBool = false;
        QListViewItem * groupToUse;
        
        // if we have groups in the list, see if we have the one we want
        if (defaultModulesList->firstChild())
        {
            groupToUse = defaultModulesList->firstChild();
            
            // loop through the groups one by one and compare.          
            while (groupToUse && ! tempBool)
            {
                if (groupToUse->text(0) == *it.current()->getGroup())
                {
                    tempBool = TRUE;
                    break;
                }
                groupToUse = groupToUse->nextSibling();
            }
        }
        
        // if there is a group, we don't need to make one
        if (tempBool)
        {
            thisNewItem = new QCheckListItem(groupToUse, it.current()->getName()->data(), QCheckListItem::CheckBox);
        }
        else // but there isn't in this case, so we make a new group in the list.
        {
            thisNewGroup = new QListViewItem(defaultModulesList, it.current()->getGroup()->data());
            thisNewGroup->setOpen( TRUE );
            thisNewItem = new QCheckListItem(thisNewGroup , it.current()->getName()->data(), QCheckListItem::CheckBox);
        }
            
        // set the second column of text to the description of the module
        thisNewItem->setText(1,*it.current()->getDescription());
        
        moduleList *thisModule = firstModule;
        while (thisModule)
        {
            #ifdef DEBUG_HOSTPREFS
                debug("thisModule -> %s", thisModule->getModule()->getName()->data());
                debug("it.current() -> %s", it.current()->getName()->data());
            #endif
            
            // Is it a default Modules?
            if (*thisModule->getModule()->getName() == *it.current()->getName())
            {
                thisNewItem->setOn(true);
            }
            
            thisModule = thisModule->getNextModule();
        }
    }
    
    gridTwo->addWidget(defaultModulesList, 1, 0);
    propertyBox->addTab(modulePage,"Plugins");
    
    /*
    //  End of the modules tab...
    */
    
    propertyBox->setFixedSize(propertyPage->sizeHint());
    
    propertyBox->showPage(propertyPage);
    propBoxCommonName->setFocus();
    propertyBox->show();
    
    if (propertyBox->result() == QDialog::Rejected) 
    {  
        if (dirty == true) { delete this; }
        return;
    }
    
    // and then when we come back
    if (propBoxCommonName->text() != "")
    {
        setCommonName(propBoxCommonName->text());
    }
    
    if (propBoxHostname->text() != "")
    {
        setHostname(propBoxHostname->text());
    }
    
    if (propBoxPort->text() != "")
    {
        setPort(propBoxPort->text().toUShort());
    }
    
    if (propBoxUsername->text() != "")
    {
        setUsername(propBoxUsername->text());
    }
    
    if (propBoxPassword->text() != "")
    {
        setPassword(propBoxPassword->text());
    }
    
    if (propBoxSavePassword->isChecked())
    {
        setPasswordSave(true);
    }
    else
    {
        setPasswordSave(false);   
    }
    
    // take care of the module list
    if (firstModule != NULL)
    {
        moduleList *thisMod = firstModule;
        moduleList *tmp;
        
        // go to the end of the list
        while (thisMod->getNextModule())
        {
            thisMod = thisMod->getNextModule();
        }
        
        while (thisMod->getPrevModule() != NULL)
        {
            tmp = thisMod->getPrevModule();
            removeModule(thisMod->getModuleName());
            thisMod = tmp;
        }
        
        // snag the last one
        removeModule(thisMod->getModuleName());
    }

    if (client->modules->find("Olympus Admin"))
    {
        addModule(client->modules->find("Olympus Admin"));
    }
    
    moduleList *tempModule = client->defaultModules;
    module *newModules;
    QListViewItemIterator its (defaultModulesList);
    while(its.current())
    {
        if (its.current()->depth() > 0 && 
            its.current()->text(0) != "Olympus Admin" &&
            ((QCheckListItem *)its.current())->isOn())
        {
            if ((newModules = client->modules->find(its.current()->text(0).data())) > 0)
            {
                addModule(newModules);
             }
        }
        
        ++its;
    }


    // these are used in the properties box...
    delete propertyBox;
    
    emit propsChanged();
    dirty = false;
}