/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   network.cc 
*
*   methods for accessing hosts over the network
*
*****************************************************************************/
	
#include "hostObj.h"
#include "guisocket.h"

#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>

#define DEBUG_HOSTOBJNET

void hostObj::connect()
{    
    #ifdef DEBUG_HOSTOBJNET
        debug("");
        debug("hostObj >>  connect start");
    #endif

    // add the login here
    while (username->length() < 1 || password->length() < 1)
    {
        #ifdef DEBUG_HOSTOBJNET
            debug("hostObj >>  need login info...");
        #endif

        getLoginInfo();
    }
    if (! connected)
    {
        #ifdef DEBUG_HOSTOBJNET
            debug("hostObj >>  connecting to the target...");
        #endif

        network->connect();
    }

    #ifdef DEBUG_HOSTOBJNET
        debug("hostObj >>  connect stop");
        debug("");
    #endif
}

void hostObj::disconnect()
{
    if (connected)
    {
        network->disconnect();
    }
}

bool hostObj::isConnected()
{
    return connected;
}

void hostObj::setConnected(bool connectionStat)
{
    #ifdef DEBUG_HOSTOBJNET
        debug("");
        debug("hostObj >> setConnected >>  setting connect state... %i", connectionStat);
    #endif

    connected = connectionStat;   

    if (connectionStat) { 
        #ifdef DEBUG_HOSTOBJNET
            debug("hostObj >> setConnected >>  emitting connectionOpenned...");
        #endif

        emit connectionOpenned(); 
    }
    else 
    { 
        #ifdef DEBUG_HOSTOBJNET
            debug("hostObj >> setConnected >>  emitting connectionClosed...");
        #endif

        emit connectionClosed(); 
    }

    #ifdef DEBUG_HOSTOBJNET
        debug("hostObj >> setConnected >>  finished setting connection state...");
        debug("");
    #endif
}

void hostObj::getLoginInfo()
{
    if (newUsername != NULL) { return; }
    
    QDialog *getLogin = new QDialog(0,"login info", true);
    getLogin->setCaption("Login Information");

    QLabel *topText = new QLabel(getLogin);
    topText->setText((QString) "Enter your username and password for " + *commonName);
    QLabel *usernameText = new QLabel(getLogin);
    usernameText->setText("Username:");
    newUsername = new QLineEdit(getLogin);
    if (username != NULL) { newUsername->setText(*username); }
    QLabel *passwordText = new QLabel(getLogin);
    passwordText->setText("Password:");
    newPassword = new QLineEdit(getLogin);
    newPassword->setText(*password);
    newPassword->setEchoMode(QLineEdit::Password);
    QPushButton *loginButton = new QPushButton(getLogin);
    loginButton->setText("Login Now");

    QObject::connect(newPassword, SIGNAL(returnPressed()), getLogin, SLOT(accept()));
    QObject::connect(loginButton, SIGNAL(clicked()), getLogin, SLOT(accept()));
/*    QObject::connect(newPassword, SIGNAL(returnPressed()), this, SLOT(getLoginUpdater()));
    QObject::connect(loginButton, SIGNAL(clicked()), this, SLOT(getLoginUpdater()));*/

    QGridLayout *loginGrid = new QGridLayout(getLogin,9,5);
    loginGrid->addColSpacing(0,10);	
    loginGrid->addColSpacing(2,5);	
    loginGrid->addColSpacing(4,10);	

    loginGrid->addRowSpacing(1,10);
    loginGrid->addMultiCellWidget(topText,1,1,1,3,QGridLayout::AlignCenter);
    loginGrid->addRowSpacing(2,5);
    loginGrid->addWidget(usernameText,3,1);
    loginGrid->addWidget(newUsername,3,3);
    loginGrid->addRowSpacing(4,5);
    loginGrid->addWidget(passwordText,5,1);
    loginGrid->addWidget(newPassword,5,3);
    loginGrid->addRowSpacing(6,5);
    loginGrid->addMultiCellWidget(loginButton,7,7,1,3,QGridLayout::AlignCenter);

    if (getLogin->exec())
    {
        username->truncate(0);
        username->append(newUsername->text());
        password->truncate(0);
        password->append(newPassword->text());
    }

    delete newUsername;
    newUsername = NULL;
    delete newPassword;
    newPassword = NULL;
    
    delete getLogin;
}

void hostObj::getLoginUpdater()
{
    #ifdef DEBUG_HOSTOBJNET
        debug("");
        debug("Host Obj >>  Network >>  getLoginUpdater >>  updating username/password");
    #endif

    username->remove(0,-1);
    username->append(newUsername->text());
    password->remove(0,-1);
    password->append(newPassword->text());

    #ifdef DEBUG_HOSTOBJNET
        debug("Host Obj >>  Network >>  getLoginUpdater >>  cleaning up memory");
    #endif

    delete newUsername;
    newUsername = NULL;
    delete newPassword;
    newPassword = NULL;

    #ifdef DEBUG_HOSTOBJNET
        debug("Host Obj >>  Network >>  getLoginUpdater >>  completed updating username/password");
        debug("");
    #endif
}

transport *hostObj::getRawSocket()
{
    return network->getSocket();
}
