/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   modules.cc 
*	
*   all the methods to attach, remove and get modules...
*
*****************************************************************************/

#include "hostObj.h"
#include "module.h"
#include "moduleList.h"

//#define DEBUG_HOST

void hostObj::addModule(module *newModule)
{
    if (newModule == NULL) { return; }
    
    if (firstModule != NULL)
    {
        #ifdef DEBUG_HOST
            debug("hostObj::addModule >>  we have a first module, so we're adding it to the end");
        #endif		

        moduleList * temp = firstModule; // store current first module temporarily
        while (temp != NULL) // make sure we don't put in a duplicate
        {
            if (*temp->getModule()->getName() == *newModule->getName())
            {
                #ifdef DEBUG_HOST
                    debug("hostObj::addModule >>  module by that name already exists");
                #endif		
                return;
            }
            else
            {
                temp = temp->getNextModule();
            }
        }

        temp = firstModule; // store current first module temporarily
        firstModule = new moduleList(newModule, temp); // firstModule = new mod
        temp->setPrevModule(firstModule); // reset the prev mod to the new mod
    }
    else
    {
        #ifdef DEBUG_HOST
            debug("hostObj::addModule >>  we have no first mod, now adding first mod");
        #endif
        firstModule = new moduleList(newModule);
    }

    emit modulesChanged();
}

void hostObj::removeModule(const char *moduleName)
{
    QString *temp = new QString(moduleName);
    removeModule(temp);
    delete temp;
}

void hostObj::removeModule(QString *moduleName)
{
    moduleList *thisModule = firstModule;
    moduleList *next;

    while (thisModule != NULL)
    {
        if (*thisModule->getModuleName() == *moduleName)
        {
            if (thisModule == firstModule) { firstModule = thisModule->getNextModule(); }	
            
            /* we could just return at the end of this block of code..
               but then if there were multiples (which shouldn't be possible.. but...)
               we wouldn't catch them all... and its a fairly cheap op... */
               
            next = thisModule->getNextModule();
            delete thisModule;
            thisModule = next;
            emit modulesChanged();
        }
        else { thisModule = thisModule->getNextModule(); }
    }
}

bool hostObj::moduleExists(const char *moduleName)
{
    return moduleExists((QString *)moduleName);
}

bool hostObj::moduleExists(QString *moduleName)
{
    moduleList * thisModule = firstModule;

    while (thisModule != NULL)
    {
        if (thisModule->getModuleName() == moduleName)
        {
            return true;
        }
        thisModule = thisModule->getNextModule();
    }
    return false;
}

moduleList *hostObj::getFirstModule()
{
    return firstModule;
}

void hostObj::clearFirstModule()
{
    firstModule = NULL;
}
