/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   hostObj.cc 
*   
*   this holds the information tied to each object
*
*****************************************************************************/

#include "olympus.h"
#include "hostObj.h"
#include "module.h"
#include "moduleList.h"
#include "guisocket.h"
#include "groupObj.h"

#include <qlineedit.h>
#include <qmessagebox.h>
#include <qpixmap.h>

//#define DEBUG_HOST_1
//#define DEBUG_HOST_2

hostObj::hostObj(groupObj* parentObj,
                 bool prompt,
                 const char* newCommonName, 
                 const char* newHostname,
                 unsigned short newPort = 0)
    : QObject()
{
    #ifdef DEBUG_HOST_1
        debug("hostObj::hostObj() -> start of constructor");
    #endif
    
    #ifdef DEBUG_HOST_2
        debug("newHostName=%s", newHostname);
        debug("newCommonName=%s", newCommonName);
        debug("newPort=%i", newPort);
    #endif
    
    nextHost = NULL;
    prevHost = NULL;
    parentGroup = NULL;
    
    if (newCommonName != NULL)
    {
        commonName = new QString(newCommonName);
    }
    else
    {
        commonName = new QString(*client->prefs->find("defaultCommonName"));    
    }
    
    if (newHostname)
    {
        hostname = new QString(newHostname);
    }
    else
    {
        hostname = new QString(*client->prefs->find("defaulthostname"));    
    }
    
    if (newPort)
    {
        port = newPort;
    }
    else
    {
        port =  client->prefs->find("defaultPort")->toUInt();
    }
    
    // default login shtuff
    username = new QString();
    password = new QString();
    newUsername = NULL;
    newPassword = NULL;
    keepPassword = false;
    connected = false;
    
    /* start out with the default set of modules */
    firstModule = new moduleList(client->defaultModules->getModule());
    moduleList * currentModule = firstModule;
    moduleList * defaultModules = client->defaultModules->getNextModule();
    while (defaultModules)
    {
        new moduleList(defaultModules->getModule(),NULL,currentModule);
        currentModule = currentModule->getNextModule();
        defaultModules = defaultModules->getNextModule();
    }

    network = new guisocket(this);
    QObject::connect(network, SIGNAL(connectionSignal(bool)),
                     this, SLOT(setConnected(bool)));
                                 
    parentObj->parent(this);
    
    if (prompt == true)
    {
        dirty = true;
        properties();
    }
    
    #ifdef DEBUG_HOST_1
        debug("hostObj::hostObj() -> end of constructor");
    #endif
}

hostObj::hostObj(groupObj* parentObj,
                 bool prompt,
                 QString *newCommonName = NULL, 
                 QString *newHostname = NULL,
                 unsigned short newPort = 0)
    : QObject()
{
    #ifdef DEBUG_HOST_1
        debug("hostObj::hostObj() -> start of constructor");
    #endif
    
    nextHost = NULL;
    prevHost = NULL;
    parentGroup = NULL;
 
    if (newCommonName)
    {
        commonName = new QString(*newCommonName);
    }
    else
    {
        commonName = new QString(*client->prefs->find("defaultCommonName"));    
    }
    
    if (newHostname)
    {
        hostname = new QString(*newHostname);
    }
    else
    {
        hostname = new QString(*client->prefs->find("defaulthostname"));    
    }
    
    if (newPort)
    {
        port = newPort;
    }
    else
    {
        port = client->prefs->find("defaultPort")->toUInt();
    }
    
    // default login shtuff
    username = new QString();
    password = new QString();
    newUsername = NULL;
    newPassword = NULL;
    keepPassword = false;
    connected = false;
    
    /* start out with the default set of modules */
    firstModule = new moduleList(client->defaultModules->getModule());
    moduleList *currentModule = firstModule;
    moduleList *newModule;
    moduleList *defaultModules = client->defaultModules->getNextModule();
    
    while (defaultModules)
    {
        newModule = new moduleList(defaultModules->getModule(),currentModule);
        currentModule->setNextModule(newModule);
        currentModule = newModule;
        defaultModules = defaultModules->getNextModule();
    }

    network = new guisocket(this);

    QObject::connect(network, SIGNAL(connectionSignal(bool)),
                     this, SLOT(setConnected(bool)));
                     
    
    parentObj->parent(this);
    
    if (prompt == true)
    {
        dirty = true;
        properties();
    }

    #ifdef DEBUG_HOST_1
        debug("hostObj::hostObj() -> end of constructor");
    #endif
}

int hostObj::destroy(int deleteStatus)
{
    if (deleteStatus < 2)
    {
    	QMessageBox * confirmDeleteBox = new QMessageBox ( 
									"Olympus: Confirm Delete", 
									"Delete " + *commonName + "?", 
									QMessageBox::Critical, 
									1, 
									2, 
									3 | QMessageBox::Default | QMessageBox::Escape );
	    confirmDeleteBox->setButtonText( 1, "Yes");
    	confirmDeleteBox->setButtonText( 2, "Yes To All");
	    confirmDeleteBox->setButtonText( 3, "No");
	    confirmDeleteBox->setText("Delete host " + *commonName + "?");
	    deleteStatus = confirmDeleteBox->exec();
	    
	    if (deleteStatus == 3) { deleteStatus = 0; }	    
    }
    
    if (deleteStatus > 0)
    {
        emit doomed(true);
    }
    
    return deleteStatus;
}

hostObj::~hostObj()
{
    #ifdef DEBUG_HOST_1
        debug("hostObj::~hostObj() -> start of deconstructor");
    #endif

    if (parentGroup != NULL) { parentGroup->deparent(this); }
    
    if (firstModule)
    {
        moduleList *thisMod = firstModule;
        // go to the end of the list
        while (thisMod->getNextModule())
        {
            thisMod = thisMod->getNextModule();
        }
        // go through the list backwards one by one to the end
        while (thisMod->getPrevModule())
        {
            thisMod = thisMod->getPrevModule();
            delete thisMod->getNextModule();
        }
    }
        
        // take out the network
    delete network;
    delete username;
    delete password;
    delete hostname;
    delete commonName;
    if (newUsername != NULL) { delete newUsername; }
    if (newPassword != NULL) { delete newPassword; }
    
    emit lastCall();
    
    #ifdef DEBUG_HOST_1
        debug("hostObj::~hostObj() -> end of deconstrucor");
    #endif
}

void hostObj::weAreDoomed(bool doomState) { emit doomed(doomState); }