/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   hostGroup.h 
*   
*   A class for groups of machines. They appear in the left pane of the main
*   client window.
*
*****************************************************************************/

#include "hostItem.h"
#include "mainListView.h"
#include "hostGroup.h"
#include "icons.h"
#include "hostObj.h"

#include <qpixmap.h>

//#define DEBUG_HOSTITEM

hostItem::hostItem(mainListView *listView, hostObj* object,  const char *hostName)  
    : QListViewItem(listView, listView->nextHostPos((char*) hostName), hostName)
{
    doom = false;
    host = object;
    QPixmap itemIcon;
    
    
    // make a pixmap.. comes out of the icon_small
    if (host->isConnected())
    {
        icon_small->find("olympus-hostItemConnected",itemIcon);
    }
    else
    {
        icon_small->find("olympus-hostItem",itemIcon);
    }
    
    if (itemIcon.isNull()==false)
    {
        this->setPixmap(0,itemIcon);
        this->setHeight(itemIcon.height()+4);
    }
    QObject::connect(host, SIGNAL(connectionOpenned()), this, SLOT(stateOpen()));
    QObject::connect(host, SIGNAL(connectionClosed()), this, SLOT(stateClosed()));
    QObject::connect(host, SIGNAL(doomed(bool)), this, SLOT(doomed(bool)));
    QObject::connect(host, SIGNAL(propsChanged()), this, SLOT(propsChanged()));
}

hostItem::hostItem(hostGroup *hostGroup, hostObj* object, const char *hostName) 
    : QListViewItem((QListViewItem *)hostGroup, hostGroup->nextHostPos((char*) hostName), hostName)
{
    doom = false;
    host = object;
    QPixmap itemIcon;
    
    
    // make a pixmap.. comes out of the icon_small
    if (host->isConnected())
    {
        icon_small->find("olympus-hostItemConnected",itemIcon);
    }
    else
    {
        icon_small->find("olympus-hostItem",itemIcon);
    }
    
    if (itemIcon.isNull()==false)
    {
        this->setPixmap(0,itemIcon);
        this->setHeight(itemIcon.height()+4);
    }
    
    QObject::connect(host, SIGNAL(connectionOpenned()), this, SLOT(stateOpen()));
    QObject::connect(host, SIGNAL(connectionClosed()), this, SLOT(stateClosed()));
    QObject::connect(host, SIGNAL(doomed(bool)), this, SLOT(doomed(bool)));
    QObject::connect(host, SIGNAL(propsChanged()), this, SLOT(propsChanged()));
}

hostItem::~hostItem()
{
}

void hostItem::stateOpen()
{
    QPixmap itemIcon;

    // make a pixmap.. comes out of the icon_small
    icon_small->find("olympus-hostItemConnected",itemIcon);
    
    if (itemIcon.isNull()==false)
    {
        this->setPixmap(0,itemIcon);
        this->setHeight(itemIcon.height()+4);
    }
}

void hostItem::stateClosed()
{
    QPixmap itemIcon;

    // make a pixmap.. comes out of the icon_small
    icon_small->find("olympus-hostItem",itemIcon);
    
    if (itemIcon.isNull()==false)
    {
        this->setPixmap(0,itemIcon);
        this->setHeight(itemIcon.height()+4);
    }
}

bool hostItem::isDoomed() { return doom; }

void hostItem::propsChanged()
{
    setText(0, *host->getCommonName());
}

void hostItem::doomed(bool doomState)
{
    doom = doomState;
}