/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   hostGroup.cc 
*   
*   A class for groups of machines. They appear in the left pane of the main
*   client window.
*
*****************************************************************************/

#include "hostGroup.h"
#include "hostItem.h"
#include "hostObj.h"
#include "groupObj.h"
#include "mainListView.h"
#include "icons.h"

#include <qpixmap.h>

hostGroup::hostGroup(mainListView *listView, groupObj* thisObj, const char *groupName)
    : QObject(listView), QListViewItem(listView, listView->nextGroupPos((char*) groupName), groupName)
{
    QPixmap itemIcon;
    
    limbo = dirtyHosts = dirtyGroups = doom = false;
    
    this->mainList = listView;
    this->setExpandable(true);
    this->group = thisObj;
    QObject::connect(thisObj, SIGNAL(updatedHosts()),
                     this, SLOT(loadHosts()));
    QObject::connect(thisObj, SIGNAL(updatedAll()),
                     this, SLOT(loadHosts()));
    QObject::connect(thisObj, SIGNAL(updatedGroups()),
                     this, SLOT(loadGroups()));
    QObject::connect(thisObj, SIGNAL(updatedGroups()),
                     this, SLOT(loadGroups()));
    QObject::connect(thisObj, SIGNAL(nameChanged(QString*)),
                     this, SLOT(nameChange(QString*)));
    QObject::connect(thisObj, SIGNAL(doomed(bool)),
                     this, SLOT(doomed(bool)));
    QObject::connect((mainListView*) listView, SIGNAL(enterLimbo()),
                     this, SLOT(enterLimbo()));
    QObject::connect((mainListView*) listView, SIGNAL(exitLimbo()),
                     this, SLOT(exitLimbo()));
    
    // make a pixmap.. comes out of the icon_small
    icon_small->find("olympus-groupItem",itemIcon);
    
    if (itemIcon.isNull()==false)
    {
        this->setPixmap(0,itemIcon);
        this->setHeight(itemIcon.height()+4);
    }
    
    loadHosts();
    loadGroups();
}


hostGroup::hostGroup(hostGroup *hostGroup, groupObj* thisObj, const char *groupName) 
    : QObject(hostGroup), QListViewItem(hostGroup, hostGroup->nextGroupPos((char*) groupName), groupName)
{
    this->mainList = hostGroup->mainList;
    this->setExpandable(true);
    this->group = thisObj;
    limbo = dirtyHosts = dirtyGroups = doom = false;
    
    QObject::connect(thisObj, SIGNAL(updatedHosts()),
                     this, SLOT(loadHosts()));
    QObject::connect(thisObj, SIGNAL(updatedAll()),
                     this, SLOT(loadHosts()));
    QObject::connect(thisObj, SIGNAL(updatedGroups()),
                     this, SLOT(loadGroups()));
    QObject::connect(thisObj, SIGNAL(updatedGroups()),
                     this, SLOT(loadGroups()));
    QObject::connect(thisObj, SIGNAL(nameChanged(QString*)),
                     this, SLOT(nameChange(QString*)));
    QObject::connect(thisObj, SIGNAL(doomed(bool)),
                     this, SLOT(doomed(bool)));
    QObject::connect((mainListView*) listView(), SIGNAL(enterLimbo()),
                     this, SLOT(enterLimbo()));
    QObject::connect((mainListView*) listView(), SIGNAL(exitLimbo()),
                     this, SLOT(exitLimbo()));
                     
    // make a pixmap.. comes out of the icon_small
    QPixmap itemIcon;
    icon_small->find("olympus-groupItem",itemIcon);
    
    if (itemIcon.isNull()==false)
    {
        this->setPixmap(0,itemIcon);
        this->setHeight(itemIcon.height()+4);
    }

    loadHosts();
    loadGroups();
}

hostGroup::~hostGroup() {}

void hostGroup::loadHosts() 
{
    if (limbo == true) { dirtyHosts = true; return; }
    
    int numChildren = childCount();
    int i = 0;
    QListViewItem* deletions = firstChild();
    QListViewItem* temp;
    hostObj* hosts;  
    groupObj* groups;
    hostGroup* newGroup;
    
    for (; i < numChildren; i++)
    {
       temp = deletions->nextSibling();
       if (deletions->isExpandable() == false) { delete deletions; }
       deletions = temp;
    }

    hosts = group->getFirstChild();
    
    while (hosts != NULL)
    {
        new hostItem(this, hosts, hosts->getCommonName()->data());
        hosts = hosts->getNext();
    }
    
    dirtyHosts = false;
}

void hostGroup::loadGroups()
{
    if (limbo == true) { dirtyGroups = true; return; }
    
    int numChildren = childCount();
    int i = 0;
    groupObj* groups;
    QListViewItem* deletions = firstChild();
    QListViewItem* temp;
    
    for (; i < numChildren; i++)
    {
       temp = deletions->nextSibling();
       if (deletions->isExpandable() == true) { delete deletions; }
       deletions = temp;
    }

    groups = group->getChildGroup();
    
    while (groups != NULL)
    {
        new hostGroup(this, groups, groups->getName()->data());
        groups = groups->getNext();
    }
    
    dirtyGroups = false;
}

void hostGroup::enterLimbo()
{
    limbo = true;
}

void hostGroup::exitLimbo()
{
    limbo = false;
    if (dirtyHosts) { loadHosts(); }
    if (dirtyGroups) { loadGroups(); }
}

bool hostGroup::inLimbo() { return limbo; }
        
void hostGroup::dirty(int whatToDirty)
{
    if (whatToDirty == ALLCHILDREN) { dirtyHosts = dirtyGroups = true; }
    else if (whatToDirty == HOSTS) { dirtyHosts = true; }
    else if (whatToDirty == GROUPS) { dirtyGroups = true; }
    else if (whatToDirty == NONE) { dirtyHosts = dirtyGroups = false; }    
}

int  hostGroup::whatsDirty()
{
    if (dirtyHosts) 
    {
        if (dirtyGroups) { return ALLCHILDREN; }
        else { return HOSTS; }
    }
    else if (dirtyGroups) { return GROUPS; }
    else { return NONE; }
}

QListViewItem* hostGroup::nextGroupPos(char* name)
{
    QListViewItem* groupie = NULL;
    QListViewItem* marker = firstChild();
    int numChildren = childCount();
    int i = 0;
    
    while(i < numChildren && marker != NULL && 
          marker->isExpandable() == true && marker->text(0) < name) 
    { groupie = marker;  marker = marker->nextSibling();  i++; }
   
    return groupie;
}

QListViewItem* hostGroup::nextHostPos(char* name)
{
    QListViewItem* target = NULL;
    QListViewItem* marker = firstChild();
    int numChildren = childCount();
    int i = 0;
    
    while(i < numChildren && marker != NULL && marker->isExpandable() == true) 
    { target = marker;  marker = marker->nextSibling();  i++; }
    
    while(i < numChildren && marker != NULL && marker->text(0) < name) 
    { target = marker;  marker = marker->nextSibling();  i++; }
    return target;
}

void hostGroup::nameChange(QString* newName)
{
    setText(0, *newName);
}

void hostGroup::doomed(bool doomState)
{
    doom = doomState;
}


bool hostGroup::isDoomed() { return doom; }
