/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*   
*   groupObj.cc
*	
*	a class to hold together a tree of hostObjs
*
*   Aaron J. Seigo <aseigo@mountlinux.com>
*****************************************************************************/

#include "groupObj.h"
#include "hostObj.h"

#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qpushbutton.h>

groupObj::groupObj(groupObj* parent = NULL, QString* newName = NULL)
{
    parentGroup= NULL; 
    nextGroup = NULL;
    prevGroup = NULL;
    childGroup = NULL;
    firstChild = NULL;
    name = NULL;
    
    if (newName != NULL) { dirty = false; name = new QString(*newName); }
    else { dirty = true; properties(); }
    
    if (parent != NULL) 
    {
        parent->parent(this); 
        QObject::connect(parent, SIGNAL(doomed(bool)),
                         this, SLOT(weAreDoomed(bool)));
    }    
}

groupObj::~groupObj()
{
    if (parentGroup != NULL) { parentGroup->deparent(this); }
    if (name != NULL) { delete name; }
    emit lastCall();
}

hostObj* groupObj::getFirstChild() { return firstChild; }
groupObj* groupObj::getChildGroup() { return childGroup; }
        
groupObj* groupObj::getNext() { return nextGroup; }
void groupObj::setNext(groupObj* next) { nextGroup = next; }
        
groupObj* groupObj::getPrev() { return prevGroup; }
void groupObj::setPrev(groupObj* prev) { prevGroup = prev; }

groupObj* groupObj::getParentGroup() { return parentGroup; }
void groupObj::setParentGroup(groupObj* parent) { parentGroup = parent; }
        
void groupObj::parent(hostObj* child)
{
    if (child->getParent() != NULL) { child->getParent()->deparent(child); }
    child->setParent(this);
    
    if (firstChild == NULL) { firstChild = child; }
    else
    {
        hostObj* children = firstChild;
        while (children->getNext() != NULL) { children = children->getNext(); }
        child->setPrev(children);
        children->setNext(child);
    }
    
    QObject::connect(this, SIGNAL(doomed(bool)),
                     child, SLOT(weAreDoomed(bool)));
        
    emit updatedHosts();
}
        
void groupObj::parent(groupObj* child)
{
    if (child == NULL) { return; }
            
    if (child->getParentGroup() != NULL) { child->getParentGroup()->deparent(child); }
    child->setParentGroup(this);

    if (childGroup == NULL) { childGroup = child; }
    else
    {
        groupObj* children = childGroup;
        while (children->getNext() != NULL) { children = children->getNext(); }
        child->setPrev(children);
        children->setNext(child);
    }

   
    QObject::connect(this, SIGNAL(doomed(bool)),
                     child, SLOT(weAreDoomed(bool)));
        
    emit updatedGroups();
}
        
void groupObj::deparent(hostObj* child)
{
    QObject::disconnect(this, SIGNAL(doomed(bool)),
                        child, SLOT(weAreDoomed(bool)));
    
    if (child == firstChild)
    {
        if (child->getNext() != NULL) { firstChild = child->getNext(); }
        else { firstChild = NULL; }
    }
    else
    {
        hostObj* children = firstChild;
        
        while (children != NULL)
        {
            if (children == child)
            {
                if (child->getPrev() != NULL)
                {
                    child->getPrev()->setNext(child->getNext());
                }
            
                if (child->getNext() != NULL)
                {
                    child->getNext()->setPrev(child->getPrev());
                }
            
                break;
            }
            else { children = children->getNext(); }
        }
    }

    child->setNext(NULL);
    child->setPrev(NULL);
    
    emit updatedHosts();
}
        
void groupObj::deparent(groupObj* child)
{
    QObject::disconnect(this, SIGNAL(doomed(bool)),
                        child, SLOT(weAreDoomed(bool)));

    if (child == childGroup)
    {
        if (child->getNext() != NULL) { childGroup = child->getNext(); }
        else { childGroup = NULL; }
    }
    else
    {
        groupObj* children = childGroup;
        
        while (children != NULL)
        {
            if (children == child)
            {
                if (child->getPrev() != NULL)
                {
                    child->getPrev()->setNext(child->getNext());
                }
            
                if (child->getNext() != NULL)
                {
                    if (child == childGroup) { childGroup = child->getNext(); }
                    child->getNext()->setPrev(child->getPrev());
                }
            
                break;
            }
            else { children = children->getNext(); }
        }
    }
    
    child->setNext(NULL);
    child->setPrev(NULL);
    
    emit updatedGroups();
}

QString* groupObj::getName()
{
    return name;
}

void groupObj::setName(QString* newName)
{
    if (name == NULL) { name = new QString(*newName); }
    else
    {
        name->truncate(0);
        name->append(*newName);
        emit nameChanged(name);
    }
}

void groupObj::setName(char* newName)
{
    name->truncate(0);
    name->append(newName);
    emit nameChanged(name);
}

void groupObj::properties()
{
    QDialog* propBox = new QDialog(0, "Group Properties", true);
    
    
    QGridLayout* outerPropLayout = new QGridLayout(propBox, 0, 0, 0, 0, "groupObj::propLayout");
    QGridLayout* propLayout = new QGridLayout(propBox, 0, 0, 0, 0, "groupObj::propLayout");
    QGridLayout* buttonLayout = new QGridLayout(propBox, 0, 0, 0, 0, "groupObj::propLayout");
    

    
    QLabel* nameLabel = new QLabel(propBox, "groupObj::nameLabel");
    nameLabel->setText("Group Name: ");
    
    QLineEdit* nameEdit = new QLineEdit(propBox, "groupObj::nameEdit");
    if (name != NULL) { nameEdit->setText(*name); }
    QObject::connect(nameEdit, SIGNAL(returnPressed()), propBox, SLOT(accept()));
    
    QPushButton* okButton = new QPushButton(propBox, "groupObj::okButton");
    okButton->setText("OK");
    QObject::connect(okButton, SIGNAL(clicked()), propBox, SLOT(accept()));
    
    QPushButton* cancelButton = new QPushButton(propBox, "groupObj::cancelButton");
    cancelButton->setText("Cancel");
    cancelButton->setDefault(true);
    QObject::connect(cancelButton, SIGNAL(clicked()), propBox, SLOT(reject()));
    
    
    propLayout->addWidget(nameLabel, 1, 1);
    propLayout->addColSpacing(1, 5);
    propLayout->addWidget(nameEdit, 1, 3);
    
    buttonLayout->addColSpacing(0, cancelButton->size().width());
    buttonLayout->addWidget(okButton, 0, 0);
    buttonLayout->addColSpacing(1, 5);
    buttonLayout->addColSpacing(2, cancelButton->size().width());
    buttonLayout->addWidget(cancelButton, 0, 2);
    
    outerPropLayout->addColSpacing(0, 10);
    outerPropLayout->addColSpacing(2, 10);
    outerPropLayout->addRowSpacing(0, 10);
    outerPropLayout->addLayout(propLayout, 1, 1);
    outerPropLayout->addRowSpacing(2, 5);
    outerPropLayout->addLayout(buttonLayout, 3, 1);
    outerPropLayout->addRowSpacing(4, 10);
    
    nameEdit->setFocus();
    propBox->show();
    
    
    if (propBox->result() == QDialog::Rejected) 
    {  
        if (dirty == true) { delete this; }
        return;
    }
    
    QString* temp = new QString(nameEdit->text());
    setName(temp);
    
    delete temp;
    delete propBox;
}

int groupObj::destroy(int deleteStatus)
{
    if (deleteStatus < 2)
    {
    	QMessageBox * confirmDeleteBox = new QMessageBox ( 
									"Olympus: Confirm Delete", 
									"", 
									QMessageBox::Critical, 
									1, 
									2, 
									3 | QMessageBox::Default | QMessageBox::Escape );
	    confirmDeleteBox->setButtonText( 1, "Yes");
    	confirmDeleteBox->setButtonText( 2, "Yes To All");
	    confirmDeleteBox->setButtonText( 3, "No");
	    
	    if (name != NULL) { confirmDeleteBox->setText("Delete group " + *name + "?"); }
	    else  { confirmDeleteBox->setText("Delete group Unknown?"); }
	    
	    deleteStatus = confirmDeleteBox->exec();

	    if (deleteStatus == 3) { deleteStatus = 0; }	    
    }
    
    if (deleteStatus > 0)
    {
        bool oneSaved = false;
        groupObj* childObjs = childGroup;
        groupObj* tmpGroup;
        hostObj*  childHosts = firstChild;
        hostObj* tmpHost;
        
        while (childObjs != NULL)
        {
            deleteStatus = childObjs->destroy(deleteStatus);
            
            tmpGroup = childObjs;
            childObjs = childObjs->getNext();
            
            if (deleteStatus == 0) { oneSaved = true; }
            else { delete tmpGroup; }
        }
        
        while (childHosts != NULL)
        {
            deleteStatus = childHosts->destroy(deleteStatus);
            
            tmpHost = childHosts;
            childHosts = childHosts->getNext();
             
            if (deleteStatus == 0) { oneSaved = true; }
            else { delete tmpHost; }
             
        }
        
        if (oneSaved) { deleteStatus = 0; }
        if (deleteStatus > 0) { emit doomed(true); }
    }
    
    return deleteStatus;
}

void groupObj::weAreDoomed(bool doomState)
{
    emit doomed(doomState);
}