/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   sendNextMessage.cc 
*
*   this is used to send the next queued netmessage to the host.
*
*****************************************************************************/

#include "guisocket.h"
#include "netmessage.h"
#include "hostObj.h"

#include <qlist.h>
#include <qsocketnotifier.h>

//#define DEBUG_SENDNEXTMESSAGE

void guisocket::sendNextMessage()
{
    #ifdef DEBUG_SENDNEXTMESSAGE
        debug("\nguisocket::sendNextMessage() >>  sending the next"); 
    #endif
    
    netmessage * torpedo;
    
    // test for lack of socket, connectionState and writeWatcher's state
    if (socket == NULL) { host->connect(); }
    if (connectionState != OPEN) { return; }
    if (writeWatcher != NULL) { writeWatcher->setEnabled(false); }    
    
    if (! messageQueue->isEmpty())
    {
        torpedo = messageQueue->getFirst();
        torpedo->send(socket, NETMESSAGE);
        emit messageSent(torpedo->getSessionID());
        messageQueue->removeFirst();
    }
    
    if (messageQueue->isEmpty() && writeWatcher != NULL)
    {
        QObject::disconnect(writeWatcher, SIGNAL(activated(int)),
                                 this, SLOT(sendNextMessage()));
    }
    else if (writeWatcher != NULL)
    {
        writeWatcher->setEnabled(true);
    }
    
    #ifdef DEBUG_SENDNEXTMESSAGE
        debug("guisocket::sendNextMessage() >> finished sending the next\n"); 
    #endif
}