/*****************************************************************************
*
*   Copyright (c) 2000 Mount Linux Inc.
*   Licensed under the terms of the GPL
*
*   readSocket.cc 
*
*   the method that handles the initial header on each transmission
*
*****************************************************************************/

#include "guisocket.h"
#include "plugin.h"

// returns -1 on error, 0 when complete, 1+ on incomplete header
int guisocket::readHeader(void)
{
    int rlen;

    if ((rlen = socket->recv(&header[hlen], HEADER_SIZE - hlen)) < 0)
    {
        return rlen;
    }

    if (rlen + hlen == HEADER_SIZE)
    {
        memcpy(&opcode, &header[0], sizeof(opcode));
        opcode = ntohl(opcode);
        memcpy(&sessionID, &header[8], sizeof(sessionID));
        sessionID = ntohl(sessionID);
        memcpy(&currentObjectID, &header[12], sizeof(currentObjectID));
        currentObjectID = ntohl(currentObjectID);
        hlen = 0;
    }
    else
    {
        hlen = hlen + rlen;
    }
    return hlen;
}

void guisocket::readSocket(void)
{
    int rv;

    if (currentMessage == NULL)
    {
        if ((rv = readHeader()) == 0)
        {
            if (opcode > 69 && opcode < 90)
            {
                currentMessage = createNetmessage(sessionID, currentObjectID);
            }
            else if (opcode < 20)
            {
            }
            else
            {
            }
        }
        else if (rv < 0 && errno != EINTR && errno != EAGAIN)
        {
            socketError(errno);
            return;
        }
    }

    if (currentMessage != NULL)
    {
        if ((rv = currentMessage->receive()) == 0)
        {
            plugin * thisPlugin;
            QString stringMID;

            stringMID.setNum(sessionID,10);

            currentMessage->activate();

            if ((thisPlugin = client->openModules->find(stringMID)) > 0)
            {
                thisPlugin->recv(currentMessage, currentObjectID);
            }
            else
            {
                delete currentMessage;
            }

            thisPlugin = NULL;
            opcode = sessionID = currentObjectID = 0;
            currentMessage = NULL;
        }
        else if (rv < 0 && errno != EINTR && errno != EAGAIN)
        {
            socketError(errno);
            return;
        }
    }
}
