/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   queueMessage.cc 
*
*   this is used to queue a message for sending to the host.
*
*****************************************************************************/

#include "guisocket.h"
#include "hostObj.h"
#include "transport.h"

#include <qlist.h>
#include <qsocketnotifier.h>

//#define DEBUG_QUEUEMESSAGE

void guisocket::queueMessage(netmessage * messageToQueue)
{
    #ifdef DEBUG_QUEUEMESSAGE
        debug("\nguisocket::queueMessage() >>  queueing netmessage for sending"); 
    #endif
    
    messageQueue->append(messageToQueue);
    
    if (socket == NULL) { host->connect(); }
    
    if (writeWatcher == NULL)
    { writeWatcher = new QSocketNotifier(socket->getsd(),QSocketNotifier::Write,0); }
    
    if (messageQueue->count() == 1)
    {
       	QObject::connect(writeWatcher,SIGNAL(activated(int)),
                         this, SLOT(sendNextMessage()));
        writeWatcher->setEnabled(true); 
    }
    
    #ifdef DEBUG_QUEUEMESSAGE
        debug("guisocket::queueMessage() >>  message queued\n"); 
    #endif
}