/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   Socket.cc
*
*   Constructor/deconstructor for the Socket class
*
*****************************************************************************/

#include "guisocket.h"
#include "netmessage.h"

#include <qlist.h>

//#define DEBUG_GUISOCKET

guisocket::guisocket(hostObj *thisHost)
{
    host = thisHost;
    hlen = 0;
    opcode = sessionID = currentObjectID = 0;
    currentMessage = NULL;
    attempts = 0;
    connectionState = CLOSED;
    socket = NULL;
    socketTimer = NULL;
    readWatcher = NULL;
    writeWatcher = NULL;
    exceptionWatcher = NULL;
    messageQueue = new QList<netmessage>;
    messageQueue->setAutoDelete(true);
}

guisocket::~guisocket()
{
    #ifdef DEBUG_GUISOCKET
        debug("\nguisocket::~guisocket >>  deleting guisocket object");
    #endif
    
    disconnect();
    delete messageQueue;
    
    #ifdef DEBUG_GUISOCKET
        debug("guisocket::~guisocket >>  finished deleting guisocket object\n");
    #endif
}
