/*
 * error.cc: common methods for relaying communication errors to the user
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include <stdio.h>
#include <qmessagebox.h>
#include "hostObj.h"
#include "guisocket.h"

void guisocket::timeout(void)
{
    disconnect();
    QMessageBox::critical(0, tr("Connection Timout Failure"),
    tr("Connection to ") + *host->getCommonName() + tr(" has failed due to a timeout."));
}

void guisocket::loginFail(void)
{
    disconnect();
    QMessageBox::critical(0, tr("Login Failed"),
    tr("Logging in to ") + *host->getCommonName() + tr(" failed.\nThe username/password was rejected."));
}

void guisocket::connectError(int error)
{
    disconnect();
    QMessageBox::critical(0, tr("Connection Error: ") + *host->getCommonName(), tr(sys_errlist[error]));
}

void guisocket::socketError(int error)
{
    disconnect();
    QMessageBox::critical(0, tr("Socket Error: ") + *host->getCommonName(), tr(sys_errlist[error]));
}

