/*****************************************************************************
*
*   Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL
*
*   readSocket.cc 
*
*   the method that handles the initial header on each transmission
*
*****************************************************************************/

#include "guisocket.h"
#include "nmBlank.h"
#include "nmPing.h"
#include "nmFetchConfig.h"
#include "nmUpdateConfig.h"
#include "nmStrStream.h"
#include "nmSysInfo.h"
#include "nmUsers.h"

//#define DEBUG_CREATENM

netmessage* guisocket::createNetmessage(int sessionID, int objectID)
{
    #ifdef DEBUG_CREATENM
        debug("\nguisocket::createNetmessage >>  creating a new netmessage with sessionID: %i and objectID: %i", sessionID, objectID);
    #endif
    netmessage * newMessage = NULL;

    switch (objectID)
    {
        case COMMAND_FETCHCONFIG:
            debug("blah");
            newMessage = new nmFetchConfig(NULL, NULL, socket, sessionID, objectID);
            debug("yay");
        break;
        case COMMAND_PING:
            newMessage = new nmPing(socket, sessionID, objectID);
        break;
        case COMMAND_STRSTREAM:
            newMessage = new nmStrStream(socket, sessionID, objectID);
        break;
        case COMMAND_SUCCESS:
            newMessage = new nmBlank(socket, sessionID, objectID);
        break;
        case COMMAND_SYSINFO:
            newMessage = new nmSysInfo(socket, sessionID, objectID);
        break;
        case COMMAND_UPDATECONFIG:
            newMessage = new nmUpdateConfig(NULL, NULL, NULL, socket, sessionID, objectID);
        break;
        case COMMAND_USERS:
            newMessage = new nmUsers(NULL, NULL, 0, socket, sessionID, objectID);
        break;
    }
    
    #ifdef DEBUG_CREATENM
        debug("guisocket::createNetmessage >>  finished creating a new netmessage: %i\n",newMessage);
    #endif
    
    return newMessage; 
}
