/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	remove.cc 
*	
*	used to actually remove modules to entire groups of hosts
*
*****************************************************************************/

#include "groupModulesWin.h"
#include "groupObj.h"
#include "hostObj.h"


void groupModulesWin::removeModules()
{
    removeModules(group);
}

void groupModulesWin::removeModules(groupObj* currentGroup)
{
    hostObj* currentHost = currentGroup->getFirstChild();
    groupObj* childGroup = currentGroup->getChildGroup();
    
    QStringList::Iterator it;
    
    while (currentHost)
    {
        for (it = selectedModules->begin(); 
             it != selectedModules->end(); 
             ++it )
        {
            currentHost->removeModule(*it);
        }
        currentHost = currentHost->getNext();
    }
    
    while (childGroup)
    {
        removeModules(childGroup);
        childGroup = childGroup->getNext();
    }
}