/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*	Licensed under the terms of the GPL
*
*	groupModulesWin.cc 
*	
*	A class that makes a window for and then actually does mass assignment
*   of modules to groups of items
*
*****************************************************************************/

#include "olympus.h"
#include "groupModulesWin.h"

#include <qpushbutton.h>
#include <qlistview.h>
#include <qlabel.h>
#include <qlayout.h>

#include "groupObj.h"
#include "hostObj.h"
#include "module.h"
#include "stringListCheckItem.h"

groupModulesWin::groupModulesWin(groupObj* useGroup)
    : QDialog(0,"this",false)
{
    #ifdef DEBUG_GROUPMODULES
        debug("\nmainListView::groupModules >>  starting groupModules");
    #endif
    group = useGroup;
    selectedModules = new QStringList();
    
    this->setCaption("Add Modules To Group:  " + *useGroup->getName());
    
    QLabel * explanation = new QLabel(this);
    explanation->setText("To add or remove modules to every host in group <B>"
                         + *useGroup->getName()
                         + "</B> select modules from the list below and select Add or Remove");
    explanation->setTextFormat(QLabel::RichText);
    
    modulesList = new QListView(this);
    modulesList->setRootIsDecorated(true);
    modulesList->addColumn("Plugin");
    modulesList->addColumn("Description");
    
    modulesList->setPalette(*client->listPalette);

    QDictIterator<module> it(*client->modules);
    QListViewItem *thisNewGroup;
    QCheckListItem *thisNewItem;
    bool tempBool;
    
    #ifdef DEBUG_GROUPMODULES
        debug("mainListView::groupModules >>  finishing setting up window, now to create module list");
    #endif

    for ( ; it.current(); ++it )
    {
        #ifdef DEBUG_GROUPMODULES
            debug("mainListView::groupModules >>  \tentering loop");
        #endif
        
        if (*it.current()->getName() == "Olympus Admin") { continue; }
        
        tempBool = FALSE;
        QListViewItem * groupToUse;
        
        // if we have groups in the list (there are children, duh!)
        if (modulesList->firstChild())
        {
            #ifdef DEBUG_GROUPMODULES
                debug("mainListView::groupModules >>  \tfinding group");
            #endif
            groupToUse = modulesList->firstChild();
            
            // loop through the groups one by one and compare.          
            while (groupToUse && ! tempBool)
            {
                #ifdef DEBUG_GROUPMODULES
                    debug("mainListView::groupModules >>  \tmatching against %s", it.current()->getGroup()->data());
                #endif
                if (groupToUse->text(0) == *it.current()->getGroup())
                {
                    tempBool = TRUE;
                    break;
                }
                groupToUse = groupToUse->nextSibling();
            }
        }
        
        if (tempBool) // there is a group, we don't need to make one
        {
            #ifdef DEBUG_GROUPMODULES
                debug("mainListView::groupModules >>  \tadding to existing group");
            #endif
            thisNewItem = new stringListCheckItem(selectedModules, groupToUse, *it.current()->getName());
        }
        else // there isn't a group, so we make a new group in the list.
        {
            #ifdef DEBUG_GROUPMODULES
                debug("mainListView::groupModules >>  \tmaking new group and adding");
            #endif
            thisNewGroup = new QListViewItem(modulesList, it.current()->getGroup()->data());
            thisNewGroup->setOpen(true);
            thisNewGroup->setExpandable(true);
            thisNewItem = new stringListCheckItem(selectedModules, thisNewGroup, it.current()->getName()->data());
        }

        // set the second column of text to the description of the module
        thisNewItem->setText(1,it.current()->getDescription()->data());
    }
    QObject::connect(modulesList, SIGNAL(clicked(QListViewItem*, const QPoint&, int)),
                     this, SLOT(clickOn(QListViewItem*, const QPoint&, int)));
    
    explanation->setFixedWidth(modulesList->sizeHint().width());

    
    if ( modulesList->columnWidth(0) >
        (modulesList->sizeHint().width() - modulesList->columnWidth(1) + 10)
       )
    {
        modulesList->setColumnWidth(0,modulesList->columnWidth(0) + 10);
    }
    else
    {
        modulesList->setColumnWidth(0,modulesList->sizeHint().width() - modulesList->columnWidth(1) + 10);
    }
    modulesList->setFixedWidth(modulesList->columnWidth(0) + modulesList->columnWidth(1) + 5);
    
    #ifdef DEBUG_GROUPMODULES
        debug("mainListView::groupModules >>  done module list, moving on to buttons %i x %i",explanation->sizeHint().height(),explanation->sizeHint().width());
    #endif

    QPushButton * addButton = new QPushButton(this,"addButton");
    addButton->setText("Add Modules");
    QObject::connect(addButton, SIGNAL(clicked()),
                     this, SLOT(addModules()));
                     
    QPushButton * remButton = new QPushButton(this,"remButton");
    remButton->setText("Remove Modules");
    QObject::connect(remButton, SIGNAL(clicked()),
                     this, SLOT(removeModules()));
    
    QPushButton * doneButton = new QPushButton(this,"doneButton");
    doneButton->setText("Done");
    QObject::connect(doneButton, SIGNAL(clicked()),
                     this, SLOT(accept()));
     
    QGridLayout * groupModsLayout = new QGridLayout(this,5,5);
    groupModsLayout->addColSpacing( 0,10);
    groupModsLayout->addColSpacing( 4,10);
    groupModsLayout->addMultiCellWidget(explanation, 0, 0, 1, 3);
    groupModsLayout->addMultiCellWidget(modulesList, 1, 1, 1, 3);
    groupModsLayout->addRowSpacing( 2, 5);
    groupModsLayout->addWidget(addButton, 3, 1);
    groupModsLayout->addWidget(remButton, 3, 2);
    groupModsLayout->addWidget(doneButton,3, 3);
    groupModsLayout->addRowSpacing( 4,10);
    
   
    this->setFixedSize(groupModsLayout->sizeHint());
    this->show();
    
    #ifdef DEBUG_GROUPMODULES
        debug("mainListView::groupModules >>  finished groupModules\n");
    #endif
}

groupModulesWin::~groupModulesWin()
{
    delete selectedModules;
}

void groupModulesWin::closeEvent(QCloseEvent * closeEvent)
{
    closeEvent->accept();
    delete this;
}

void groupModulesWin::clickOn(QListViewItem* itemClicked, const QPoint & point, int column)
{
    if (itemClicked && 
        ! itemClicked->firstChild() && 
        (point.x() - pos().x()- modulesList->pos().x()) > 70
       )
    {
        stringListCheckItem * thisItem = (stringListCheckItem*) itemClicked;
        thisItem->setOn(! thisItem->isOn());
    }
}