/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.

*	Licensed under the terms of the GPL
*
*	addModules.cc 
*	
*	used to actually add modules to entire groups of hosts
*
*   Aaron J. Seigo <aseigo@mountlinux.com>
*****************************************************************************/

#include "olympus.h"
#include "groupModulesWin.h"
#include "groupObj.h"
#include "hostObj.h"

void groupModulesWin::addModules()
{
    addModules(group);
}

void groupModulesWin::addModules(groupObj* currentGroup)
{
    hostObj* currentHost = currentGroup->getFirstChild();
    groupObj* childGroup = currentGroup->getChildGroup();
    
    QStringList::Iterator it;
    
    while (currentHost)
    {
        for (it = selectedModules->begin(); 
             it != selectedModules->end(); 
             ++it )
        {
            currentHost->addModule(client->modules->find(*it));
        }
        currentHost = currentHost->getNext();
    }
    
    while (childGroup)
    {
        addModules(childGroup);
        childGroup = childGroup->getNext();
    }
}