/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GNU GPL or at the discretion of the 
*   recipient under the following terms:
*
*       Copyright  2000, Mount Linux Inc. All rights reserved. 
*
*       Permission is hereby granted, free of charge, to any person obtaining a copy of this software
*       and associated documentation files (the "Software"), to deal in the Software without
*       restriction, including without limitation the rights to use, copy, modify, merge, publish,
*       distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
*       Software is furnished to do so, subject to the following conditions: 
*
*       The above copyright notice and this permission notice applies to all licensees and shall be
*       included in all copies or substantial portions of the Software. 
*
*       THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
*       EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
*       TITLE, MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
*       NONINFRINGEMENT. IN NO EVENT SHALL Mount Linux Inc. BE LIABLE FOR
*       ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
*       CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF, OR IN CONNECTION
*       WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
*
*       Except as contained in this notice, the name of Mount Linux Inc. shall not be used in
*       advertising or otherwise to promote the sale, use or other dealings in this Software without
*       prior written authorization from Mount Linux Inc. 
*       
*       
*
*   This template can be used to write Olympus plugins, this code should compile
*   and run on most systems and be loadable in Olympus, though it will only
*   give you a small window with "Hello, Olympus" writen in it.
*
******************************************************************************/

#ifndef _mod_template_h
#define _mod_template_h

#include <qdialog.h>
#include <qlabel.h>

#include "plugin.h"

class mod_templatewin : public QDialog {
    Q_OBJECT
    
    public:
        mod_templatewin( unsigned int newMID, hostObj * thisHost, char * name );
        ~mod_templatewin();
        
        void closeEvent( QCloseEvent * e );
        
    private:
        unsigned int moduleID;
        hostObj * host;
        netmessage * message;
};

class mod_template : public plugin {
    public:
        mod_template();
        virtual ~mod_template();
    
        // these return info on the plugin in question
		virtual char * name() { return "Template"; }
		virtual char * group() { return "Development"; }
		virtual char * desc() { return "Olympus plugin template."; }
    	virtual char * credits() { return "Your Name <your email address> Organisation."; }
		virtual char * version() { return "0.1"; }
		
		// for receiving netmessage objects
		virtual void recv(netmessage *, int);
		
	    // to get focus
        virtual void getFocus();
 
		// the "main" function for the plugin
		virtual void exec(hostObj * thisHost, unsigned int MID, moduleList * thisModL);
	
	private:
		mod_templatewin * templateWin;
};

DLC_Register(mod_template); 


#endif // _mod_template_h
