/*****************************************************************************
*
*	Copyright (c) 1999-2000 Mountlinux Inc.
*   Licensed under the terms of the GPL (if used in (L)GPL'ed code) or BSD for 
*   any other use.
*
*   This template can be used to write Olympus plugins, this code should compile
*   and run on most systems and be loadable in Olympus, though it will only
*   give you a small window with "Hello, Olympus" writen in it.
*
******************************************************************************/

#include "mod_template.h"
#include "guisocket.h"


mod_template::mod_template()
{
    templateWin = NULL;
}


mod_template::~mod_template()
{
    /* delete the window if it exists. */
    if ( templateWin != NULL ) { delete templateWin; }
}


/* when the user wants to create an instance of this plugin, the client loads
   the .so, creates an instance of the class and then calls exec()
   
   exec() needs to start the GUI portion(s) of the plugin. its the main() of 
   the plugin.
   
   exec() received a pointer to the info on the host we are connected to (see
   olympus/src/client/include/hostObj.h), a numerical ID unique to this instance of
   a plugin (needed for networking) and a pointer to the module reference we were
   launched from. only the first two are significant to extending the functionality
   of the base plugin class. */
void mod_template::exec(hostObj * thisHost, unsigned int MID, moduleList * thisModL)
{
    init(thisHost,MID,thisModL);
    templateWin = new mod_templatewin(moduleID,host,"Template Module");   
    templateWin->show();
}


/* recv() gets called when a netmessage arrives on the network for this instance
   of this module. it is handed both a pointer to the netmessage as well as the 
   numerical ID defining the TYPE of netmessage. these IDs can be referenced in 
   olympus/src/common/commid.h 
   
   usually, to do anything USEFUL with the netmessage is to create a pointer to 
   the type of netmessage you've received and cast the pointer 'message' to that
   type. see below */
void mod_template::recv(netmessage * message, int objectID)
{
    /*
    if (objectID == COMMAND_SomeCommand)
    {
        nmSomeCommand* thisCommand = (nmSomeCommand*) message;
    }
    else if (objectID == COMMAND_SomeOtherCommand)
    {
        nmSomeOtherCommand* thisOtherCommand = (nmSomeOtherCommand*) message;
    }
    ...and so on.
    */
}


/* getFocus() gets called when the user selects a module that is already
   running from the main client gui. its job is to make us appear */
void mod_template::getFocus()
{
    templateWin->show();
    templateWin->setActiveWindow();
    templateWin->raise();
}

/******************************************
*   
*   This next part is for writing the 
*   interface and most usefull code
*
*******************************************/

mod_templatewin::mod_templatewin( unsigned int newMID, hostObj * thisHost, char * name) 
    : QDialog(0,name)
{
    /* this is used to identify us to the network */
    moduleID = newMID;
    
    /* this is the object that holds all the relevant data on the machine we are
       working with */
    host = thisHost;
    
    setCaption(*host->getCommonName() + ": Olympus Template");
    
    QLabel * hello = new QLabel(this, "Hello");
    hello->setGeometry(0, 0, 300, 50);
    hello->setText( " Hello, Olympus! " );
    
    setFixedSize(300,50);
}


mod_templatewin::~mod_templatewin()
{
    /* cancel all network requests that we might be making
       this is done here and not in ~mod_template since we will
       only ever be doing networking when we are in the GUI, but
       not necessarily doing networking when just loaded (and not exec()ed) */
    if (host != NULL) { host->network->cancelRequests(moduleID); }
}


void mod_templatewin::closeEvent( QCloseEvent * e )
{
    /* accept the event to close the window */
    e->accept();
    
    /* and now get the client to remove all existence of this instance of us */
    client->deleteModule(moduleID);
}
    
