#!/bin/sh

# SyslogHUP - Send the HUP signal to the syslogd deamon.
# If the deamon is not running then start it.

# NOTE:  If you modify this code, you MUST change the version to
#        something over 100 to prevent it being replaced by future
#        versions of this script. 
VER=1
export VER

# If we have input args look for -v
case "$1" in

'-v')
    echo $VER
    exit 0
    ;;

'-1')
    echo "1"
    exit 0
    ;;
esac


OS=`uname -s`
PATH=/usr/sbin:/bin:/usr/bin:/usr/etc:/usr/ucb:$PATH

case "$OS" in 
    "Linux")
        # Linux OS
        PID=`ps -ax |grep syslogd |grep -v grep |awk -F' ' '{print $1}'` 2> /dev/null
	if [ `echo $PID |wc -w` -eq 0 ]                                                                 
	then
	    echo "Warning:  The syslogd deamon appears to be not running."
	    syslogd
	    if [ $? -ne 0 ]                                                                 
	    then
		echo "ERROR:  Unable to start syslogd deamon."
		exit 1
	    else
	        echo "Syslogd deamon started."
	    fi
        else
	    echo "Sending HUP to syslogd deamon"
	    kill -HUP ${PID}
	fi
    ;;

    "SunOS")
        # SunOS 4.1.x, and Solaris
        PID=`ps -ax |grep syslogd |grep -v grep |awk -F' ' '{print $1}'` 2> /dev/null
	if [ `echo $PID |wc -w` -eq 0 ] 
	then
	    echo "Warning:  The syslogd deamon appears to be not running."
	    syslogd
	    if [ $? -ne 0 ]                                                                 
	    then
		echo "ERROR:  Unable to start syslogd deamon."
		exit 1
	    else
	        echo "Syslogd deamon started."
	    fi
	else
	    kill -HUP ${PID}
	fi
    ;;
esac










