/* libuser1.c  - Template
   Copyright (c) 1997, 1998 Mark Black
   This is a template for creating user defined 
   additions to the MAT agent.

*/

#include "libuser1.h"

/* This is Your version number for this lib */
#define VERSION "0.01"


/* 
   The USER1 command set is a free-form extension to MAT.  In general 
   MAT uses a very simple command syntax.  Each command is preficed
   with the module keyword, in this case USER1.  Some suggested command
   syntaxs are:
       USER1 get whatfile
       USER1 add whatfile your_data
       USER1 del whatfile some_unique_identifier
       USER1 mod whatfile some_unique_identifier new_data
   One command is required, namely "USER1 version".  This function 
   should return the version information for this lib.  Later versions
   may see MAT agent updates based solely on lib version numbers.
   NOTE:  The main code strips off any control characters at the end
   of a line.  It also removes the "USER1" keyword.
   */

/* "fplog" is a global file pointer to the log file. */
extern FILE *fplog ;


int user1Get(char *data) ;
int user1Add(char *data) ;
int user1Mod(char *data) ;
int user1Del(char *data) ;

/* Parse the USER1 command and call the necessary function.
   Do NOT change the name of this function.  The MAT agent 
   looks for this function when it receives a USER1 command.
 */
int user1cmd(char *data)
{
  char *splits[3] ;
  int numsplits ;

  /* Split the command string into 2 parts, using "wssplit", an internal MAT function. */ 
  if((numsplits = wssplit(&splits[0], data, 2)) < 1)
    {
      fprintf(stderr, "ERROR:  9000 Insufficient arguments.\n") ;
      return(1) ;
    }
  
  if(!strcmp(splits[0], "get")) 
    {
      if(user1Get(splits[1]))
	{
	  /* Error message supplied by user1Get */
	  return(1) ;
	}
    } 
  else if(!strcmp(splits[0], "add"))
    {  
      if(user1Add(splits[1]))
	{
	  return(1) ;
	}
    }
  else if(!strcmp(splits[0], "mod"))
    { 
      if(user1Mod(splits[1]))
	{
	  return(1) ;
	}
    }
  else if(!strcmp(splits[0], "del"))
    { 
      if(user1Del(splits[1]))
	{
	  return(1) ;
	}
    }
  else if(!strcmp(splits[0], "version"))
    {  
      fprintf(stderr, "%s\n", VERSION) ;
      return(0) ;
    }
  else
    {  
      fprintf(stderr, "ERROR:  USER1 lib: Unknown request, %splits[0]", splits[0]) ;
      return(1) ;
    }
  return(0) ;
}


/* Get the requested data */
int user1Get(char *data) 
{
  return(0) ;
}

/* Add a new entry to the user1 config file */ 
int user1Add(char *data) 
{
  return(0) ;
}

/* Modify an existing entry to the user1 config file */ 
int user1Mod(char *data)
{
  return(0) ;
}

/* Delete an entry in the user1 config file */ 
int user1Del(char *data)
{
  return(0) ;
}

