# userdef1.tcl
# Copyright (c) 1998 Mark Black
#
# You are free to modify the userdef1.tcl file to suit the modification
# of your objects. 
#
# This file contains some sample 
# code for integrating your user added matagent functions into the
# MAT console.  Take a look at libuser1.c and libuser1.h for an example
# of how to add your code to the MAT agent.
#
# This file will contain all the information for processing the data
# provided by your libuser1.so file.
#
# The routines that follow have three tasks:
#
#     1. Display an icon for your parameters, and if necessary create
#        a sub-menu for dealing with many objects.
#        Routine name = canUSER1
#
#     2. Display the objects in a meaningful textual form in the 
#        text area.
#        Routine name = USERrepack
#
#     3. Display a edit window for the creation or modification of
#        the objects you wish to administer.
#        Routine name = USER1



#
# canUSER1
#
# This routine is necessary if you wish to manage several types of objects.
# For example if your library managed several types of objects you could
# use this routine to provied an icon for each type of administered object.
# If you only have a single monitored object then this routine is not 
# necessary, and it's invocation should be prevented in the canvas.tcl file.
# 
# For single managed objects you need to change the binding from:
#    .tp.host.canvas bind usr1 <Double-1> "fillCan 900"
# to:
#    .tp.host.canvas bind usr1 <Double-1> "set browse 900 ;repack 900"
#
# For more than two managed objects you will need to modify this routine
# to have it display icons, and set bindings for each managed object.
# 
proc canUSER1 {} {
    # Global variables 
    global currenthost
    global currentdomain
    global level
    global browse

    .tp.title configure -text "Host($currenthost) --> Config --> User Defined "
    # Load in the icons
    set fig(901) [ image create photo -file "../lib/back.gif" ]
    set fig(902) [ image create photo -file "../lib/new.gif" ]
    set fig(903) [ image create photo -file "../lib/new.gif" ]
    set startX 40
    set startY 40
    set icon_size 48
    set incX 70
    set incY 80
    set cntx 0
    set node [ .tp.host.canvas create image $startX $startY -image $fig(901) -tags Bk ]
    .tp.host.canvas bind Bk <Double-1> "repack -20"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] \
	    -justify center -text "<- Back" -tags Bk \
	    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cntx 1

    set node [ .tp.host.canvas create image $startX $startY -image $fig(902) -tags obj1 ]
    .tp.host.canvas bind obj1 <Double-1> "set browse 902 ;repack 902"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] \
	    -justify center -text "Object 1" -tags obj1 \
	    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cntx 1

    # Add as many icons as you need by copying the section above.  
    # Change the tag for each one and the browse an repack values.
}


#
# USERrepack
#
# USERrepack is responsible for filling the textual display, and setting
# the bindings for adding, modifing, and deleting objects.
#
proc USERrepack { type } {
    global currenthost tapeserv level errno master

    . config -cursor watch
    set bold "-background #c0c000 -relief raised -borderwidth 1"
    set normal "-background {} -relief flat"
    set select "-underline 1"
    set win .general.text
    $win config -cursor watch
    $win configure -state normal
    $win delete 0.0 end
    set master ""
    set rdata {}

    if { $type == 900 } {
	.general.label configure -text "User Defined Object on $currenthost"
	set rdata [queryHost $currenthost "USER1 get obj" 0 ]
	.general.text.label configure -state normal
	.general.text.label delete 0.0 end
	.general.text.label insert end "Put your column descriptions here"
	.general.text.label configure -state disabled
	set win .general.text
	for { set pzn 0 } { $pzn < [llength $rdata] } { incr pzn 1 } {
	    set tmp [lindex $rdata $pzn ]
	    $win tag delete l$pzn
	    $win insert end "$outline\n" l$pzn
	    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
	    $win tag bind l$pzn <Double-1>  "USER1 $currenthost [lindex $rdata $pzn ]" 
	}
	$win configure -state disabled
    } elseif { $type == 901 } {
	# Use example above 

    } elseif { $type == 902 } {

    } elseif { $type == 903 } {

    } elseif { $type == 904 } {

    } 

    . config -cursor top_left_arrow
    $win config -cursor xterm
}



#
# This routine is invoked when one of the parameters in the textual 
# box is selected.  This should handle both new objects, and the
# modification of existing objects
#
# USE:  USER1 CurrentHost SelectedData
#             CurrentHost = host to update
#             SelectedData = line of data to modify
#
proc USER1 { currenthost line args } {
    global errno
    set host $currenthost
    if { [string length $args ] != 0 } {
	append line " $args"
    }
    if { [winfo exists .user1 ] == 0 } {
	toplevel .user1 -class Dialog
	wm title .user1 "User Defined Editor: $currenthost"
	wm iconname .mail "User Defined"
	entry .mail.hidden1 
	entry .mail.hidden2
	entry .mail.hidden3
	# NOT GOOD
	.mail.hidden1 insert end $currenthost

	frame .user1.f99 
	button .mail.f5.b1 -text "Apply" -foreground red -activeforeground #a00000 -command {
	    # Update the user defined object

	    if { !$NEW_Object } {
		# Not A New object 
		set cmd "USER1 mod $put_your_data_here"
	    } else {
		set cmd "USER1 add $unique_identifier $put_your_data_here"
	    }

	    set returnval [queryHost [.mail.hidden1 get ] $cmd 1 ]
	    if { $errno != 0 } {
		error 240
		puts stdout "ERROR:  Unable to update the Mail Aliases file on $currenthost\n"

	    } else {
		set returndata [queryHost $currenthost "CON get alias" 0 ]
		filltext $returndata .general.text 8
		destroy .mail
	    }
	}
	button .mail.f5.b2 -text "Cancel" -foreground #000080 -activeforeground #000040 -command {
	    destroy .user1
	}
	button .mail.f5.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command "help userdef1"
	pack .mail.f5.b1 .mail.f5.b2 .mail.f5.b3 -side left


    } else {
	# Window is already open
	# Clean up old entries

	
    }
    # -----------------  Populate Widgets -------------------


}


