# Upgrade.tcl
# Copyright (c) 1997, 1998 Mark Black
#

# getUpgradeVer
# Read the version number from the version file
#
proc getUpgradeVer { } {
    set fid [ open "../agent/version" r ]
    while { [ gets $fid fout ] > 0 } {
	lappend version $fout
    }
    close $fid
    return $version
}

#  UPGRADE
#  This is the MAT agent upgrade procedure
#
#  USE:  upgrade hostname
proc upgrade { hostname } {
    global errno
    if { [winfo exists .upgrade ] == 0 } {
	toplevel .upgrade -class Dialog
	wm title .upgrade "Upgrade Output"
	wm iconname .upgrade "Upgrade Output"
	text .upgrade.text -width 70 -height 12 -yscrollcommand { .upgrade.textscroll set }
	scrollbar .upgrade.textscroll -orient vertical -command ".upgrade.text yview"
	pack .upgrade.textscroll -side left -fill y
	pack .upgrade.text -side bottom -expand 1 -fill both
	button .upgrade.quit -text "Dismiss" -command "destroy .upgrade"
	pack .upgrade.quit 
    }
    set newver [ expr [ getUpgradeVer ] * 1000.0 ]

    if { [pingHost $hostname ] == 0 } {
	# Ping Failed
	.upgrade.text insert end "ERROR:  Unable to communicate with host: $hostname\n"
	.upgrade.text insert end "ERROR:  The upgrade cannot continue.  Ensure that \n"
	.upgrade.text insert end "ERROR:  the host is running, and that MAT is installed.\n"
    } else {
	.upgrade.text insert end "Checking MAT version....\n"
	set returnval [queryHost $hostname "version" 0 ]
	if { $errno != 0 } {
	    .upgrade.text insert end "ERROR:  Unable to get MAT version...\n"
	    .upgrade.text insert end "ERROR:  Look for other programs using the same port.\n"
	} else {
	    set oldversion [lindex [ split [lindex $returnval 0 ] ] 0 ] 
	    set ostype [lindex [split [lindex $returnval 0 ] ] 1 ] 
	    set oldver  [ expr $oldversion * 1000.0 ]
	    .upgrade.text insert end "Found version: $oldversion, for the $ostype OS.\n"
	    if { $oldver >= $newver } {
		.upgrade.text insert end "Upgrade not necessary.  The current version: $oldversion\n"
		.upgrade.text insert end "is the same, or older, than the intended upgrade.\n"
		.upgrade.text insert end "Upgrade aborting.\n"
	    } else {
		.upgrade.text insert end "The upgrade version is newer, continuing upgrade.\n"
		set linecnt 0
		set fname "../agent/matagent.$ostype"
		if { [file exists $fname ]  != 1 } {
		    .upgrade.text insert end "ERROR:  Can't find the appropriate upgrade file:\n"
		    .upgrade.text insert end "ERROR:  agent/matagent.$ostype"
		    .upgrade.text insert end "Upgrade aborting.\n"
		} else {
		    set fail 0
		    set cmd "put raw tmp/upgrade"
		    set returnval [queryHost $hostname $cmd 0 "ext" "put" "f" "$fname" ]
		    if { $errno != 0 } {
			.upgrade.text insert end "Upload Failed!!   Manual intervention is needed."
			set fail 1
		    }
		    .upgrade.text insert end "Upload Finished!"
		    if { $fail == 0 } {
			.upgrade.text insert end "Replacing MAT Agent.\n"
			.upgrade.text insert end "Notice:  No other MAT process must be running during this operation.\n"
			.upgrade.text insert end "Notice:  Any pending MAT requests will fail.\n"
			.upgrade.text insert end "Unpacking upload.\n"
			set cmd "decode tmp/Umat.000"
			set returnval [queryHost $hostname $cmd 0 ]
			for { set p 0 } { $p < [llength $returnval ] } { incr p 1 } {
			    set data [lindex $returnval $p ]
			    .upgrade.text insert end "$data\n"
			    if { $errno != 0 } {
				.upgrade.text insert end "Decode Failed!!   Manual intervention is needed."
				.upgrade.text see end
				set fail 1
			    }
			}
		    }
		    .upgrade.text see end
		    if { $fail == 0 } {
			.upgrade.text insert end "Waiting for operation to complete.\n"
			set holdHere 0
			after 5000 { set holdHere 1 }
			vwait holdHere
		   
			.upgrade.text insert end "Checking MAT version....\n"
			set returnval [queryHost $hostname "version" 0 ]
			if { $errno != 0 } {
			    .upgrade.text insert end "ERROR:  Unable to get MAT version...\n"
			    .upgrade.text insert end "ERROR:  Look for other programs using the same port.\n"
			    .upgrade.text see end
			} else {
			    set oldversion [lindex [ split [lindex $returnval 0 ] ] 0 ] 
			    .upgrade.text insert end "---------  Upgrade Finished.  New version $oldversion installed.  ----------"
			    .upgrade.text see end
			}
		    }			
		}
	    }
	}
    }
}    







