#!/usr/local/bin/wish

# syslog.tcl
#
# Copyright (c) 1997, 1998 Mark Black
#

#
# Syslog update procedure
#
# USE SyslogConf CHost Ctype Data
#             CHost   = host to update
#             CType   = The current type of log to update.  Set to 9999 for a new log
#             Data    = line of data to modify.  
#                       Data will be in the following form:
#                       Log_type {tab} Action
# NOTE: Data must be seperated by a single space or a singel tab
#
proc SyslogConf { chost ctype line args } {
    set host $chost
    if { [string length $args ] != 0 } {
	append line " $args"
    }
    if { [winfo exists .sys ] == 0 } {
	toplevel .sys -class Dialog
	wm title .sys "Syslog.conf editor for $chost"
	wm iconname .sys "Syslog Config"
	entry .sys.hidden1 
	entry .sys.hidden2
	entry .sys.hidden3
	entry .sys.hidden4
	# NOT GOOD
	.sys.hidden1 insert end $chost
	.sys.hidden2 insert end $ctype
	.sys.hidden3 insert end $line
	
	frame .sys.f2 -bd 2 -relief "raised"
	label .sys.f2.l1 -text "Log Type" 
	pack .sys.f2.l1 -fill x
	frame .sys.f2.f1 -bd 2 -relief "flat"
	label .sys.f2.f1.l1 -text "Originator:" -width 9
	menubutton .sys.f2.f1.b1 -text "..." -menu .sys.f2.f1.b1.m -relief raised
	menu .sys.f2.f1.b1.m -tearoff 0 
	set vals { * auth authpriv cron daemon kern lpr mail mark news syslog user \
		uucp local0 local1 local2 local3 local4 local5 local6 local7}
	foreach val $vals {
	    .sys.f2.f1.b1.m add command -label $val -command ".sys.f2.f1.e1 insert end \"$val, \" "
	}
	entry .sys.f2.f1.e1 -width 16
	pack .sys.f2.f1.l1 .sys.f2.f1.b1 .sys.f2.f1.e1 -fill both -side left -expand 1

	frame .sys.f2.f2 -bd 2 -relief "flat"
	label .sys.f2.f2.l1 -text "Level:" -width 9
	menubutton .sys.f2.f2.b1 -text "..." -menu .sys.f2.f2.b1.m -relief raised
	menu .sys.f2.f2.b1.m -tearoff 0 
	set vals { * emerg alert crit err warning notice debug }
	foreach val $vals {
	    .sys.f2.f2.b1.m add command -label $val -command ".sys.f2.f2.e1 delete 0 end ; .sys.f2.f2.e1 insert end \"$val\" "
	}
	entry .sys.f2.f2.e1 -width 16
	pack .sys.f2.f2.l1 .sys.f2.f2.b1 .sys.f2.f2.e1 -fill both -side left -expand 1

	frame .sys.f2.f25 -bd 2 -relief "flat"
	button .sys.f2.f25.b2 -text "Add" -command {
	    if { [.sys.f2.f1.e1 get] != "" } {
		if { [.sys.f2.f2.e1 get] != "" } {
		    set t [string trimright [.sys.f2.f1.e1 get] {, } ].[.sys.f2.f2.e1 get]
		    .sys.f2.f3.text insert end $t
		    .sys.f2.f1.e1 delete 0 end
		    .sys.f2.f2.e1 delete 0 end
		} else {
		    puts stdout "No level selected!"
		}
	    } else {
		puts stdout "No Facility Selected!"
	    }
	}
	button .sys.f2.f25.b1 -text "Delete" -foreground red -activeforeground #a00000 -command {
	    if { [.sys.f2.f3.text curselection ] != "" } {
		.sys.f2.f3.text delete [.sys.f2.f3.text curselection ]
	    }
	}
	pack .sys.f2.f25.b2 .sys.f2.f25.b1 -side left -fill both -expand 1

	frame .sys.f2.f3 -bd 2 -relief "flat"
	scrollbar .sys.f2.f3.vscroll -orient vertical -command ".sys.f2.f3.text yview" 
	listbox .sys.f2.f3.text -selectforeground white -selectbackground #000080 -yscrollcommand {.sys.f2.f3.vscroll set } -height 3 -width 16
	.sys.f2.f3.text config -cursor hand2
	pack .sys.f2.f3.vscroll -side left -fill y
	pack .sys.f2.f3.text -side left -expand 1 -fill both
	pack .sys.f2.f1 .sys.f2.f2 .sys.f2.f25 .sys.f2.f3  -side top -fill both -expand 1

	frame .sys.f4 -bd 2 -relief "raised"
	label .sys.f4.l1 -text "Action"

	frame .sys.f4.f0 -bd 0 -relief "flat"
	radiobutton .sys.f4.f0.b1 -text "Log in file" -variable mtype -value "Log" \
		-command ".sys.hidden4 delete 0 end ; \
		.sys.hidden4 insert end {Log} ; \
		pack forget .sys.f4.f1 .sys.f4.f2 .sys.f4.f3 ; \
		pack .sys.f4.f1 -fill both ; \
		.sys.f4.f1.l1 configure -text {Log to File:} ; \
		.sys.f4.f1.e1 delete 0 end "
	radiobutton .sys.f4.f0.b2 -text "Email Users" -variable mtype -value "email" \
		-command ".sys.hidden4 delete 0 end ; \
		.sys.hidden4 insert end {email} ; \
		pack forget .sys.f4.f1 .sys.f4.f2 .sys.f4.f3 ; \
		pack .sys.f4.f2 .sys.f4.f3 -fill both "
	radiobutton .sys.f4.f0.b3 -text "Forward to" -variable mtype -value "for" \
		-command ".sys.hidden4 delete 0 end ; \
		.sys.hidden4 insert end {for} ; \
		pack forget .sys.f4.f1 .sys.f4.f2 .sys.f4.f3 ; \
		pack .sys.f4.f1 -fill both ; \
		.sys.f4.f1.l1 configure -text {Log to Host:} ; \
		.sys.f4.f1.e1 delete 0 end "
	radiobutton .sys.f4.f0.b4 -text "Send to logged-in users" -variable mtype -value "users" \
		-command ".sys.hidden4 delete 0 end ; \
		.sys.hidden4 insert end {users} ; \
		pack forget .sys.f4.f1 .sys.f4.f2 .sys.f4.f3"
	pack .sys.f4.f0.b4 .sys.f4.f0.b1 .sys.f4.f0.b3 .sys.f4.f0.b2 -side top -anchor w -expand 1

	frame .sys.f4.f1 -bd 2 -relief "ridge"
	label .sys.f4.f1.l1 -text "Hello"
	entry .sys.f4.f1.e1 -width 16
	pack .sys.f4.f1.l1 .sys.f4.f1.e1 -side left -fill both -expand 1

	frame .sys.f4.f2 -bd 0 -relief "ridge"
	entry .sys.f4.f2.e1 -width 16
	button .sys.f4.f2.b1 -text "Add" -command {
	    if { [.sys.f4.f2.e1 get] != "" } {
		.sys.f4.f3.text insert end [.sys.f4.f2.e1 get]
	    }
	    .sys.f4.f2.e1 delete 0 end
	}
	pack .sys.f4.f2.e1 .sys.f4.f2.b1 -fill both -side left -expand 1
	frame .sys.f4.f3 -bd 2 -relief "flat"
	scrollbar .sys.f4.f3.vscroll -orient vertical -command ".sys.f4.f3.text yview" 
	listbox .sys.f4.f3.text -selectforeground white -selectbackground #000080 -yscrollcommand {.sys.f4.f3.vscroll set } -height 3 -width 16
	.sys.f4.f3.text config -cursor hand2
	pack .sys.f4.f3.vscroll -side left -fill y
	pack .sys.f4.f3.text -side left -expand 1 -fill both
	button .sys.f4.f3.b1 -text "Delete" -foreground red -activeforeground #a00000 -command {
	    if { [.sys.f4.f3.text curselection ] != "" } {
		.sys.f4.f3.text delete [.sys.f4.f3.text curselection ]
	    }
	}
	pack .sys.f4.f3.b1 -side left
	pack .sys.f4.l1 .sys.f4.f0 -side top -fill both -expand 1

	# -----------------------------------------------------------------------------------
	frame .sys.f7 -bd 2 -relief "raised"
	button .sys.f7.b1 -text "Apply" -foreground red -activeforeground #a00000 -command {
	    set tmpline {}
	    foreach type [.sys.f2.f3.text get 0 end] {
		append tmpline "[string tolower [string trimright $type]];"
	    }
	    set newline "[string trimright $tmpline {;} ]	"
	    if { [.sys.hidden4 get] == {users} } {
		append newline {*} 
	    } elseif { [.sys.hidden4 get] == {Log} } {
		append newline [.sys.f4.f1.e1 get]
	    } elseif { [.sys.hidden4 get] == {for} } {
		append newline "@[.sys.f4.f1.e1 get]"
	    } else {
		set tmpline $newline
		# Must be an email list
		foreach mail [.sys.f4.f3.text get 0 end] {
		    append tmpline "[string tolower [string trimright $mail]],"
		}
		set newline "[string trimright $tmpline {,} ]"
	    }
	    if { [.sys.hidden3 get] == 9999 } {
		set cmd "MON add syslogconf $newline"
	    } else {
		set cmd "MON mod syslogconf [.sys.hidden2 get] $newline"
	    }
	    set returnval [queryHost [.sys.hidden1 get] $cmd 1 ]
	    if { $errno != 0 } {
		error 91
		puts stdout "ERROR:  Unable to update the syslog.conf file on $currenthost"
	    } else {
		repack 111
		destroy .sys
	    }
	}
	button .sys.f7.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    destroy .sys
	}
	button .sys.f7.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help syslog
	}
	pack .sys.f7.b1 .sys.f7.b2 .sys.f7.b3 -side left -fill x 

	pack .sys.f2 .sys.f4 .sys.f7 -side top -fill both -expand 1

   } else {
       # Window already exists
       .sys.hidden1 delete 0 end 
       .sys.hidden2 delete 0 end 
       .sys.hidden3 delete 0 end 
       .sys.hidden1 insert end $chost
       .sys.hidden2 insert end $ctype
       .sys.hidden3 insert end $line
   }

   # Initialize the widgets
   .sys.f2.f1.e1 delete 0 end
   .sys.f2.f2.e1 delete 0 end
   .sys.f2.f3.text delete 0 end
   .sys.f4.f3.text delete 0 end
   .sys.f4.f1.e1 delete 0 end
   .sys.f4.f2.e1 delete 0 end

   if { $ctype == "9999" } {
       # It's a New log

   } else {
       # It's an existing log file
       foreach val [split $ctype {;} ] {
	   .sys.f2.f3.text insert end $val
       }
       set act [lindex $line end ]
       if { $act == {*} } {
	   .sys.f4.f0.b4 invoke
       } elseif { [string index $act 0 ] == {@} } {
	   # Log to another host
	   .sys.f4.f0.b3 invoke
	   .sys.f4.f1.e1 insert end [string trimleft $act {@} ]
       } elseif { [string index $act 0 ] == {/} } {
	   # Log to a file
	   .sys.f4.f0.b1 invoke
	   .sys.f4.f1.e1 insert end $act
       } else {
	   # Must be a email list
	   .sys.f4.f0.b2 invoke
	   foreach e [string trim [split $act {,} ] { } ] {
	       .sys.f4.f3.text insert end $e
	    }
	}
    }
}



# SyslogConf loghost *.crit {*.crit	/var/adm/t.log}
#SyslogConf loghost {kern,lpr.crit;*.debug} {kern,lpr.crit;*.debug	@logger}
#SyslogConf loghost {kern,lpr.crit;*.debug} {kern,lpr.crit;*.debug	root,operator,weenie}
