# Replicate.tcl  - The Replication Interface
#
# Copyright 1999   Mark Black
#


#
# -- Replication Specific Procedure to read data from raw data and fill list window --
#    w = window to display it in
proc replText { data w type } {
    global currenthost
    global tapeserv
    . config -cursor watch
    $w config -cursor watch
    $w configure -state normal
    $w delete 0.0 end

    # Replication Group
    set tabbing(251) {7 }
    set toplabel(251) "GID    Name"
    # Replication Job
    # job#:group#:retain:drive#:pool#:Descriptor
    set tabbing(252) {6 8 }
    set toplabel(252) "Job   Group   Name"

    set bold "-background #c0c000 -relief raised -borderwidth 1"
    set normal "-background {} -relief flat"
    set select "-underline 1"
    set tplabel $w
    append tplabel "label"
    $tplabel configure -state normal
    $tplabel delete 0.0 end
    $tplabel insert end $toplabel($type)
    $tplabel configure -state disabled

    if { $type == 251 } {
	# ------------------------------  Replication Group --------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [lindex $data $position ]
	    set tmp3 [split $tmp {:} ]
	    set tmp4 [lindex $tmp3 0 ]
	    set outline $tmp4
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp4 ]) } { incr cnt 1 } {
		append outline " "
	    }

	    set tmp4 [string trim [lindex $tmp3 2]]
	    append outline $tmp4
	    $w insert end "$outline\n" l$position
	    $w tag bind l$position <Any-Enter> "$w tag configure l$position $bold"
	    $w tag bind l$position <Any-Leave> "$w tag configure l$position $normal"
	    $w tag bind l$position <Button-1> "Selecter $w l$position"
	    $w tag bind l$position <Double-1>  "tapeGroup $currenthost [lindex $tmp3 0 ] $tmp" 
	    $w tag configure l$position -foreground #000000
	}
	$w configure -state disabled
    } elseif { $type == 252 } {
	# ------------------------------  Replication Job --------------------------------
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [lindex $data $position ]
	    set tmp3 [split $tmp {:} ]
	    set tmp4 [lindex $tmp3 0 ]
	    set outline $tmp4
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp4 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp4 [lindex $tmp3 1 ]
	    append outline $tmp4
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp4 ]) } { incr cnt 1 } {
		append outline " "
	    }

	    set tmp4 [string trim [lindex $tmp3 9 ]]
	    append outline $tmp4
	    $w insert end "$outline\n" l$position
	    $w tag bind l$position <Any-Enter> "$w tag configure l$position $bold"
	    $w tag bind l$position <Any-Leave> "$w tag configure l$position $normal"
	    $w tag bind l$position <Button-1> "Selecter $w l$position"
	    $w tag bind l$position <Double-1>  "replJobs $currenthost [lindex $tmp3 0 ] $tmp" 
	    $w tag configure l$position -foreground #000000
	}
	$w configure -state disabled
    } 
}


#
# canREPL  - Fill canvas with Replication icons
#
proc canREPL {} {
    # ---------------------  Replication Window  ---------------------
    global currenthost
    global level
    global browse
    global tapeserv
    .tp.title configure -text "Host($currenthost) --> Config --> Replicate "
    set level 250
    # Enable the accelerators
    bind .tp.host.canvas <Button-3> "rclick .tp.host.canvas"
    # Put in back button
    set fig(251) [ image create photo -file "../lib/replgrp.gif" ]
    set fig(252) [ image create photo -file "../lib/replicate.gif" ]
    set fig(140) [ image create photo -file "../lib/replsched.gif" ]

    set fig(0) [ image create photo -file "../lib/back.gif" ]
    set startX 40
    set startY 40
    set icon_size 48
    set incX 70
    set incY 80
    set cntx 0

    set node [ .tp.host.canvas create image $startX $startY -image $fig(0) -tags "<-Back" ]
    .tp.host.canvas bind "<-Back" <Double-1> "repack -20"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] \
	    -justify center -text "<- Back" -tags nameLabel \
	    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cntx 1

    # Draw an icon for the replication host groups
    set node [ .tp.host.canvas create image $startX $startY -image $fig(251) -tags tgrp ]
    .tp.host.canvas bind tgrp <Double-1> "set browse 251 ;repack 251"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] \
	    -justify center -text "Replication\nGroup" -tags tgrp \
	    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cntx 1

    # Draw an icon for the Replication jobids
    set node [ .tp.host.canvas create image $startX $startY -image $fig(252) -tags tjob ]
    .tp.host.canvas bind tjob <Double-1> "set browse 252 ;repack 252"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] \
	    -justify center -text "Replication\nJob" -tags tjob \
	    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cntx 1

    # Draw an icon for the backup schedule
    set node [ .tp.host.canvas create image $startX $startY -image $fig(140) -tags ttime ]
    .tp.host.canvas bind ttime <Double-1> "fillCan 150"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] \
	    -justify center -text "Replication\nSchedule" -tags ttime \
	    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cntx 1

}


#
# replJobs - Manage the replication job requests.  This GUI allows the user to set the
#            the following:   Job ID#   - Used to schedule the job
#                             Backup Gruop  - The hosts to backup
#                             Retention     - How long to hold a tape
#                             Drive         - Desired backup device
#                             Pool          - Pool of tapes available for the backup
#            Set jobnum to -9999 for new jobs
#
set sd {}
proc replJobs { replserv jobnum data args } {
    if { [string length $args ] != 0 } {
        append data " $args"
    }
    global errno
    global sd
    set sd "/"
    set host $replserv
    if { [winfo exists .rjob ] != 0 } {
	destroy .rjob
    }

    toplevel .rjob -class Dialog
    wm title .rjob "Replication Job"
    wm iconname .rjob "Replicate"
    entry .rjob.hidden1 
    entry .rjob.hidden2
    .rjob.hidden1 insert end $replserv
    .rjob.hidden2 insert end $jobnum

    frame .rjob.f1 -relief flat -bd 2
    frame .rjob.f2 -relief flat -bd 2
    frame .rjob.f3 -relief flat -bd 2
    frame .rjob.f5 -bd 2 -relief flat
    frame .rjob.f7 -bd 2 -relief flat
    frame .rjob.f9 -bd 2 -relief flat
    frame .rjob.f10 -bd 0 -relief flat
    pack .rjob.f10
    frame .rjob.f10.f1 -bd 2 -relief flat
    grid .rjob.f10.f1
    button .rjob.hb1

    button .rjob.f10.f1.b1 -relief groove -text "Description" -command {
	set c1 [ .rjob.hb1 cget -activebackground ]
	set c2 [ .rjob.hb1 cget -bg ]
	.rjob.f10.f1.b1 configure -relief flat -bg $c2 -activebackground $c1
	.rjob.f10.f1.b2 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b3 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b4 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b5 configure -relief groove -bg $c1 -activebackground $c2
	pack forget .rjob.f1 .rjob.f2 .rjob.f3 .rjob.f5 .rjob.f7 .rjob.f9
	pack .rjob.f1 .rjob.f7 -anchor w -fill x
    }
    button .rjob.f10.f1.b2 -relief groove -text "Files" -command {
	set c1 [ .rjob.hb1 cget -activebackground ]
	set c2 [ .rjob.hb1 cget -bg ]
	.rjob.f10.f1.b1 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b2 configure -relief flat -bg $c2 -activebackground $c1
	.rjob.f10.f1.b3 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b4 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b5 configure -relief groove -bg $c1 -activebackground $c2
	pack forget .rjob.f1 .rjob.f2 .rjob.f3 .rjob.f5 .rjob.f7 .rjob.f9
	pack .rjob.f5 .rjob.f7 -anchor w -fill x
	global sd
	set sd "/"
	getDir [ .rjob.hidden1 get ] $sd .rjob.f5.f2.text
	.rjob.f5.f6.text delete 0 end
	set mdata [queryHost [ .rjob.hidden1 get ] "TAPE get backuplist [ .rjob.hidden2 get ]" 0 ]
	foreach m $mdata {
	    .rjob.f5.f6.text insert end $m
	}
    }
    button .rjob.f10.f1.b3 -relief groove -text "Target" -command {
	set c1 [ .rjob.hb1 cget -activebackground ]
	set c2 [ .rjob.hb1 cget -bg ]
	.rjob.f10.f1.b1 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b2 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b3 configure -relief flat -bg $c2 -activebackground $c1
	.rjob.f10.f1.b4 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b5 configure -relief groove -bg $c1 -activebackground $c2
	pack forget .rjob.f1 .rjob.f2 .rjob.f3 .rjob.f5 .rjob.f7 .rjob.f9
	pack .rjob.f2 .rjob.f7 -anchor w -fill x
    }
    button .rjob.f10.f1.b4 -relief groove -text "Permissions" -command {
	set c1 [ .rjob.hb1 cget -activebackground ]
	set c2 [ .rjob.hb1 cget -bg ]
	.rjob.f10.f1.b1 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b2 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b3 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b4 configure -relief flat -bg $c2 -activebackground $c1
	.rjob.f10.f1.b5 configure -relief groove -bg $c1 -activebackground $c2
	pack forget .rjob.f1 .rjob.f2 .rjob.f3 .rjob.f5 .rjob.f7 .rjob.f9
	pack .rjob.f3 .rjob.f7 -anchor w -fill x
    }
    button .rjob.f10.f1.b5 -relief groove -text "Action" -command {
	set c1 [ .rjob.hb1 cget -activebackground ]
	set c2 [ .rjob.hb1 cget -bg ]
	.rjob.f10.f1.b1 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b2 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b3 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b4 configure -relief groove -bg $c1 -activebackground $c2
	.rjob.f10.f1.b5 configure -relief flat -bg $c2 -activebackground $c1
	pack forget .rjob.f1 .rjob.f2 .rjob.f3 .rjob.f5 .rjob.f7 .rjob.f9
	pack .rjob.f9 .rjob.f7 -anchor w -fill x
    }
    grid .rjob.f10.f1.b1 .rjob.f10.f1.b2 .rjob.f10.f1.b3 .rjob.f10.f1.b4 .rjob.f10.f1.b5 
    .rjob.f10.f1.b1 invoke

    # Job Description Frame
    frame .rjob.f1.f1
    label .rjob.f1.f1.l1 -text "Job #"
    entry .rjob.f1.f1.e1 -width 5
    grid .rjob.f1.f1.l1 .rjob.f1.f1.e1 -sticky w

    frame .rjob.f1.f2
    label .rjob.f1.f2.l1 -text "Description:"
    entry .rjob.f1.f2.e1 -width 25
    grid .rjob.f1.f2.l1 .rjob.f1.f2.e1 -sticky w
    pack .rjob.f1.f1 .rjob.f1.f2 -fill x -expand 1 -anchor w
    
    # ----  Target Frame
    frame .rjob.f2.f1
    label .rjob.f2.f1.l1 -text "Target Group #"
    menubutton .rjob.f2.f1.b1 -text "..." -menu .rjob.f2.f1.b1.m -relief raised -width 3
    menu .rjob.f2.f1.b1.m -tearoff 0 
    set rdata [queryHost $replserv "TAPE get groups" 0 ]
    foreach l $rdata {
	set val [lindex [split $l ":"] 0]
	set nm [lindex [split $l ":"] 2]
	.rjob.f2.f1.b1.m add command -label $val -command " \
		.rjob.f2.f1.e1 configure -state normal ; \
		.rjob.f2.f1.e1 delete 0 end ; \
		.rjob.f2.f1.e1 insert end \"$val\" ; \
		.rjob.f2.f1.e1 configure -state disabled ; \
		.rjob.f2.f2.e1 configure -state normal ; \
		.rjob.f2.f2.e1 delete 0 end ; \
		.rjob.f2.f2.e1 insert end \"$nm\" ; \
		.rjob.f2.f2.e1 configure -state disabled "
    }
    entry .rjob.f2.f1.e1 -width 5
    grid .rjob.f2.f1.l1 .rjob.f2.f1.b1 .rjob.f2.f1.e1 -sticky w
    frame .rjob.f2.f2
    label .rjob.f2.f2.l1 -text "Group :"
    entry .rjob.f2.f2.e1 -width 25
    grid .rjob.f2.f2.l1 .rjob.f2.f2.e1 -sticky w
    frame .rjob.f2.f3
    label .rjob.f2.f3.l1 -text "Location :"
    entry .rjob.f2.f3.e1 -width 25
    grid .rjob.f2.f3.l1 .rjob.f2.f3.e1 -sticky w
    pack .rjob.f2.f1 .rjob.f2.f2 .rjob.f2.f3 -fill x -expand 1 -anchor w


    # ----  File permissions Frame
    # Ownership
    frame .rjob.f3.f2 -bd 2
    label .rjob.f3.f2.tl1 -text "Replicated File/Dir Permissions"
    grid .rjob.f3.f2.tl1 -columnspan 5

    label .rjob.f3.f2.l1 -text "Ownership:"
    radiobutton .rjob.f3.f2.b1 -text "Same" -variable owns -value 0 -command ".rjob.f3.f2.e1 delete 0 end ; .rjob.f3.f2.e1 configure -state disabled"
    radiobutton .rjob.f3.f2.b2 -text "Change to:" -variable owns -value 1 -command ".rjob.f3.f2.e1 configure -state normal"
    menubutton .rjob.f3.f2.b3 -text "..." -menu .rjob.f3.f2.b3.m -relief raised -width 3
    menu .rjob.f3.f2.b3.m -tearoff 0 
    set rdata [queryHost $replserv "CON get pass" 0 ]
    foreach l $rdata {
	set val [lindex [split $l ":"] 0]
	set nm [lindex [split $l ":"] 2]
	.rjob.f3.f2.b3.m add command -label $val -command " \
		.rjob.f3.f2.e1 delete 0 end ; \
		.rjob.f3.f2.e1 insert end \"$nm\" "
    }
    entry .rjob.f3.f2.e1 -width 5
    grid .rjob.f3.f2.l1 .rjob.f3.f2.b1 .rjob.f3.f2.b2 .rjob.f3.f2.b3 .rjob.f3.f2.e1

    label .rjob.f3.f2.l2 -text "Group:"
    radiobutton .rjob.f3.f2.b11 -text "Same" -variable grps -value 0 -command ".rjob.f3.f2.e2 delete 0 end ; .rjob.f3.f2.e2 configure -state disabled"
    radiobutton .rjob.f3.f2.b12 -text "Change to:" -variable grps -value 1 -command ".rjob.f3.f2.e2 configure -state normal"
    menubutton .rjob.f3.f2.b13 -text "..." -menu .rjob.f3.f2.b13.m -relief raised -width 3
    menu .rjob.f3.f2.b13.m -tearoff 0 
    set rdata [queryHost $replserv "CON get group" 0 ]
    foreach l $rdata {
	set val [lindex [split $l ":"] 0]
	set nm [lindex [split $l ":"] 2]
	.rjob.f3.f2.b13.m add command -label $val -command " \
		.rjob.f3.f2.e2 delete 0 end ; \
		.rjob.f3.f2.e2 insert end \"$nm\" "
    }
    entry .rjob.f3.f2.e2 -width 5
    grid .rjob.f3.f2.l2 .rjob.f3.f2.b11 .rjob.f3.f2.b12 .rjob.f3.f2.b13 .rjob.f3.f2.e2

    label .rjob.f3.f2.l22 -text "Set UID:"
    radiobutton .rjob.f3.f2.b21 -text "Allow" -variable suid -value 0 -command ""
    radiobutton .rjob.f3.f2.b22 -text "Disallow:" -variable suid -value 1 -command ""
    grid .rjob.f3.f2.l22 .rjob.f3.f2.b21 .rjob.f3.f2.b22

    label .rjob.f3.f2.l32 -text "Permissions:"
    radiobutton .rjob.f3.f2.b31 -text "Same" -variable perm -value 0 -command "bonoff .rjob.f3.f1 disabled"
    radiobutton .rjob.f3.f2.b32 -text "Change to:" -variable perm -value 1 -command ".rjob.f3.f2.b22 invoke ;bonoff .rjob.f3.f1 normal"
    grid .rjob.f3.f2.l32 .rjob.f3.f2.b31 .rjob.f3.f2.b32

    frame .rjob.f3.f1
    label .rjob.f3.f1.l2 -text "User"
    label .rjob.f3.f1.l3 -text "Group"
    label .rjob.f3.f1.l4 -text "Other"
    grid .rjob.f3.f1.l2 -column 1 -columnspan 3
    grid .rjob.f3.f1.l3 -column 4 -columnspan 3 -row 0
    grid .rjob.f3.f1.l4 -column 7 -columnspan 3 -row 0

    label .rjob.f3.f1.dl2 -text "Directories"
    button .rjob.f3.f1.d1 -text "r" -relief raised -command "btoggle .rjob.f3.f1.d1"
    button .rjob.f3.f1.d2 -text "w" -relief raised -command "btoggle .rjob.f3.f1.d2"
    button .rjob.f3.f1.d3 -text "x" -relief raised -command "btoggle .rjob.f3.f1.d3"
    button .rjob.f3.f1.d4 -text "r" -relief raised -command "btoggle .rjob.f3.f1.d4"
    button .rjob.f3.f1.d5 -text "w" -relief raised -command "btoggle .rjob.f3.f1.d5"
    button .rjob.f3.f1.d6 -text "x" -relief raised -command "btoggle .rjob.f3.f1.d6"
    button .rjob.f3.f1.d7 -text "r" -relief raised -command "btoggle .rjob.f3.f1.d7"
    button .rjob.f3.f1.d8 -text "w" -relief raised -command "btoggle .rjob.f3.f1.d8"
    button .rjob.f3.f1.d9 -text "x" -relief raised -command "btoggle .rjob.f3.f1.d9"
    grid .rjob.f3.f1.dl2 .rjob.f3.f1.d1 .rjob.f3.f1.d2 .rjob.f3.f1.d3 .rjob.f3.f1.d4 .rjob.f3.f1.d5 .rjob.f3.f1.d6 .rjob.f3.f1.d7 .rjob.f3.f1.d8 .rjob.f3.f1.d9

    label .rjob.f3.f1.ol2 -text "Files"
    button .rjob.f3.f1.o1 -text "r" -relief raised -command "btoggle .rjob.f3.f1.o1"
    button .rjob.f3.f1.o2 -text "w" -relief raised -command "btoggle .rjob.f3.f1.o2"
    button .rjob.f3.f1.o3 -text "x" -relief raised -command "btoggle .rjob.f3.f1.o3"
    button .rjob.f3.f1.o4 -text "r" -relief raised -command "btoggle .rjob.f3.f1.o4"
    button .rjob.f3.f1.o5 -text "w" -relief raised -command "btoggle .rjob.f3.f1.o5"
    button .rjob.f3.f1.o6 -text "x" -relief raised -command "btoggle .rjob.f3.f1.o6"
    button .rjob.f3.f1.o7 -text "r" -relief raised -command "btoggle .rjob.f3.f1.o7"
    button .rjob.f3.f1.o8 -text "w" -relief raised -command "btoggle .rjob.f3.f1.o8"
    button .rjob.f3.f1.o9 -text "x" -relief raised -command "btoggle .rjob.f3.f1.o9"
    grid .rjob.f3.f1.ol2 .rjob.f3.f1.o1 .rjob.f3.f1.o2 .rjob.f3.f1.o3 .rjob.f3.f1.o4 .rjob.f3.f1.o5 .rjob.f3.f1.o6 .rjob.f3.f1.o7 .rjob.f3.f1.o8 .rjob.f3.f1.o9

    pack .rjob.f3.f2 .rjob.f3.f1 -fill x -expand 1 -anchor w


    # ----  Files frame 
    frame .rjob.f5.f1 -bd 2 -relief "flat"
    label .rjob.f5.f1.l1 -text "Replication Server:"
    entry .rjob.f5.f1.e1 
    .rjob.f5.f1.e1 insert end $replserv
    .rjob.f5.f1.e1 configure -state disabled
    label .rjob.f5.f1.l2 -text "Current Dir:"
    entry .rjob.f5.f1.e2 -width 32
    grid .rjob.f5.f1.l1 .rjob.f5.f1.e1
    grid .rjob.f5.f1.l2 .rjob.f5.f1.e2
    pack .rjob.f5.f1 -side top
 
    frame .rjob.f5.f2 -bd 2 -relief "flat"
    scrollbar .rjob.f5.f2.vscroll -orient vertical -command ".rjob.f5.f2.text yview"
    scrollbar .rjob.f5.f2.hscroll -orient horizontal -command ".rjob.f5.f2.text xview"
    listbox .rjob.f5.f2.text -selectforeground white -selectbackground #000080 \
	    -yscrollcommand {.rjob.f5.f2.vscroll set } \
	    -xscrollcommand {.rjob.f5.f2.hscroll set } -height 8 -width 32
    .rjob.f5.f2.text config -cursor hand2
    pack .rjob.f5.f2.vscroll -side right -fill y
    pack .rjob.f5.f2.hscroll -side bottom -fill x
    pack .rjob.f5.f2.text -side left -expand 1 -fill both

    frame .rjob.f5.f4 -bd 2 -relief "flat"
    button .rjob.f5.f4.b1 -text "\\/ Add \\/" -command {
	if { [.rjob.f5.f2.text curselection ] != "" } {
	    .rjob.f5.f6.text insert end [string trimright "[.rjob.f5.f1.e2 get ][.rjob.f5.f2.text get [.rjob.f5.f2.text curselection ]]" {.} ]
	    add2backup [.rjob.f1.f1.e1 get ] [string trimright "[.rjob.f5.f1.e2 get ][.rjob.f5.f2.text get [.rjob.f5.f2.text curselection ]]" {.} ]
	}
    }
    button .rjob.f5.f4.b2 -text "/\\ Remove /\\" -command {
	if { [.rjob.f5.f6.text curselection ] != "" } {
	    delbackup [.rjob.f1.f1.e1 get ] [.rjob.f5.f6.text get [.rjob.f5.f6.text curselection ] ]
	    .rjob.f5.f6.text delete [.rjob.f5.f6.text curselection ]
	}
    }
    pack .rjob.f5.f4.b1 .rjob.f5.f4.b2 -side left -fill x
    
    frame .rjob.f5.f6 -bd 2 -relief "flat"
    scrollbar .rjob.f5.f6.vscroll -orient vertical -command ".rjob.f5.f6.text yview" 
    scrollbar .rjob.f5.f6.hscroll -orient horizontal -command ".rjob.f5.f6.text xview"
    listbox .rjob.f5.f6.text -selectforeground white -selectbackground #000080 \
	    -yscrollcommand {.rjob.f5.f6.vscroll set } \
	    -xscrollcommand {.rjob.f5.f6.hscroll set } -height 6 -width 42
    .rjob.f5.f6.text config -cursor hand2
    pack .rjob.f5.f6.vscroll -side right -fill y
    pack .rjob.f5.f6.hscroll -side bottom -fill x
    pack .rjob.f5.f6.text -side left -expand 1 -fill both
    
    pack .rjob.f5.f2 .rjob.f5.f4 .rjob.f5.f6 -side top -fill both
    #getDir [ .rjob.hidden1 get ] $sd .rjob.f5.f2.text

    # ----  Action Frame
    label .rjob.f9.l1 -text "When the file already exists:"

    #    0 = Rename all files where the name conflicts (mtimes differ)
    #    1 = Skip all files where the name conflicts (mtimes differ)
    #    2 = Replace all files (mtimes differ).  This is for replication.
    #    4 = Replace all files even if there is no difference
    radiobutton .rjob.f9.b1 -text "Replace it." -variable coll -value 4
    radiobutton .rjob.f9.b2 -text "Replace if time differs." -variable coll -value 2
    radiobutton .rjob.f9.b3 -text "Skip it." -variable coll -value 1
    pack .rjob.f9.l1 .rjob.f9.b1 .rjob.f9.b2 .rjob.f9.b3 -anchor w

    # ----  Bottom buttons frame
    button .rjob.f7.b1 -text "Apply" -foreground red -activeforeground #a00000 -command {
	if { [ .rjob.hidden2 get ] != -9999 } {
	    set cmd "TAPE mod repids [ .rjob.hidden2 get ] "
	} else {
	    set cmd "TAPE add repids "
	}

	# job#:group#:action:uid:gid:dperm:fperm:newer:location:Descriptor
	global coll owns grps perm suid
	append cmd "[ .rjob.f1.f1.e1 get ]:[ .rjob.f2.f1.e1 get ]:$coll:"
	
	# Set UID and GID
	set ndperm 0
	if { $owns == 0 } { append cmd "0:" ; set ndperm [ expr 0x4000 | 0 ] } else { append cmd "[ .rjob.f3.f2.e1 get ]:" }
	if { $grps == 0 } { append cmd "0:" ; set t [expr $ndperm | 0x2000 ] ; set ndperm $t } else { append cmd "[ .rjob.f3.f2.e2 get ]:" }
	
	# Set SUID and perms
	set nfperm 0
	if { $suid == 0 } { set nfperm [ expr 0x8000 | 0 ] }
	if { $perm == 0 } { 
	    set t [expr $ndperm | 0x1000 ]
	    set ndperm $t 
	    append cmd "$ndperm:$nfperm:"
	} else {
	    # compute the value based on the buttons
	    append cmd "[ getnewperm $ndperm $nfperm ]:"
	}
	append cmd "0:[ .rjob.f2.f3.e1 get ]:[ .rjob.f1.f2.e1 get ]"
	set returnval [queryHost [.rjob.hidden1 get] $cmd 1 ]
	if { $errno != 0 } {
	    error 2501
	    puts stdout "ERROR:  Unable to add new replication job to [.rjob.hidden1 get]"
	} else {
	    repack 252
	    destroy .rjob
	}
    }
    button .rjob.f7.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command {
	destroy .rjob
    }
    button .rjob.f7.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command {
	help repljob
    }
    button .rjob.f7.b4 -text "Replicate Now" -foreground black -activeforeground #202020 -command {
	if { [ .rjob.f1.f1.e1 get ] != {} } {
	    set cmd "TAPE replicate [ .rjob.f1.f1.e1 get ]"
	    set returnval [queryHost [.rjob.hidden1 get] $cmd 1 ]
	}
	if { $errno != 0 } {
	    error 2502
	    puts stdout "ERROR:  Replication job [.rjob.hidden1 get] did not start"
	} 
	destroy .rjob
    }
    pack .rjob.f7.b1 .rjob.f7.b2 .rjob.f7.b3 .rjob.f7.b4 -side left -fill x -expand 1 

    # ------ Bindings ----------------
    bind .rjob.f5.f2.text <Button-3> {
	.rjob.f5.f6.text insert end [string trimright "[.rjob.f5.f1.e2 get ][.rjob.f5.f2.text get @%x,%y ]" {.} ]
	add2backup [.rjob.f1.f1.e1 get ] [string trimright "[.rjob.f5.f1.e2 get ][.rjob.f5.f2.text get @%x,%y ]" {.} ]
    }
    bind .rjob.f5.f6.text <Button-3> {
	delbackup [.rjob.f1.f1.e1 get ] [string trimright "[.rjob.f5.f6.text get @%x,%y ]" {.} ]
	.rjob.f5.f6.text delete @%x,%y
    }
    bind .rjob.f5.f6.text <Double-1> {
	if { [.rjob.f5.f6.text curselection ] != "" } {
	    .rjob.f5.f6.text delete [.rjob.f5.f6.text curselection ]
	}
    }
    bind .rjob.f5.f2.text <Double-1> {
	if { [.rjob.f5.f2.text curselection ] != {} } {
	    set t [.rjob.f5.f2.text get [.rjob.f5.f2.text curselection ] ]
	    if { $t == ".." } {
		# Need to go down a directory
		global sd
		set tmp [string trimright $sd {/} ]
		set ldir [string last {/} $tmp ]
		if { $ldir <= 0 } {
		    set sd "/"
		} else {
		    set tmp [string range $sd 0 $ldir ]
		    set sd $tmp
		}
		getDir [ .rjob.hidden1 get ] $sd .rjob.f5.f2.text
	    } elseif { [string range $t end end ] == {/} } {
		global sd
		set sd "[.rjob.f5.f1.e2 get ][.rjob.f5.f2.text get [.rjob.f5.f2.text curselection ] ]"
		getDir [ .rjob.hidden1 get ] $sd .rjob.f5.f2.text
	    }
	}
	.rjob.f5.f1.e2 delete 0 end
	.rjob.f5.f1.e2 insert end "$sd"


    }

    # --------------  Fill Entries ----------------
    global sd
    set sd "/"
    .rjob.f5.f1.e2 delete 0 end
    .rjob.f5.f1.e2 insert end "$sd"

    if { $jobnum != -9999 } {
	.rjob.f1.f1.e1 delete 0 end
	.rjob.f1.f1.e1 insert end $jobnum
	set tmp [ split $data {:} ]
	.rjob.f1.f2.e1 delete 0 end
	.rjob.f1.f2.e1 insert end [lindex $tmp 9 ]
	.rjob.f2.f3.e1 delete 0 end
	.rjob.f2.f3.e1 insert end [lindex $tmp 8 ]
	.rjob.f2.f1.e1 delete 0 end
	.rjob.f2.f1.e1 insert end [lindex $tmp 1 ]
	set rdata [queryHost $replserv "TAPE get groups" 0 ]
	foreach l $rdata {
	    set val [lindex [split $l ":"] 0]
	    if { $val == [lindex $tmp 1 ] } {
		.rjob.f2.f2.e1 delete 0 end
		.rjob.f2.f2.e1 insert end [lindex [split $l ":"] 2]
	    }
	}
	# job#:group#:action:uid:gid:dperm:fperm:newer:location:Descriptor
	.rjob.f3.f2.e1 delete 0 end
	.rjob.f3.f2.e1 insert end [lindex $tmp 3 ]
	.rjob.f3.f2.e2 delete 0 end
	.rjob.f3.f2.e2 insert end [lindex $tmp 4 ]
	if { [lindex $tmp 2 ] == 4 } {
	    .rjob.f9.b1 invoke
	} elseif { [lindex $tmp 2 ] == 2 } {
	    .rjob.f9.b2 invoke
	} else {
	    .rjob.f9.b3 invoke
	} 
	
	setperm [lindex $tmp 5 ] [lindex $tmp 6 ] 
    } else {
	.rjob.f3.f2.b1 invoke
	.rjob.f3.f2.b11 invoke
	.rjob.f3.f2.b21 invoke
	.rjob.f3.f2.b31 invoke
    }

}


proc btoggle { w } {
    if { [ $w cget -relief ] == {raised} } { 
	$w configure -relief sunken 
    } else { 
	$w configure -relief raised 
    }
}

# - Toggle the state of the file/directory permission buttons
proc bonoff { w state } {
    $w.d1 configure -state $state
    $w.d2 configure -state $state
    $w.d3 configure -state $state
    $w.d4 configure -state $state
    $w.d5 configure -state $state
    $w.d6 configure -state $state
    $w.d7 configure -state $state
    $w.d8 configure -state $state
    $w.d9 configure -state $state
    $w.o1 configure -state $state
    $w.o2 configure -state $state
    $w.o3 configure -state $state
    $w.o4 configure -state $state
    $w.o5 configure -state $state
    $w.o6 configure -state $state
    $w.o7 configure -state $state
    $w.o8 configure -state $state
    $w.o9 configure -state $state
}

proc setperm { dperm fperm } {
    # Allow SUID   0x00008000  (fperm) 
    if { $fperm & 0x8000 } {
	.rjob.f3.f2.b21 invoke
    } else {
	.rjob.f3.f2.b22 invoke
    }
    # Preserve UID   0x00004000 
    if { $dperm & 0x4000 } {
	.rjob.f3.f2.b1 invoke
    } else {
	.rjob.f3.f2.b2 invoke
    }
    # Preserve GID   0x00002000
    if { $dperm & 0x2000 } {
	.rjob.f3.f2.b11 invoke
    } else {
	.rjob.f3.f2.b12 invoke
    }
    # Preserve Perm  0x00001000
    if { $dperm & 0x1000 } {
	.rjob.f3.f2.b31 invoke
    } else {
	.rjob.f3.f2.b32 invoke
	
	# Set the directory permissions
	if { $dperm & 0x100 } { .rjob.f3.f1.d1 configure -relief sunken } else { .rjob.f3.f1.d1 configure -relief raised }
	if { $dperm & 0x80 } { .rjob.f3.f1.d2 configure -relief sunken } else { .rjob.f3.f1.d2 configure -relief raised }
	if { $dperm & 0x40 } { .rjob.f3.f1.d3 configure -relief sunken } else { .rjob.f3.f1.d3 configure -relief raised }
	if { $dperm & 0x20 } { .rjob.f3.f1.d4 configure -relief sunken } else { .rjob.f3.f1.d4 configure -relief raised }
	if { $dperm & 0x10 } { .rjob.f3.f1.d5 configure -relief sunken } else { .rjob.f3.f1.d5 configure -relief raised }
	if { $dperm & 0x8 } { .rjob.f3.f1.d6 configure -relief sunken } else { .rjob.f3.f1.d6 configure -relief raised }
	if { $dperm & 0x4 } { .rjob.f3.f1.d7 configure -relief sunken } else { .rjob.f3.f1.d7 configure -relief raised }
	if { $dperm & 0x2 } { .rjob.f3.f1.d8 configure -relief sunken } else { .rjob.f3.f1.d8 configure -relief raised }
	if { $dperm & 0x1 } { .rjob.f3.f1.d9 configure -relief sunken } else { .rjob.f3.f1.d9 configure -relief raised }

	# Set the file permissions
	if { $fperm & 0x100 } { .rjob.f3.f1.o1 configure -relief sunken } else { .rjob.f3.f1.o1 configure -relief raised }
	if { $fperm & 0x80 } { .rjob.f3.f1.o2 configure -relief sunken } else { .rjob.f3.f1.o2 configure -relief raised }
	if { $fperm & 0x40 } { .rjob.f3.f1.o3 configure -relief sunken } else { .rjob.f3.f1.o3 configure -relief raised }
	if { $fperm & 0x20 } { .rjob.f3.f1.o4 configure -relief sunken } else { .rjob.f3.f1.o4 configure -relief raised }
	if { $fperm & 0x10 } { .rjob.f3.f1.o5 configure -relief sunken } else { .rjob.f3.f1.o5 configure -relief raised }
	if { $fperm & 0x8 } { .rjob.f3.f1.o6 configure -relief sunken } else { .rjob.f3.f1.o6 configure -relief raised }
	if { $fperm & 0x4 } { .rjob.f3.f1.o7 configure -relief sunken } else { .rjob.f3.f1.o7 configure -relief raised }
	if { $fperm & 0x2 } { .rjob.f3.f1.o8 configure -relief sunken } else { .rjob.f3.f1.o8 configure -relief raised }
	if { $fperm & 0x1 } { .rjob.f3.f1.o9 configure -relief sunken } else { .rjob.f3.f1.o9 configure -relief raised }
    }
}

#
# getnewperm - Look at which buttons are pressed and compute the new permissions value
#              Inputs are the current directory and file values
#              Returns the ver values as "dperm:fperm"
proc getnewperm { dv fv } {
    set ndv 0
    set nfv 0
    if { [ .rjob.f3.f1.o1 cget -relief ] == "sunken" } {
	set t [ expr $nfv | 0x100 ]
	set nfv $t
    }
    if { [ .rjob.f3.f1.o2 cget -relief ] == "sunken" } {
	set t [ expr $nfv | 0x80 ]
	set nfv $t
    }
    if { [ .rjob.f3.f1.o3 cget -relief ] == "sunken" } {
	set t [ expr $nfv | 0x40 ]
	set nfv $t
    }
    if { [ .rjob.f3.f1.o4 cget -relief ] == "sunken" } {
	set t [ expr $nfv | 0x20 ]
	set nfv $t
    }
    if { [ .rjob.f3.f1.o5 cget -relief ] == "sunken" } {
	set t [ expr $nfv | 0x10 ]
	set nfv $t
    }
    if { [ .rjob.f3.f1.o6 cget -relief ] == "sunken" } {
	set t [ expr $nfv | 0x8 ]
	set nfv $t
    }
    if { [ .rjob.f3.f1.o7 cget -relief ] == "sunken" } {
	set t [ expr $nfv | 0x4 ]
	set nfv $t
    }
    if { [ .rjob.f3.f1.o8 cget -relief ] == "sunken" } {
	set t [ expr $nfv | 0x2 ]
	set nfv $t
    }
    if { [ .rjob.f3.f1.o9 cget -relief ] == "sunken" } {
	set t [ expr $nfv | 0x1 ]
	set nfv $t
    }

    if { [ .rjob.f3.f1.d1 cget -relief ] == "sunken" } {
	set t [ expr $ndv | 0x100 ]
	set ndv $t
    }
    if { [ .rjob.f3.f1.d2 cget -relief ] == "sunken" } {
	set t [ expr $ndv | 0x80 ]
	set ndv $t
    }
    if { [ .rjob.f3.f1.d3 cget -relief ] == "sunken" } {
	set t [ expr $ndv | 0x40 ]
	set ndv $t
    }
    if { [ .rjob.f3.f1.d4 cget -relief ] == "sunken" } {
	set t [ expr $ndv | 0x20 ]
	set ndv $t
    }
    if { [ .rjob.f3.f1.d5 cget -relief ] == "sunken" } {
	set t [ expr $ndv | 0x10 ]
	set ndv $t
    }
    if { [ .rjob.f3.f1.d6 cget -relief ] == "sunken" } {
	set t [ expr $ndv | 0x8 ]
	set ndv $t
    }
    if { [ .rjob.f3.f1.d7 cget -relief ] == "sunken" } {
	set t [ expr $ndv | 0x4 ]
	set ndv $t
    }
    if { [ .rjob.f3.f1.d8 cget -relief ] == "sunken" } {
	set t [ expr $ndv | 0x2 ]
	set ndv $t
    }
    if { [ .rjob.f3.f1.d9 cget -relief ] == "sunken" } {
	set t [ expr $ndv | 0x1 ]
	set ndv $t
    }
    set t [ expr $nfv | $fv ]
    set nfv $t
    set t [ expr $ndv | $dv ]
    set ndv $t
    
    return "$ndv:$nfv"
}