# NFS.tcl
#
# Copyright (c) 1997 Mark Black
#

#
# NFS update procedure
#
# USE NFSexport CurrentHost CurrentExport SelectedData
#             CHost   = host to update
#             Cexport = The current filesystem to work with.  Set to 9999 for a new export
#             Data    = line of data to modify.  Set to 9999 for a new export
#                       Data will be in the following form:
#                       [access=host1:...],ro,[rw=host2:...],[root=host3:...]
# NOTE: Data must be seperated by a single space or a singel tab
#
proc NFSexport { chost cexport line args } {
    set host $chost
    if { [string length $args ] != 0 } {
	append line " $args"
    }
    if { [winfo exists .nfs ] == 0 } {
	toplevel .nfs -class Dialog
	wm title .nfs "NFS Editor for $chost"
	wm iconname .nfs "NFS Editor"
	entry .nfs.hidden1 
	entry .nfs.hidden2
	entry .nfs.hidden3
	# NOT GOOD
	.nfs.hidden1 insert end $chost
	.nfs.hidden2 insert end $cexport
	.nfs.hidden3 insert end $line
	frame .nfs.f0 -bd 2 -relief "raised"
	label .nfs.f0.l1 -text "Shared directory:" -width 15
	entry .nfs.f0.e1 -width 20
	pack .nfs.f0.l1 .nfs.f0.e1 -fill x -side left -expand 1

	frame .nfs.f1 -bd 2 -relief "raised"
	label .nfs.f1.l1 -text "Minimum Access:"
	frame .nfs.f1.f1 -bd 0 -relief "flat"
	radiobutton .nfs.f1.f1.rb1 -text "None" -variable mtype -value "0" -command {
	    pack forget .nfs.f2 .nfs.f3 .nfs.f4 .nfs.f7 
	    pack .nfs.f2 .nfs.f3 .nfs.f4 .nfs.f7 -side top -fill both 
	}
	radiobutton .nfs.f1.f1.rb2 -text "Read only" -variable mtype -value "1" -command {
	    pack forget .nfs.f2 .nfs.f3 .nfs.f4 .nfs.f7
	    pack .nfs.f3 .nfs.f4 .nfs.f7 -side top -fill both 
	}
	radiobutton .nfs.f1.f1.rb3 -text "Read/Write" -variable mtype -value "2" -command {
	    pack forget .nfs.f2 .nfs.f3 .nfs.f4 .nfs.f7
	    pack .nfs.f4 .nfs.f7 -side top -fill both 
	}
	pack .nfs.f1.f1.rb1 .nfs.f1.f1.rb2 .nfs.f1.f1.rb3 -side left -fill x
	pack .nfs.f1.l1 .nfs.f1.f1 -fill x

	frame .nfs.f2 -bd 2 -relief "raised"
	label .nfs.f2.l1 -text "Read Only Access for host/netgroup:" 
	pack .nfs.f2.l1 -fill x
	frame .nfs.f2.f1 -bd 2 -relief "flat"
	entry .nfs.f2.f1.e1 -width 16
	button .nfs.f2.f1.b1 -text "Add" -command {
	    if { [.nfs.f2.f1.e1 get] != "" } {
		.nfs.f2.f2.text insert end [.nfs.f2.f1.e1 get]
	    }
	    .nfs.f2.f1.e1 delete 0 end
	}
	pack .nfs.f2.f1.e1 .nfs.f2.f1.b1 -fill both -side left -expand 1
	frame .nfs.f2.f2 -bd 2 -relief "flat"
	scrollbar .nfs.f2.f2.vscroll -orient vertical -command ".nfs.f2.f2.text yview" 
	listbox .nfs.f2.f2.text -selectforeground white -selectbackground #000080 -yscrollcommand {.nfs.f2.f2.vscroll set } -height 3 -width 16
	.nfs.f2.f2.text config -cursor hand2
	pack .nfs.f2.f2.vscroll -side left -fill y
	pack .nfs.f2.f2.text -side left -expand 1 -fill both
	button .nfs.f2.f2.b1 -text "Delete" -foreground red -activeforeground #a00000 -command {
	    if { [.nfs.f2.f2.text curselection ] != "" } {

		.nfs.f2.f2.text delete [.nfs.f2.f2.text curselection ]
	    }
	}
	pack .nfs.f2.f2.b1 -side left
	pack .nfs.f2.f1 .nfs.f2.f2 -side top -fill both -expand 1

	frame .nfs.f3 -bd 2 -relief "raised"
	label .nfs.f3.l1 -text "Read/Write Access for host/netgroup:" 
	pack .nfs.f3.l1 -fill x
	frame .nfs.f3.f1 -bd 2 -relief "flat"
	entry .nfs.f3.f1.e1 -width 16
	button .nfs.f3.f1.b1 -text "Add" -command {
	    if { [.nfs.f3.f1.e1 get] != "" } {
		.nfs.f3.f2.text insert end [.nfs.f3.f1.e1 get]
	    }
	    .nfs.f3.f1.e1 delete 0 end
	}
	pack .nfs.f3.f1.e1 .nfs.f3.f1.b1 -fill both -side left -expand 1
	frame .nfs.f3.f2 -bd 2 -relief "flat"
	scrollbar .nfs.f3.f2.vscroll -orient vertical -command ".nfs.f3.f2.text yview" 
	listbox .nfs.f3.f2.text -selectforeground white -selectbackground #000080 -yscrollcommand {.nfs.f3.f2.vscroll set } -height 3 -width 16
	.nfs.f3.f2.text config -cursor hand2
	pack .nfs.f3.f2.vscroll -side left -fill y
	pack .nfs.f3.f2.text -side left -expand 1 -fill both
	button .nfs.f3.f2.b1 -text "Delete" -foreground red -activeforeground #a00000 -command {
	    if { [.nfs.f3.f2.text curselection ] != "" } {
		.nfs.f3.f2.text delete [.nfs.f3.f2.text curselection ]
	    }
	}
	pack .nfs.f3.f2.b1 -side left
	pack .nfs.f3.f1 .nfs.f3.f2 -side top -fill both -expand 1


	frame .nfs.f4 -bd 2 -relief "raised"
	label .nfs.f4.l1 -text "Root Access for host:" 
	pack .nfs.f4.l1 -fill x
	frame .nfs.f4.f1 -bd 2 -relief "flat"
	entry .nfs.f4.f1.e1 -width 16
	button .nfs.f4.f1.b1 -text "Add" -command {
	    if { [.nfs.f4.f1.e1 get] != "" } {
		.nfs.f4.f2.text insert end [.nfs.f4.f1.e1 get]
	    }
	    .nfs.f4.f1.e1 delete 0 end
	}
	pack .nfs.f4.f1.e1 .nfs.f4.f1.b1 -fill both -side left -expand 1
	frame .nfs.f4.f2 -bd 2 -relief "flat"
	scrollbar .nfs.f4.f2.vscroll -orient vertical -command ".nfs.f4.f2.text yview" 
	listbox .nfs.f4.f2.text -selectforeground white -selectbackground #000080 -yscrollcommand {.nfs.f4.f2.vscroll set } -height 3 -width 16
	.nfs.f4.f2.text config -cursor hand2
	pack .nfs.f4.f2.vscroll -side left -fill y
	pack .nfs.f4.f2.text -side left -expand 1 -fill both
	button .nfs.f4.f2.b1 -text "Delete" -foreground red -activeforeground #a00000 -command {

	    if { [.nfs.f4.f2.text curselection ] != "" } {
		.nfs.f4.f2.text delete [.nfs.f4.f2.text curselection ]
	    }
	}
	pack .nfs.f4.f2.b1 -side left
	pack .nfs.f4.f1 .nfs.f4.f2 -side top -fill both -expand 1

	frame .nfs.f7 -bd 2 -relief "raised"
	button .nfs.f7.b1 -text "Apply" -foreground red -activeforeground #a00000 -command {
	    set opts [ mkoptline $mtype .nfs.f2.f2.text .nfs.f3.f2.text .nfs.f4.f2.text ]
	    if { [.nfs.hidden3 get] == 9999 } {
		set cmd "NFS add [.nfs.f0.e1 get] $opts"
	    } else {
		set cmd "NFS mod [.nfs.hidden2 get] [.nfs.f0.e1 get] $opts"
	    }
	    set returnval [queryHost [.nfs.hidden1 get] $cmd 1 ]
	    puts "Finished"
	    if { $errno != 0 } {
		error 91
		puts stdout "ERROR:  Unable to update the export (share) file on $currenthost"
	    } else {
		repack 81
		destroy .nfs
	    }
	}
	button .nfs.f7.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    destroy .nfs
	}
	button .nfs.f7.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help nfs
	}
	pack .nfs.f7.b1 .nfs.f7.b2 .nfs.f7.b3 -side left -fill x 


	pack .nfs.f0 .nfs.f1 .nfs.f2 .nfs.f3 .nfs.f4 .nfs.f7 -side top -fill both 
	
	# -------------- Bindings -----------------
	bind .nfs.f2.f1.e1 <Return> {
	    if { [.nfs.f2.f1.e1 get] != "" } {
		.nfs.f2.f2.text insert end [.nfs.f2.f1.e1 get]
	    }
	    .nfs.f2.f1.e1 delete 0 end
	}
	bind .nfs.f3.f1.e1 <Return> {
	    if { [.nfs.f3.f1.e1 get] != "" } {
		.nfs.f3.f2.text insert end [.nfs.f3.f1.e1 get]
	    }
	    .nfs.f3.f1.e1 delete 0 end
	}
	bind .nfs.f4.f1.e1 <Return> {
	    if { [.nfs.f4.f1.e1 get] != "" } {
		.nfs.f4.f2.text insert end [.nfs.f4.f1.e1 get]
	    }
	    .nfs.f4.f1.e1 delete 0 end
	}

    } else {
	# Window is open already
	.nfs.hidden1 delete 0 end
	.nfs.hidden2 delete 0 end
	.nfs.hidden2 delete 0 end
	.nfs.hidden1 insert end $chost
	.nfs.hidden2 insert end $cexport
	.nfs.hidden2 insert end $line
	.nfs.f2.f2.text delete 0 end
	.nfs.f3.f2.text delete 0 end
	.nfs.f4.f2.text delete 0 end
    }

    .nfs.f1.f1.rb3 invoke
    .nfs.f0.e1 delete 0 end
    if { $line == 9999 } {
	#

    } else {
	set flag 1
	.nfs.f0.e1 insert end $cexport
	set tline [lindex $line 1]
	foreach opt [split $tline "," ] {
	    # Parse the options 
	    set tmp [split $opt "=" ]
	    if { [llength [split $opt "=" ]] == 2 } {
		if { [lindex $tmp 0 ] == "root" } {
		    foreach val [split [lindex $tmp 1 ] ":" ] {
			.nfs.f4.f2.text insert end $val
		    }
		} elseif { [lindex $tmp 0 ] == "rw" } {
		    foreach val [split [lindex $tmp 1 ] ":" ] {
			.nfs.f3.f2.text insert end $val
		    }
		} elseif { [lindex $tmp 0 ] == "ro" } {
		    foreach val [split [lindex $tmp 1 ] ":" ] {
			.nfs.f2.f2.text insert end $val
		    }
		} else {
		    puts stdout "Unknown option: >[lindex $tmp 0 ]<"
		}
	    } else {
		# It's a minimum access option 
		if {$tmp == "ro" } {
		    set flag 2
		} elseif {$tmp == "rw" } {
		    set flag 3
		}
	    }
	    .nfs.f1.f1.rb$flag invoke
	}

    }

}



#
# mkoptline - build the options line from the text boxes
#
# USE  mkoptline mtype robox rwbox rootbox
#             mtype   - majority access type
#             robox   - read only client listbox
#             rwbox   - read write client listbox
#             rootbox - root acces listbox 
proc mkoptline { mtype robox rwbox rootbox } {
    set opt {}
    if { $mtype == 1 } {
	set opt "ro,"
    } elseif { $mtype == 2 } {
	set opt "rw,"
    }
    
    if { $mtype == 0 } {
	# When there 
	if { [$robox get 0 end] != {} } {
	    set tmp "ro="
	    foreach host [$robox get 0 end] {
		append tmp "[string tolower [string trimright $host]]:"
	    }
	    append opt [string trimright $tmp ":" ]
	    append opt ","
	}
    }
	
    if { $mtype <= 1 } {
	if { [$rwbox get 0 end] != {} } {
	    set tmp "rw="
	    foreach host [$rwbox get 0 end] {
		append tmp "[string tolower [string trimright $host]]:"
	    }
	    append opt [string trimright $tmp ":" ] 
	    append opt ","
	}
    }
    
    if { [$rootbox get 0 end] != {} } {
	set tmp "root="
	foreach host [$rootbox get 0 end] {
	    append tmp "[string tolower [string trimright $host]]:"
	}
	append opt [string trimright $tmp ":" ] 
    }
    
    return $opt
}


#
# Build the NFS screen
#
proc canNFS {} {
    global currenthost
    global level
    global browse
    set level 80
    .tp.title configure -text "Host($currenthost) --> Config --> NFS Server"
    set config_label { <-Back Exported Clients {NFS Stats} }
    set browse_val { -20 81 82 83}
    populateCan $config_label $browse_val
    #    .tp.host.canvas create text 270 100  -justify center -text "Warning Alpha Code!" -fill red -font {-*-Helvetica-Medium-R-Normal--*-180-*-*-*-*-*-*}
}

