# Mount.tcl
#
# Copyright (c) 1997 Mark Black
#

#
# Fstab update procedure
#
# USE Fstab CurrentHost CurrentLine SelectedData
#             CurrentHost = host to update
#             SelectedData = line of data to modify
# NOTE: Data must be seperated by a single space or a singel tab
#
proc Fstab { currenthost args } {
    global errno
    set host $currenthost
    if { $args != {} } {
	set line [ string trim $args {\{\}} ]
    } else {
	set line {} 
    }
    if { [winfo exists .fstab ] == 0 } {
	toplevel .fstab -class Dialog
	wm title .fstab "Fstab Editor: $currenthost"
	wm iconname .fstab "Fstab Editor"
	entry .fstab.hidden1 
	entry .fstab.hidden2
	entry .fstab.hidden3
	.fstab.hidden1 insert end $currenthost
	.fstab.hidden2 insert end $line
	frame .fstab.f0 -bd 2 -relief "raised"
	button .fstab.f0.b1 -text "NFS Server:" -width 15 -command "mknfslist .fstab.f0.b1"
	entry .fstab.f0.e1 -width 20
	pack .fstab.f0.b1 .fstab.f0.e1 -fill both -side left -expand 1

	frame .fstab.f6 -bd 2 -relief "raised"
	button .fstab.f6.b1 -text "NFS Filesystem:" -width 15 -command "mkexportlist .fstab.f6.b1"
	entry .fstab.f6.e1 -width 20
	pack .fstab.f6.b1 .fstab.f6.e1 -fill both -side left -expand 1

	frame .fstab.f1 -bd 2 -relief "raised"
	label .fstab.f1.l1 -text "Device:" -width 15
	entry .fstab.f1.e1 -width 20
	.fstab.f1.e1 insert end "/dev/"
	pack .fstab.f1.l1 .fstab.f1.e1 -fill both -side left -expand 1
	frame .fstab.f2 -bd 2 -relief "raised"
	label .fstab.f2.l1 -text "Mount point:" -width 15
	entry .fstab.f2.e1 -width 20
	pack .fstab.f2.l1 .fstab.f2.e1 -fill both -side left -expand 1
	
	frame .fstab.f3 -relief "raised" -bd 2
	menubutton .fstab.f3.l1 -text "Type:" -width 15 -menu .fstab.f3.l1.m -relief raised
	menu .fstab.f3.l1.m -tearoff 0 
	entry .fstab.f3.e1 -width 20
	pack .fstab.f3.l1 .fstab.f3.e1 -side left -anchor w -fill x -padx 2
	pack .fstab.f3 -fill x -side top

	# Get the host type
	frame .fstab.f4 -bd 2 -relief "raised"
	label .fstab.f4.l1 -text "Mount Options" -width 6
	pack .fstab.f4.l1 -fill x -side top
	frame .fstab.f4.f0 -bd 0
	checkbutton .fstab.f4.f0.ck1 -text "Defaults" -selectcolor #000080 -variable dopt -onvalue 1 -offvalue 0 -command {
	    if { $dopt == 1 } {
		# Default options selected
		pack forget .fstab.f4.f1
		pack forget .fstab.f4.f2
	    } else {
		# NON default options selected
		pack .fstab.f4.f1 .fstab.f4.f2 -fill x -side top
	    }
	}
	
	radiobutton .fstab.f4.f0.rb1 -text "rw" -selectcolor #a00000 -variable ropt -value rw
	radiobutton .fstab.f4.f0.rb2 -text "ro" -selectcolor #a00000 -variable ropt -value ro
	pack .fstab.f4.f0.ck1 .fstab.f4.f0.rb1 .fstab.f4.f0.rb2 -fill x -side left
	frame .fstab.f4.f1 -bd 0
	radiobutton .fstab.f4.f1.rb5 -text "suid" -selectcolor #008000 -variable sopt -value suid
	radiobutton .fstab.f4.f1.rb6 -text "nosuid" -selectcolor #008000 -variable sopt -value nosuid
	radiobutton .fstab.f4.f1.rb7 -text "exec" -selectcolor #a00000 -variable opt -value exec
	radiobutton .fstab.f4.f1.rb8 -text "noexec" -selectcolor #a00000 -variable opt -value noexec
	frame .fstab.f4.f2 -bd 2 -relief "flat"
	label .fstab.f4.f2.l1 -text "Other Options:" -width 16
	entry .fstab.f4.f2.e1 -width 16
	pack .fstab.f4.f2.l1 .fstab.f4.f2.e1 -fill both -side left -expand 1
	pack .fstab.f4.f1.rb5 .fstab.f4.f1.rb6 .fstab.f4.f1.rb7 .fstab.f4.f1.rb8 -fill x -side left
	pack .fstab.f4.f0 -fill x -side top
	frame .fstab.f5 -bd 2 -relief "raised"
	button .fstab.f5.b1 -text "Apply" -foreground red -activeforeground #a00000 -command {
	    set abort 0
	    # Build first field
	    if { [.fstab.f3.e1 get] == "nfs" } {
		if { [ .fstab.f0.e1 get ] != {} && [ .fstab.f6.e1 get ] != {} } {
		    set outline "[ .fstab.f0.e1 get ]:[.fstab.f6.e1 get]\t"
		} else {
		    set abort 1
		    error 181
		}
	    } else {
		set outline "[.fstab.f1.e1 get]\t"
	    }

	    # Build Next three fields 
	    if { [.fstab.hidden3 get] == 1 } {
		# Linux
		append outline "[.fstab.f2.e1 get]\t[.fstab.f3.e1 get]\t"
		if { $dopt == 1 } {
		    append outline "defaults,$ropt"
		} else {
		    append outline "$ropt"
		    if { $sopt == "suid" | $sopt == "nosuid" } {
			append outline ",$sopt"
		    }
		    if { $opt == "exec" | $opt == "noexec" } {
			append outline ",$opt"
		    }
		    if { [.fstab.f4.f2.e1 get] != "" } {
			append outline ",[.fstab.f4.f2.e1 get]"
		    }
		}
	    } elseif { [.fstab.hidden3 get] == 2 } {
		# SunOS
		append outline "[.fstab.f2.e1 get]\t[.fstab.f3.e1 get]\t"
		if { $dopt == 1 } {
		    append outline "$ropt"
		} else {
		    append outline "$ropt"
		    if { $sopt == "fg" | $sopt == "bg" } {
			append outline ",$sopt"
		    }
		    if { $opt == "hard" | $opt == "soft" } {
			append outline ",$opt"
		    }
		    if { [.fstab.f4.f2.e1 get] != "" } {
			append outline ",[.fstab.f4.f2.e1 get]"
		    }
		}
	    } elseif { [.fstab.hidden3 get] == 3 } {
		# Solaris
		append outline "[.fstab.f2.e1 get]\t[.fstab.f3.e1 get]\t"
		if { $dopt == 1 } {
		    append outline "$ropt"
		} else {
		    append outline "$ropt"
		    if { $sopt == "bg" | $sopt == "fg" } {
			append outline ",$sopt"
		    }
		    if { $opt == "hard" | $opt == "soft" } {
			append outline ",$opt"
		    }
		    if { [.fstab.f4.f2.e1 get] != "" } {
			append outline ",[.fstab.f4.f2.e1 get]"
		    }
		}
	    } else {
		set abort 1
		error 999
	    }

	    if { [.fstab.hidden2 get] == {} } {
		set cmd "CON add fstab $outline"
	    } else {
		set t [ lindex [.fstab.hidden2 get] 0 ]
		set cmd "CON mod fstab $t $outline"
	    }
	    if {$abort != 1 } {
		set returnval [queryHost [.fstab.hidden1 get] $cmd 1 ]
		if { $errno != 0 } {
		    error 182
		    puts stdout "ERROR:  Unable to update the /etc/fstab file on [.fstab.hidden1 get]\n       Check the files permissions"
		} else {
		    repack 3
		    destroy .fstab
		}
	    }
	}
	button .fstab.f5.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    destroy .fstab
	}
	button .fstab.f5.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help fstab
	}
	pack .fstab.f5.b1 .fstab.f5.b2 .fstab.f5.b3 -side left -anchor w -fill x
	pack .fstab.f3 .fstab.f1 .fstab.f2 .fstab.f4 .fstab.f5 -side top -expand 1 -fill both
    } else {
	wm title .fstab "Fstab Editor: $currenthost"
	.fstab.hidden1 delete 0 end
	.fstab.hidden2 delete 0 end
	.fstab.hidden1 insert end $currenthost
	.fstab.hidden2 insert end $line
    }
    # ------------- Bindings ------------------
    bind .fstab.f0.e1 <Return> {
	focus .fstab.f1.e1
    }
    bind .fstab.f1.e1 <Return> {
	focus .fstab.f2.e1
    }
    # ---------  Initialize  ----------------
    # Get the host type, and repack accordingly
    set htype [ lindex [split [gethostent [.fstab.hidden1 get ]] ":" ] 1 ]
    puts stdout "Host type = $htype"
    if { $htype == "linux" } {
	.fstab.f4.f1.rb5 configure -text "suid" -variable sopt -value suid
	.fstab.f4.f1.rb6 configure -text "nosuid" -variable sopt -value nosuid
	.fstab.f4.f1.rb7 configure -text "exec" -variable opt -value exec
	.fstab.f4.f1.rb8 configure -text "noexec" -variable opt -value noexec
	.fstab.hidden3 delete 0 end
	.fstab.hidden3 insert end 1
	set fss {nfs ext2 msdos vfat iso9660 minix ext xiafs hpfs umsdos sysv}
    } elseif { $htype == "sunos" } {
	.fstab.f4.f1.rb5 configure -text "bg" -variable sopt -value bg
	.fstab.f4.f1.rb6 configure -text "fg" -variable sopt -value fg
	.fstab.f4.f1.rb7 configure -text "hard" -variable opt -value hard
	.fstab.f4.f1.rb8 configure -text "soft" -variable opt -value soft
	.fstab.hidden3 delete 0 end
	.fstab.hidden3 insert end 2
	set fss {nfs 4.2 hsfs}
    } elseif { $htype == "solaris" } {
	.fstab.f4.f1.rb5 configure -text "bg" -variable sopt -value bg
	.fstab.f4.f1.rb6 configure -text "fg" -variable sopt -value fg
	.fstab.f4.f1.rb7 configure -text "hard" -variable opt -value hard
	.fstab.f4.f1.rb8 configure -text "soft" -variable opt -value soft
	.fstab.hidden3 delete 0 end
	.fstab.hidden3 insert end 3
	set fss {nfs ufs}
    } elseif { $htype == "irix" } {
	.fstab.f4.f1.rb5 configure -text "bg" -variable sopt -value bg
	.fstab.f4.f1.rb6 configure -text "fg" -variable sopt -value fg
	.fstab.f4.f1.rb7 configure -text "hard" -variable opt -value hard
	.fstab.f4.f1.rb8 configure -text "soft" -variable opt -value soft
	.fstab.hidden3 delete 0 end
	.fstab.hidden3 insert end 2
	set fss {nfs xfs efs}
    } else {
	puts stdout "NOTE:  Don't know what type of host this is.\nRun then Probe to determine host type."
	set fss {nfs}
    }
    for { set cnt 0 } { $cnt < 8 } { incr cnt 1 } {
	.fstab.f3.l1.m add command -label [lindex $fss $cnt] \
		-command ".fstab.f3.e1 delete 0 end ; .fstab.f3.e1 insert end [lindex $fss $cnt] ; fstype [lindex $fss $cnt]"
    }
    set dopt 1
    .fstab.f4.f0.ck1 invoke
    .fstab.f4.f0.rb2 select

    if { $line != {} } {
	set mntWhat [lindex $line 0 ]
	set mntWhere [lindex $line 1 ]
	set mntType [lindex $line 2 ]
	set mntOpt [lindex $line 3 ]
	.fstab.f3.e1 delete 0 end
	.fstab.f3.e1 insert end $mntType

	# Flag for default settings
	set flag 0
	# Flag indicating other options
	set oflag 0
	foreach val [ split $mntOpt {, } ] {
	    if { $val == "defaults" } {	
		set dopt 1
		.fstab.f4.f0.ck1 deselect
		.fstab.f4.f0.ck1 invoke
		set ropt $val
		.fstab.f4.f0.rb1 invoke
		# Use flag to indicate that this is non-default, so change view
		set flag 1
	    } elseif { $val == "rw" } {
		set ropt $val
		.fstab.f4.f0.rb1 invoke
	    } elseif { $val == "ro" } {	
		set ropt $val
		.fstab.f4.f0.rb2 invoke
	    } elseif { $val == "exec" | $val == "bg" } {
		set opt $val
		.fstab.f4.f1.rb7 invoke
	    } elseif { $val == "noexec" | $val == "fg" } {	
		set opt $val
		.fstab.f4.f1.rb8 invoke
	    } elseif { $val == "suid" | $val == "hard" } {
		set sopt $val
		.fstab.f4.f1.rb5 invoke
	    } elseif { $val == "nosuid" | $val == "soft" } {	
		set sopt $val
		.fstab.f4.f1.rb6 invoke
	    } else {
		if { $oflag == 0 } {
		    .fstab.f4.f2.e1 delete 0 end
		    .fstab.f4.f2.e1 insert end $val
		    set oflag 1
		} else {
		    .fstab.f4.f2.e1 insert end ",$val"
		}
	    }
	}
	if { $flag == 0 } {
	    .fstab.f4.f0.ck1 select
	    .fstab.f4.f0.ck1 invoke
	}
	.fstab.f2.e1 delete 0 end
	.fstab.f2.e1 insert end $mntWhere
	if [ regexp {^/} $mntWhat ] {
	    .fstab.f1.e1 delete 0 end
	    .fstab.f1.e1 insert end $mntWhat
	} else {
	    set mntServer {}
	    set mntWhat {}
	    regexp -nocase {^([a-z0-9]+):(.+)} $mntWhat match mntServer mntWhat
	    .fstab.f6.e1 delete 0 end
	    .fstab.f6.e1 insert end $mntWhat
	    .fstab.f0.e1 delete 0 end
	    .fstab.f0.e1 insert end $mntServer
	}
    }
}


proc fstype { type } {
    if {$type == "nfs"} {
	.fstab.f1.l1 configure -text "Remote directory:"
	.fstab.f1.e1 delete 0 end
	pack forget .fstab.f1 
	pack forget .fstab.f2 
	pack forget .fstab.f4
	pack forget .fstab.f5
	pack forget .fstab.f6
	pack .fstab.f0 .fstab.f6 .fstab.f2 .fstab.f4 .fstab.f5 -side top -expand 1 -fill both
    } else {
	.fstab.f1.l1 configure -text "Device:"
	.fstab.f1.e1 delete 0 end
	.fstab.f1.e1 insert end "/dev/"
	set htype [ lindex [split [gethostent [.fstab.hidden1 get ]] ":" ] 1 ]
	if { $htype == "solaris" | $htype == "sunos" } {
	    .fstab.f1.e1 insert end "dsk/"
	}
	pack forget .fstab.f0
	pack forget .fstab.f1 
	pack forget .fstab.f2 
	pack forget .fstab.f4
	pack forget .fstab.f5
	pack forget .fstab.f6
	pack .fstab.f1 .fstab.f2 .fstab.f4 .fstab.f5 -side top -expand 1 -fill both
    }
}


#
# getnfsservs - get a list of all the NFS servers from the host list
#
proc getnfsservs { } {
    global active_hosts
    global currenthost
    set nfs_serv {}
    foreach line $active_hosts {
	# For each line search it for the services it provides
	foreach data [split [lindex [ split $line ":" ] 3 ] "," ] {
	    if { $data == "NFS" } {
		if { [ lindex [split $line ":" ] 0 ] != $currenthost } {
		    lappend nfs_serv [ lindex [split $line ":" ] 0 ]
		}
	    } 
	}
    }
    return $nfs_serv
}


#
# mknfslist  - Make a selector list for all the NFS servers
#              This function parses the host list and adds all 
#              NFS server machines to the list.
# w - is the calling window
# NOTE:  This contains a fixed reference to en external entry
#
proc mknfslist { w } {
    set mpos [winfo pointerxy $w ]
    # Get a list of all the NFS servers
    set nfs_serv [ getnfsservs ]
    
    if {[string match $w [eval winfo contain $mpos ]]} {
	# Cursor on window
	set n .crclick
	if ![winfo exists $n ] {
	    toplevel $n
	    wm override $n 1
	    wm withdraw $n
	    text $n.t -width 20 -height 2 -relief raised
	    pack $n.t
	}
	update idle
	
	# Create the text box entries and bindings
	set cnt 0
	set bold "-background #c0c000 -relief raised -borderwidth 1"
	set normal "-background {} -relief flat"

	foreach val $nfs_serv {
	    $n.t insert end "$val\n" tag$cnt
	    $n.t tag bind tag$cnt <Any-Enter> "$n.t tag configure tag$cnt $bold"
	    $n.t tag bind tag$cnt <Any-Leave> "$n.t tag configure tag$cnt $normal"
	    $n.t tag bind tag$cnt <Button-1> ".fstab.f0.e1 delete 0 end ; .fstab.f0.e1 insert end $val ;destroy $n"
	    incr cnt 1 
	}
	    
	$n.t configure -height [llength $nfs_serv]
	bind $n <Any-Leave> "destroy $n"
	set x [expr [lindex $mpos 0 ] - 10 ]
	set y [expr [lindex $mpos 1 ] - 10 ]
	wm geometry $n +$x+$y
	wm deiconify $n
	raise $n
    }
}




#
# mkexportlist  - Make a selector list of all the NFS exported fileststems
#                 This function queries the selected host for exported
#                 filesystems, and displays them.
# w - is the calling window
# NOTE:  This contains a fixed reference to en external entry
#
proc mkexportlist { w } {
    set mpos [winfo pointerxy $w ]
    if { [.fstab.f0.e1 get] != {} } {
	set nfs_serv [ getnfsservs ]
	if { [string match "\*[.fstab.f0.e1 get]\*" $nfs_serv ] == 1 } {
	    puts stdout "Got: to here 2"
	    # We have a valid NFS server, Get exported filesystems
	    set tmp [ queryHost [.fstab.f0.e1 get] "MON get exports" 0 ]
	    set nfs_exprts {}
	    for { set position 0 } { $position < [llength $tmp] } { incr position 1 } {
		lappend nfs_exprts [lindex [lindex $tmp $position] 0]
	    }
	    if {[string match $w [eval winfo contain $mpos ]]} {
		# Cursor on window
		set n .exprtlist
		if ![winfo exists $n ] {
		    toplevel $n
		    wm override $n 1
		    wm withdraw $n
		    text $n.t -width 20 -height 2 -relief raised
		    pack $n.t
		}
		update idle
		
		# Create the text box entries and bindings
		set cnt 0
		set bold "-background #c0c000 -relief raised -borderwidth 1"
		set normal "-background {} -relief flat"
		
		foreach val $nfs_exprts {
		    $n.t insert end "$val\n" tag$cnt
		    $n.t tag bind tag$cnt <Any-Enter> "$n.t tag configure tag$cnt $bold"
		    $n.t tag bind tag$cnt <Any-Leave> "$n.t tag configure tag$cnt $normal"
		    $n.t tag bind tag$cnt <Button-1> ".fstab.f6.e1 delete 0 end ; .fstab.f6.e1 insert end $val ;destroy $n"
		    incr cnt 1 
		}
		
		$n.t configure -height [llength $nfs_exprts]
		bind $n <Any-Leave> "destroy $n"
		set x [expr [lindex $mpos 0 ] - 10 ]
		set y [expr [lindex $mpos 1 ] - 10 ]
		wm geometry $n +$x+$y
		wm deiconify $n
		raise $n
	    }
	}
    }
}









