#  Main.tcl    
#  Copyright (c) 1997 Mark Black
#
#  This library of functions is required by the main body of code.
#  It contains the code for filling the list boxes.
#
# Contents:
#   error        - Error box
#   pingHost     - MAT ping a host
#   queryhost    - Host-to-Host communications
#   getPasswd    - Login Procedure
#   newPass      - password update procedure
#   filllist     - Read data and fill listbox
#   fillhostlist - Unused
#   Selecter     - Select and De-select lines of text
#   HostInfo     - Display Host Info
#   actionItem   - Display a message and prompt for a response
#

# CVERSION is a flag to indicate that the C version of the server is the target
set CVERSION 1

set server_socket {}
set old_s_sock {}

proc bgerror { args } {
    global server_socket
    if { $server_socket != {} } {
	puts stdout "Attempting to cancel!"
    } else {
	puts stdout "TK ERROR: $args"
    }
}


#
# ----- Error Procedures -----
#
proc error { class } {
    # Error Numbers
    # 180 - 199  - fstab errors
    # 200 - 219  - DNS Client
    # 220 - 239  - Password
    # 240 - 259  - Mail Aliases
    # 260 - 279  - Motd
    # 280 - 309  - DNS Master
    # 310 - 339  - Users 
    # 340 - 359  - MAT Users
    # 360 - 379  - Crontab
    # 380 - 399  - NIS
    # 400 - 419  - General Config
    # 500 - 549  - Archive
    # 550 - 599  - Monitored messages
    # 2000 - 2499 - Tape messages
    # 2500 - 3000 - Replication messages

    global currenthost

    set mes(1)   "Unable to Update $currenthost"
    set mes(2)   "Please Select a Host first!"
    set mes(3)   "Please Select a Task to Delete!"
    set mes(4)   "Please Select Something first!"
    set mes(5)   "Invalid Pass String!"
    set mes(6)   "Can't communicate with $currenthost"
    set mes(7)   "Failed to update License file"
    set mes(19)  "Failed to update file.  Check contents"
    set mes(50)  "Error in IP Address"
    set mes(51)  "Hosts Update Failed!"
    set mes(71)  "Cannot Delete Entry!"
    set mes(91)  "Cannot Update Entry!"
    set mes(99)  "Command Pending!"
    set mes(101) "Please Select a Primary Group"
    set mes(102) "Passwords are not the same!"
    set mes(103) "Please give an initial Password"
    set mes(104) "Unable to Add/Modify User!"
    set mes(180) "Unrecognized filesystem type"
    set mes(181) "Insufficient information"
    set mes(182) "Unable to update /etc/(v)fstab!"
    set mes(200) "Invalid IP address"
    set mes(201) "Invalid IP address.  Reserved for broadcasts"
    set mes(202) "This is a Network address"
    set mes(203) "Please Specify the Domain"
    set mes(204) "Please Specify at least one Nameserver"
    set mes(205) "Unable to update DNS Client configuration!"
    set mes(220) "New Strings are not the same!"
    set mes(221) "Unable to Change Authentication String!"
    set mes(240) "Unable to Update the Mail Aliases File"
    set mes(241) "Unable to Update the Mailing List file"
    set mes(242) "Unable to Read the Mailing List file"
    set mes(260) "Unable to Update the Login Message"
    set mes(280) "Please Select a Domain to edit, or add a new one."
    set mes(281) "Please use a byte oriented network address (ends in 0)."
    set mes(282) "Domain not found.  Creating new one."
    set mes(283) "Unable to update DNS records!"
    set mes(284) "Please provide a host name!"
    set mes(285) "Unable to write DNS named.boot file"
    set mes(286) "The DNS Master IP address is invalid"
    set mes(287) "DNS domain missing"
    set mes(288) "DNS Master hostname missing"
    set mes(289) "Contact email address missing"
    set mes(290) "Invalid or missing paramater"
    set mes(291) "Unable to send HUP signal to DNS server deamon"
    set mes(292) "Unable to update DNS masters records "
    set mes(293) "Can't communicate with secondary server"
    set mes(310) "Warning:  The users GID is not listed in the group file."
    set mes(311) "Warning:  The users GID is the same as root's!"
    set mes(340) "Please give a login name."
    set mes(341) "Please give a password."
    set mes(342) "Passwords do not match. Try again."
    set mes(360) "Please provide a process to run."
    set mes(361) "Update of crontab failed!"
    set mes(380) "Unable to update NIS Netgroup!"
    set mes(381) "Unable to update NIS Ethers!"
    set mes(400) "Please provide a service name."
    set mes(401) "Please provide a service port."
    set mes(402) "Update of services failed!"
    set mes(402) "Can't read directory information"
    set mes(501) "Can't update job backup list"
    set mes(502) "Can't add backup device"
    set mes(503) "Invalid backup device path"
    set mes(504) "Invalid backup device number (0-999)"
    set mes(505) "A backup device must be selected"
    set mes(506) "A unique tape ID number must be provided"
    set mes(550) "Unable to get monitored parameter data"
    set mes(551) "Please provide all required data"
    set mes(2001) "Unable to create a new tape header"
    set mes(2002) "Unable to perform backup"
    set mes(2003) "Unable to perform restore"
    set mes(2004) "Select a tape server first"
    set mes(2005) "Cannot get backup list"
    set mes(2006) "Cannot get backup history"
    set mes(2501) "Unable to create/modify the replication job"
    set mes(2502) "Replication job failed to start"
    set mes(2503) "Backup job failed to start"
    actionItem . $mes($class) "Dismiss" red
}

#
# -- Scramble the password (weak scrambling)
# Returns scrambled version
proc scrampass { key } {
    global passwd
    set skey [split $key {} ]
    set spass [split $passwd {} ]
    set roll 0
    foreach c $skey {
	set tmp [expr $roll ^ [getpos $c ]]
	set roll $tmp
    }
    set np {}
    foreach c [split $passwd {} ] {
	set tmp [expr $roll ^ [getpos $c ]]
	append np [string index "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 ." $tmp ]
	set roll $tmp
    }
    return $np
}

#
# - Find the array position
#
proc getpos { char } {
    set chars [split "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 " {} ]
    set pos 0
    foreach val $chars {
	if { $val == $char } "return $pos"
	incr pos 1
    }
    return $pos
}

set ping_sock 0
set ping_val {}

#
# ---------------- Procedure for Pinging MAT Agent -------------------
#
# USE:  pingHost $hostname
# Returns 1 on success, 0 in failure
#
proc pingHost { hostname } {
    global port
    global ping_sock
    global ping_val
    global errno
    catch "socket $hostname $port" retval
    set ping_sock $retval
    if { [string first "sock" [lindex $retval 0 ]] == -1 } {
	# Ping failed.....  Host not responding
	set errno 1
	return 0
    } else {
	set stream_status 0
	fileevent $ping_sock readable {
	    set ping_val [gets $ping_sock ]
	    set stream_status 1
	}
	# Let start line pass
	vwait stream_status
	set stream_status 0
	puts $ping_sock "ping"
	flush $ping_sock
	vwait stream_status
	close $ping_sock
    }
    set errno 0
    return $ping_val
}


#
# ---------------- Procedure for Querying Hosts ----------------
#
#   hostname = the Name of the host
#   command  = The command to send
#   visable  = (1) display result, (0) display nothing
#   args     = extended command set
#              arg(0) = ext    - Extended command flag
#              arg(1) = type   - Extended command type  [ put ]
#                                USE:  put {type} {widget}    type = widget type [t=text, l=list]   widget = widget path 
# This is ONLY good for one line commands
proc queryHost { hostname command visable args } {
    global port passwd username socket_data errno errorm authenticated server_socket old_s_sock
    
    # Check if anything is still pending (errno=999 for pending)
    . config -cursor watch
    set tkill [ ticker 1 ]
#    set visable 1
    if { $visable == 1 } {
	if { [winfo exists .sock ] == 0 } {
	    toplevel .sock -class Dialog
	    wm title .sock "Command Output"
	    wm iconname .sock "Command Output"
	    text .sock.text -width 70 -height 12 -yscrollcommand { .sock.textscroll set }
	    scrollbar .sock.textscroll -orient vertical -command ".sock.text yview"
	    pack .sock.textscroll -side left -fill y
	    pack .sock.text -side bottom -expand 1 -fill both
	    button .sock.quit -text "Dismiss" -command "destroy .sock"
	    pack .sock.quit 
	}
    }
    if { [winfo exists .shidden1 ] == 0 } {
	entry .shidden1 
    }
    .shidden1 delete 0 end
    .shidden1 insert end $visable
    set socket_data ""
    set stream_status 0
    set authenticated 0

    if { $server_socket != {} } {
	set retval [ actionItem . "A pending command has not finished, before a new command was issued." "Cancel" red ]
	after cancel ticker 0
	after cancel ticker 1
	after cancel ticker 0
	after cancel ticker 1
	. config -cursor top_left_arrow
	close $server_socket
	set server_socket {}
	puts stdout "Canceling command.  Ignore the following message."
	return ""
    } else {
	# If can't connect issue an error
	catch "socket $hostname $port" retval
	set old_s_sock $server_socket
	set server_socket $retval
    }

    # If can't connect issue an error
    if { [string first "sock" [lindex $retval 0 ]] == -1 } {
	# Host not responding
	set errno 2
	after cancel ticker 0
	after cancel ticker 1
	. config -cursor top_left_arrow
	set server_socket {}
	return "ERROR:  MAT Agent on $hostname not responding"
    }
    set key {}
    fconfigure $server_socket -buffering line  
    fileevent $server_socket readable {
	set l [gets $server_socket ]
	#puts stderr "Fileevent: $l"
	global authenticated
	if { $authenticated == 0 } {
	    if { $l == "Authentication Passed" } {
		set authenticated 1
		set stream_status 100
	    } elseif { [lindex [split $l " " ] 0 ] == "ERROR:" } {
		set authenticated 0
		set stream_status 99
		error 5
		puts stderr "PASS ERROR:  Auth=$authenticated  Stream_stat=$stream_status"
	    }
	    if { [.shidden1 get ] == 1 } {
		    .sock.text insert end "$l\n"
	    }
	    if { [lindex $l 0 ] == "MAT" & [lindex $l 1 ] == "Agent" } {
		set key [lindex [split $l ">" ] 1 ]
	    }
	    if { $authenticated == 0 } {
		set p [ scrampass $key ]
		#  puts stdout "E Pass = $p"
		puts $server_socket "$username:$p"
		# puts $server_socket "$username:$passwd"
		flush $server_socket
	    }
	} else {
	    if { $l == "TRANSFER OK" } {
		set errno 0
		set stream_status 1
	    } else {
		if { [.shidden1 get ] == 1 } {
		    .sock.text insert end "$l\n"
		}
		lappend socket_data $l
		if { [lindex [split $l " " ] 0 ] == "ERROR:" } {
		    set errno 1
		    set stream_status 1
		    set errorm $l
		}
	    }
	}
    }
    flush $server_socket
    vwait stream_status
    if { $authenticated != 1 } {
	# Authentication failed
	close $server_socket
	after cancel ticker 0
	after cancel ticker 1
	. config -cursor top_left_arrow
	set server_socket {}
	puts stderr "The pass string for $hostname is invalid  auth=$authenticated  stream_stat=$stream_status"
	return ""
    }
    set stream_status 0
    puts $server_socket $command
    flush $server_socket
    vwait stream_status
    if { [string length $args ] == 0 } {
	close $server_socket
	after cancel ticker 0
	after cancel ticker 1
	. config -cursor top_left_arrow
#	puts stdout "No extended commands "
	set server_socket {}
	if { $visable == 1 } {
	    .sock.text see end
	} 
	if { $errno == 1 } {
	    actionItem . $errorm "Dismiss" red
	}
	return $socket_data
    } else {
#	puts stdout "Extended command issued....."
	if { [lindex $args 0 ] == "ext" } {
	    if { [lindex $args 1 ] == "put" } {
		set wtype [lindex $args 2 ]
		set widget [lindex $args 3 ]
		# What is the data source for the put command
		if { $wtype == "v" } {
		    # This is for Variables
		    global upgrade_buff                    # <------------ Needed for upgrade
		    for { set position 0 } { $position < [llength $upgrade_buff ] } { incr position 1 } {
			set data [lindex $upgrade_buff $position ]    
			# <------------  Needs upgrade_buff instead of $widget
#			puts $server_socket "MaT>[string trimright $data ]\n"
			puts $server_socket "MaT>$data" 
			puts ">$data"
			flush $server_socket
		    } 
		} elseif { $wtype == "l" } {
		    # This is for listboxes
		    for { set position 0 } { $position < [$widget index end ] } { incr position 1 } {
			eval "set data \"[$widget get $position ]\" "
			puts $server_socket "MaT>$data" 
			flush $server_socket
		    } 
		} elseif { $wtype == "f" } {
		    # Upload from a file
		    if { [file exists $widget ] } {
			# Got a file
			catch "open $widget r" rval
			if { [string range $rval 0 3 ] == "file" } {
			    while { [eof $rval ] != 1 } {
				gets $rval data
				puts $server_socket "MaT>$data"
				flush $server_socket
			    }
			    close $rval
			} else {
			    # Error
			}
		    } 
		} else {
		    # This is for text widgets
		    for { set position 1 } { $position < [$widget index end ] } { incr position 1 } {
			set data [$widget get $position.0 $position.end ]
			puts $server_socket "MaT>$data"
			flush $server_socket
		    } 
		}
		puts $server_socket "MaT_DoNe."
		flush $server_socket
		vwait stream_status
		close $server_socket
		set server_socket {}
		after cancel ticker 0
		after cancel ticker 1
		. config -cursor top_left_arrow
		if { $visable == 1 } {
		    .sock.text see end
		} 
		return $socket_data
	    }
	} else {
	    puts stdout "Unknown command sequence: [lindex $args 0 ] "
	    close $server_socket
	    set server_socket {}
	    after cancel ticker 0
	    after cancel ticker 1
	    . config -cursor top_left_arrow
	    if { $visable == 1 } {
		.sock.text see end
	    } 
	    return $socket_data
	}
    }
    # Should not get here, but just in case:
    after cancel 0
    after cancel 1
    close $server_socket
    set server_socket {}
}


#
# -- Procedure to Login --
#
# Passwd value is stored in passwd variable
# Login name is stored in user
# type - n=new, otherwise regular
proc getPasswd	{ currenthost type } {
    global passwd
    global new
    global username
    if { [winfo exists .getPass ] != 0 } {
	destroy .login
    }
    set new $type
    toplevel .login -class Dialog
    wm title .login "User Authentication"

    frame .login.f1 -relief raised -bd 2
    label .login.f1.l1 -text "Login" -justify center -width 12
    entry .login.f1.e1 -width 16 
    pack .login.f1.l1 .login.f1.e1 -side left
    pack .login.f1 -side top -fill both
    
    frame .login.f2 -relief raised -bd 2
    label .login.f2.l1 -text "Pass String" -justify center -width 12
    entry .login.f2.e1 -width 16 -show "*"
    pack .login.f2.l1 .login.f2.e1 -side left
    pack .login.f2 -side top -fill both
    
    frame .login.f3 -relief raised -bd 2
    label .login.f3.l1 -text "Enter the New Authentication String\nIt will NOT be displayed\nMinimum 10 characters" -justify center
    entry .login.f3.e1 -width 16 -show "*"
    label .login.f3.l2 -text "Enter the New String Again" -justify center
    entry .login.f3.e2 -width 16 -show "*"
    pack .login.f3.l1 .login.f3.e1 .login.f3.l2 .login.f3.e2 -side top

    button .login.b1 -text "Okay" -foreground #008000 -command "newPass $currenthost "
    button .login.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command "destroy .login"
    button .login.b3 -text "Change Password" -foreground red -activeforeground #800000 -command "pack forget .login.b1 ;pack forget .login.b2 ;pack forget .login.b3 ; pack .login.f3 -fill both -side top ;pack .login.b1 .login.b2 -side left ; set new n" 
    if { $type == "n" } {
	pack .login.f3 -fill both -side top 
	pack .login.b1 .login.b2 -side left
    } else {
	pack .login.b1 .login.b2 .login.b3 -side left
    }

    focus .login.f1.e1
    .login.f1.e1 delete 0 end
    .login.f1.e1 insert end $username
    .login.f2.e1 delete 0 end
    .login.f2.e1 insert end $passwd

    #-------------- Bindings -------------------
    bind .login.f1.e1 <Return> {
	focus .login.f2.e1
    }
    bind .login.f2.e1 <Return> {
	if { $new != "n" } {
	    .login.b1 invoke
	} else {
	    focus .login.f3.e1
	}
    }
    bind .login.f3.e1 <Return> {
	focus .login.f3.e2
    }
    bind .login.f3.e2 <Return> {
	.login.b1 invoke
    }
}

#
# --  Procedure to update Password 
#
# This procedure will update the password on all the machines in currenthost
# It can olny be called from getPasswd
proc newPass { currenthost } {
    global passwd
    global new
    global username
    global errno
    if { $new != "n" } {
	set username [.login.f1.e1 get]
	set passwd [.login.f2.e1 get]
	destroy .login
    } else {
	if { [.login.f3.e1 get] != [.login.f3.e2 get ] } {
	    .login.f3.e1 delete 0 end
	    .login.f3.e2 delete 0 end
	    error 220
	} else {
	    set cmdline "mod matpass [.login.f1.e1 get]:[.login.f3.e2 get]:"
	    set cmdresult [queryHost $currenthost $cmdline 1 ]
	    if { $errno != 0 } {
		error 221
	    } else {
		set passwd [.login.f3.e2 get]
		destroy .login
	    }
	} 
    }
}




#
# -- Procedure to read data from raw data and fill list window --
#
proc filllist { data window } {  
    $window delete 0 end
    for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	set tmp [lindex $data $position ]
	$window insert end "$tmp\n"
    }
}

#
# -- Procedure to read hostss from raw data and fill list box window --
#
proc fillhostlist { data window } {  
    $window delete 0 end
    for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	set tmp [lindex $data $position ]
	$window insert end $tmp
    }
}



#
# -- Procedure to Select and De-select lines of text
#
proc Selecter { window tag } {
    global SelectorLine
    set isSelect [ $window tag cget $tag -underline ]
    if { $isSelect == {} || $isSelect == 0 } {
	if { $SelectorLine != 9999 } {
	    # De-select other line first
	    $window tag configure l$SelectorLine -underline 0
	}
	set notIsSelect 1
	set SelectorLine [ string range $tag 1 end ]
    } else {
	set notIsSelect 0
	set SelectorLine 9999
    }
    $window tag configure $tag -underline $notIsSelect
}

#
# --------------- Procedure for Displaying Host Info -----------
#
# 
proc HostInfo { hostname data } {
    if { [winfo exists .hI ] != 1 } {
	toplevel .hI -class Dialog
	wm title .hI "Host Info for $hostname"
	wm iconname .hI "$hostname HostInfo"
	frame .hI.nameFrame -relief raised -bd 2 
	label .hI.nameLabel -text "Host Name" -width 13
	entry .hI.nameEntry -relief sunken -bd 2 -width 15 
	pack .hI.nameLabel .hI.nameEntry -in .hI.nameFrame -side left -expand 1 -fill both
	frame .hI.matFrame -relief raised -bd 2 
	label .hI.matLabel -text "MAT Version" -width 13
	entry .hI.matEntry -relief sunken -bd 2 -width 15 
	pack .hI.matLabel .hI.matEntry -in .hI.matFrame -side left -expand 1 -fill both
	frame .hI.osFrame -relief raised -bd 2
	label .hI.osLabel -text "OS Type" -width 13
	entry .hI.osEntry -relief sunken -bd 2 -width 15
	pack .hI.osLabel .hI.osEntry -in .hI.osFrame -side left -expand 1 -fill both
	frame .hI.verFrame -relief raised -bd 2
	label .hI.verLabel -text "Version" -width 13
	entry .hI.verEntry -relief sunken -bd 2 -width 15
	pack .hI.verLabel .hI.verEntry -in .hI.verFrame -side left -expand 1 -fill both
	frame .hI.archFrame -relief raised -bd 2
	label .hI.archLabel -text "Architecture" -width 13
	entry .hI.archEntry -relief sunken -bd 2 -width 15
	pack .hI.archLabel .hI.archEntry -in .hI.archFrame -side left -expand 1 -fill both
	frame .hI.upFrame -relief raised -bd 2
	label .hI.upLabel -text "Up Time" -width 13
	entry .hI.upEntry -relief sunken -bd 2 -width 15
	pack .hI.upLabel .hI.upEntry -in .hI.upFrame -side left -expand 1 -fill both
	frame .hI.ipFrame -relief raised -bd 2
	label .hI.ipLabel -text "IP Address" -width 13
	entry .hI.ipEntry -relief sunken -bd 2 -width 15
	pack .hI.ipLabel .hI.ipEntry -in .hI.ipFrame -side left -expand 1 -fill both
	frame .hI.memFrame -relief raised -bd 2
	label .hI.memLabel -text "RAM Size" -width 13
	entry .hI.memEntry -relief sunken -bd 2 -width 15
	pack .hI.memLabel .hI.memEntry -in .hI.memFrame -side left -expand 1 -fill both
	frame .hI.swapFrame -relief raised -bd 2
	label .hI.swapLabel -text "SWAP Size" -width 13
	entry .hI.swapEntry -relief sunken -bd 2 -width 15
	pack .hI.swapLabel .hI.swapEntry -in .hI.swapFrame -side left -expand 1 -fill both
	button .hI.done -text "Dismiss" -command { 
	    destroy .hI 
	} 
	pack .hI.nameFrame .hI.matFrame .hI.osFrame .hI.verFrame .hI.archFrame .hI.upFrame .hI.ipFrame .hI.memFrame .hI.swapFrame -fill both
	pack .hI.done
    } else {
	.hI.nameEntry delete 0 end
	.hI.matEntry delete 0 end
	.hI.osEntry delete 0 end 
	.hI.verEntry delete 0 end
	.hI.archEntry delete 0 end
	.hI.upEntry delete 0 end
	.hI.ipEntry delete 0 end
	.hI.memEntry delete 0 end
	.hI.swapEntry delete 0 end 
    }
    .hI.matEntry insert end [lindex [split [lindex $data 0 ] ": " ] 2 ]
    .hI.nameEntry insert end [lindex [split [lindex $data 1 ] ": " ] 2 ]
    .hI.osEntry insert end [lindex [split [lindex $data 2 ] ": " ] 2 ]
    .hI.verEntry insert end [lindex [split [lindex $data 3 ] ": " ] 2 ]
    .hI.archEntry insert end [lindex [split [lindex $data 4 ] ": " ] 2 ]
    .hI.upEntry insert end [lindex [split [lindex $data 5 ] " " ] 1 ]
    .hI.ipEntry insert end [lindex [split [lindex $data 6 ] ": " ] 2 ]
    .hI.memEntry insert end [lindex [split [lindex $data 7 ] ": " ] 2 ]
    .hI.swapEntry insert end [lindex [split [lindex $data 8 ] ": " ] 2 ]
}


proc about {} {
    if { [winfo exists .about ] != 0 } {
	destroy .about
    }
    toplevel .about -class Dialog
    wm title .about "License"
    wm iconname .about Dialog
    frame .about.t1 -relief raised -bd 2 
    text .about.t1.t -width 50 -height 12 
    pack .about.t1.t -fill both -expand 1
    .about.t1.t configure -font -*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-* -wrap word
    .about.t1.t tag configure norm -font -*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-* -justify center
    .about.t1.t tag configure big -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-*
    .about.t1.t tag configure red -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-* -foreground #f04040 -justify center
    .about.t1.t tag configure bigCenter -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-* -justify center
    .about.t1.t tag configure title -font -*-Helvetica-Bold-R-Normal--*-180-*-*-*-*-*-* -justify center

    .about.t1.t insert end "MAT\n" title
    .about.t1.t insert end "\n"
    .about.t1.t insert end "Monitoring and Administration Tool (MAT)\n" bigCenter
    .about.t1.t insert end "Version 0.21" bigCenter
    .about.t1.t insert end "\n" bigCenter
    .about.t1.t insert end "(c) 1997, 1998, 1999" bigCenter
    .about.t1.t insert end "\n"
    .about.t1.t insert end "Mark Black\n\n" bigCenter
    .about.t1.t insert end "http://www.ee.ryerson.ca/~sblack/mat\n" bigCenter
    .about.t1.t insert end "Email:  sblack@ee.ryerson.ca\n" bigCenter
    frame .about.f2 -relief raised -bd 2 
    button .about.f2.b2 -text "-- Close --" -command "destroy .about"
    pack .about.f2.b2 -side left -fill x 
    pack .about.t1 .about.f2 -side top -fill both
}

proc licen {} {
    if { [winfo exists .licen ] != 0 } {
	destroy .licen
    }
    toplevel .licen -class Dialog
    wm title .licen "License"
    wm iconname .licen Dialog
    frame .licen.t1 -relief raised -bd 2 
    text .licen.t1.t -width 50 -height 16 -yscrollcommand {.licen.t1.tscroll set }
    scrollbar .licen.t1.tscroll -orient vertical -command ".licen.t1.t yview"
    pack .licen.t1.tscroll -side left -fill y
    pack .licen.t1.t -fill both -expand 1
    .licen.t1.t configure -font -*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-* -wrap word
    .licen.t1.t tag configure courier -font -Adobe-Courier-Medium-R-Normal--*-120-*-*-*-*-*-* 
    .licen.t1.t tag configure big -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-*
    .licen.t1.t tag configure red -font -*-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-* -foreground #f02020
    .licen.t1.t tag configure blue -font -*-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-* -foreground #2020f0
    .licen.t1.t tag configure green -font -*-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-* -foreground #20a020
    .licen.t1.t tag configure bigCenter -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-* -justify center
    .licen.t1.t tag configure title -font -*-Helvetica-Bold-R-Normal--*-180-*-*-*-*-*-* -justify center

    .licen.t1.t insert end "MAT License Agreement\n" title
    .licen.t1.t insert end "\n"
    .licen.t1.t insert end "Monitoring and Administration Tool (MAT) is provided AS IS.  "
    .licen.t1.t insert end ", as such we make NO gaurentee as to the softwares fitness.\n\n"
    .licen.t1.t insert end "IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL"
    .licen.t1.t insert end " DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE "
    .licen.t1.t insert end "BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\n"
    .licen.t1.t insert end "\n\n"
    .licen.t1.t insert end "This software may be freely distributed provided it is complete, and unaltered.  This code cannot be modified for sale."
    .licen.t1.t insert end "\n\n"
    .licen.t1.t insert end "This software is provided AS-IS.  The authors have no obligation to provide support, maintenance, updates, enhancements, or"
    .licen.t1.t insert end "modifications.\n"
    .licen.t1.t insert end "\n"
    frame .licen.f2 -relief raised -bd 2 
    button .licen.f2.b1 -text "I accept the above agreement" -command {
	global mb_hosts
	set fid [ open $mb_hosts w ]
	close $fid
        help startup
	destroy .licen
    }
    button .licen.f2.b2 -text "I reject the above agreement" -command "destroy ."
    pack .licen.f2.b1 .licen.f2.b2 -side left -fill x 
    pack .licen.t1 .licen.f2 -side top -fill both
}


#
# actionItem - Display a message and prompt for user action 
#
# USE:  tapeConfirm calling_window Message Action_Button_list Message_color 
# Returns the index of the Action item
#
set done -1
proc actionItem { w mess actions color } {
    global done
    set mpos [winfo pointerxy $w ]
    # Cursor on window
    set n .tcon
    if ![winfo exists $n ] {
	toplevel $n
# Uncommenting this removes the window manager frame
#	wm override $n 1
	wm withdraw $n
	wm title $n "Notice!"
	frame $n.f1 -bd 2 -relief "raised"
	message $n.f1.m1 -width 3i -text $mess -font -Adobe-helvetica-*-R-*-14-*-* -foreground $color
	pack $n.f1.m1 -expand 1 -padx 3m -pady 3m
	frame $n.f2 -bd 2 -relief "flat"
	set cnt 0
	foreach act $actions {
	    button $n.f2.b$cnt -text $act -command "set done $cnt"
	    pack $n.f2.b$cnt -side left -fill x -expand 1
	    incr cnt 1
	}
	pack $n.f1 $n.f2 -side top -fill both 
    }
    update idle
    set x [expr [lindex $mpos 0 ] - 10 ]
    set y [expr [lindex $mpos 1 ] - 10 ]
    wm geometry $n +$x+$y
    wm deiconify $n
    raise $n
    vwait done
    destroy $n
    return $done
}


#
# A ticking cursor
#
proc ticker { in } {
    set c [ expr ($in + 1) & 1 ] 
    if { [expr $c & 1 ] } {
	. config -cursor cross
    } else {
	. config -cursor cross_reverse
    }
    after 500 ticker $c
}
