# Help.tcl
# Copyright (c) 1997, 1999 Mark Black
#
# By Mark Black

proc help { topic } {
    if { [winfo exists .help ] != 0 } {
	.help.t delete 0.0 end
    } else {
	toplevel .help -class Dialog
	wm title .help "Help"	
	wm iconname .help Dialog
	button .help.quit -text "-Close-" -command { destroy .help }
	pack .help.quit -fill x 
	text .help.t -width 70 -height 16 -yscrollcommand {.help.tscroll set }
	scrollbar .help.tscroll -orient vertical -command ".help.t yview"
	pack .help.tscroll -side left -fill y
	pack .help.t -fill both -expand 1
    }
    if {[winfo depth .help ] > 1} {
	set bold "-foreground #2020f0 " 
	set normal "-foreground #4040a0 "
    } else {
	set bold "-foreground white -background black"
	set normal "-foreground {} -background {}"
    }
    .help.t configure -font -*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-* -wrap word
    .help.t tag configure courier -font -Adobe-Courier-Medium-R-Normal--*-120-*-*-*-*-*-* 
    .help.t tag configure big -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-*
    .help.t tag configure red -font -*-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-* -foreground #f02020
    .help.t tag configure blue -font -*-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-* -foreground #2020f0
    .help.t tag configure green -font -*-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-* -foreground #20a020
    .help.t tag configure bigCenter -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-* -justify center
    .help.t tag configure title -font -*-Helvetica-Bold-R-Normal--*-180-*-*-*-*-*-* -justify center
    if { $topic == "help" } {
	.help.t insert end "MAT Help Index\n" title
	.help.t insert end "Use the mouse to select from the topics below.  Click on the topic of your choice.\n"
	.help.t insert end "  About MAT, Mark's Administration Tool.\n" t10
	.help.t insert end "  Startup     - How to initially add hosts\n" t15
	.help.t insert end "  Backups     - How to user the network backup\n" t130
	.help.t insert end "  Cron        - Add or modify Crontab entries.\n" t90
	.help.t insert end "  DNS client  - Configure DNS client.\n" t60
	.help.t insert end "  DNS master  - Configure a DNS server\n" t100
	.help.t insert end "  Groups      - Modify groups and group members.\n" t30
	.help.t insert end "  Hosts       - Adding, deleting and modifing host IP's.\n" t40
	.help.t insert end "  Login       - How to login to a MAT agent & change the MAT password.\n" t17
	.help.t insert end "  Mail Lists  - Create mailing lists, & redirect mail.\n" t70
	.help.t insert end "  MATD        - Monitor system parameters.\n" t140
	.help.t insert end "  Motd        - Create and edit the login message.\n" t80
	.help.t insert end "  Mounts      - Add or modify mounted filesystems.\n" t50
	.help.t insert end "  NFS         - Control a NFS server.\n" t120
	.help.t insert end "  NIS         - Maint a NIS servers databases\n" t110
	.help.t insert end "  Replicate   - Distribute files to many clients\n" t150
	.help.t insert end "  Users       - Adding, deleting or modifing user accounts.\n" t20

	foreach tag {t10 t15 t17 t20 t30 t40 t50 t60 t70 t80 t90 t100 t110 t120 t130 t140 t150} {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t10 <1> { help mat }
	.help.t tag bind t15 <1> { help startup }
	.help.t tag bind t17 <1> { help matpass }
	.help.t tag bind t20 <1> { help users }
	.help.t tag bind t30 <1> { help groups }
	.help.t tag bind t40 <1> { help hosts }
	.help.t tag bind t50 <1> { help files }
	.help.t tag bind t60 <1> { help dnsc }
	.help.t tag bind t70 <1> { help mail }
	.help.t tag bind t80 <1> { help motd }
	.help.t tag bind t90 <1> { help cronedit }
	.help.t tag bind t100 <1> { help dnsm }
	.help.t tag bind t110 <1> { help nism }
	.help.t tag bind t120 <1> { help nfs }
	.help.t tag bind t130 <1> { help tape }
	.help.t tag bind t140 <1> { help matd }
	.help.t tag bind t150 <1> { help replication }
    } elseif { $topic == "mat" } {
	.help.t insert end "MAT, Mark's Administration Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "Version 0.21\n" bigCenter
	.help.t insert end "By Mark Black  (sblack@ee.ryerson.ca)\n\n" bigCenter
	.help.t insert end "MAT is a networked UNIX administration and monitoring tool.\n" big
	.help.t insert end "It allows you as an administrator, or authorized individual, to change the UNIX configuration, "
	.help.t insert end "of your workstation or a remote machine.  Currently the tool will allow you to change the following files:\n"
	.help.t insert end "    passwd\n"
	.help.t insert end "    group\n"
	.help.t insert end "    hosts\n"
	.help.t insert end "    motd\n"
	.help.t insert end "    resolv.conf\n"
	.help.t insert end "    aliases\n"
	.help.t insert end "    fstab\n"
	.help.t insert end "    crontab\n"
	.help.t insert end "The management module runs on any operating system with Tcl/TK, and the TCP/IP protocol stack installed, "
	.help.t insert end "this includes Win95.  "
	.help.t insert end "Additional modules will be added in the future to support DNS, NIS, NFS, Archiving as well as other OS's.  "
	.help.t insert end "Solaris and SunOS will probably be the next supported OS's\n\n"
	.help.t insert end "Licensing & Warrenty\n" big

	.help.t insert end "Monitoring and Administration Tool (MAT) is is licensed in two ways:\n\n"
	.help.t insert end "1. For users on a single computer network, such as a home PC, MAT is provided free of charge.\n\n"
	.help.t insert end "2. For all others MAT is shareware.  You may evaluate it for a period of 30 days free of charge.  "
	.help.t insert end "If you continue to use MAT after the evaluation period the following fee structure applies:\n"
	.help.t insert end "      \$19.95 US per host\n"
	.help.t insert end "      \$99.95 US per NIS master\n"
	.help.t insert end "      \$99.95 US per DNS master\n"
	.help.t insert end "Pricing is subject to change without notice.  Email sblack@ee.ryerson.ca for more details.\n\n"
	.help.t insert end "Monitoring and Administration Tool (MAT) is provided AS IS.  Use it at your own risk.  "
	.help.t insert end "We make NO gaurentee as to the "
	.help.t insert end "softwares fitness for the intended task.  This software is provided free of charge, as such we accept NO liability for lost "
	.help.t insert end "data, time, or any other type of loss.  You by accepting or running part or all of the MAT software programs accept all "
	.help.t insert end "responsibility for any consiquences of it's use."
	.help.t insert end "\n\n"
	.help.t insert end "This software may be freely distributed provided it is complete, and unaltered.  This code cannot be modified for sale "
	.help.t insert end "without consideration (\$)."
	.help.t insert end "\n\n"
	.help.t insert end "Security updates, and gereral patches, may be provided as the MAT source code "
	.help.t insert end "matures.  Their installation or use is subject to this license agreement."

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "users" } {
	.help.t insert end "User Administration Tool\n" title
	.help.t insert end "<-- Back\n" t10
	.help.t insert end "The Used Administration Tool is used to add, or modify users.  It is designed to provide a simple tool for non-UNIX "
	.help.t insert end "guru to use.  Deleting users is done from the first GUI.  "
	.help.t insert end "The tool can modify any parameter associated with "
	.help.t insert end "a user in the password file.  This section will deal with all of the functions provided by the tool, such as:\n"
	.help.t insert end "  Adding a new user\n" t20
	.help.t insert end "  Modifing a users login\n" t30
	.help.t insert end "  Modifing a users primary group\n" t40
	.help.t insert end "  Modifing a users descriptor (comment)\n" t50
	.help.t insert end "  Changing a users password\n" t60
	.help.t insert end "  Moving a user to a new directory\n" t70
	.help.t insert end "  Changing a users ID number\n" t80
	.help.t insert end "  Changing a users shell\n" t90
	.help.t insert end "\n"
	set pos1 [ .help.t index end ]
	.help.t insert end "Adding a new user\n" bigCenter
	.help.t insert end "The tool is designed to be as simple as possible, as such it makes some simple decisions about "
	.help.t insert end "a users default information.  The tool will create the user with a predetermined "
	.help.t insert end "password, shell, home directory, unless an alternate selection is provided.  The users ID number will be selected "
	.help.t insert end "as the next available number above 1000, unless one is provided.\n\n"
	.help.t insert end "To add a new user go to the "
	.help.t insert end "User Editor.\n" big
	.help.t insert end "This can be reached by first selecting: Users from the Browse menu, or by pressing the Users button.  " 
	.help.t insert end "Double-click the host you want to add the user to.  The default is localhost, that is, this machine.  A "
	.help.t insert end "list of all the users currently on the machine will be displayed.  Press the "
	.help.t insert end "New " green
	.help.t insert end "button.\n  Once in the User Editor you need to provide some basic information about the "
	.help.t insert end "user you are about to add, such as First Name, and Surname.  The Enter, or Return key can be used to "
	.help.t insert end "move down the netry boxes.  The First Name, and Surname fields are combined to form the comment in the "
	.help.t insert end "password file.  Pressing Return in the Surname field will move you to the Login field, were a default "
	.help.t insert end "login has been made from the first letter of the users name, followed by up to 7 characters from the "
	.help.t insert end "users surname.  If the default login is unacceptable it can be edited.\n"
	.help.t insert end "The users primary group has to be selected from the list provided.  User scrollbar to see the rest "
	.help.t insert end "of the groups.  Select the primary group of the new user by clicking on the group.\n"
	.help.t insert end "By default the tool will assume the following:\n"
	.help.t insert end "    Initial password is:  Password\n"
	.help.t insert end "    Initial shell is:  /bin/sh\n "
	.help.t insert end "    Home directory is:  /home/{Users Login}\n"
	.help.t insert end "    User ID number is:  next free UID > 1000\n"
	.help.t insert end "Pressing the Options button opens a window were the above options can be changed.  If the options are "
	.help.t insert end "changed press "
	.help.t insert end "OK " red
	.help.t insert end "to apply the changes to the default options.\n"
	.help.t insert end "Once the data has been entered, and any options changed applied, the user can be created.  Pressing the "
	.help.t insert end "Apply " red
	.help.t insert end "button will attempt to add the user.  To cancel adding a user press the "
	.help.t insert end "Cancel " blue
	.help.t insert end "button.  Once the "
	.help.t insert end "Apply " red
	.help.t insert end "button is pressed, the Command Output window will appear.  The Command Output displays the status of the "
	.help.t insert end "command e.g:\n\n"
	.help.t insert end "MAT agent started on localhost\n" courier
	.help.t insert end "Authentication Passed\n" courier
	.help.t insert end "Attempting to add: John Smith,  Login: jsmith,  Home: /home/jsmith  UID=  Shell: /bin/sh\n" courier
	.help.t insert end "Using 1011 for the users id\n" courier
	.help.t insert end "Adding User: John Smith,  Login: jsmith,  Home: /home/jsmith  UID=1011  Shell: /bin/sh\n" courier
	.help.t insert end "\n"
	.help.t insert end "MAT will create the directory with the appropriate group and ownership.\n"
	.help.t insert end "Default configuration files will be copied from the MATdefaults directory to the new users directory.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos2 [ .help.t index end ]
	.help.t insert end "Modifying a Users Login\n" bigCenter
	.help.t insert end "To modify a user you must first select Users from the Browse menu, or press the Users button.  Then "
	.help.t insert end "Double-click on the host where you want to modify the user.  The default is localhost, that is, this machine. "
	.help.t insert end "A list of all the users will be displayed.  Double-click on the user you wish to modify, or select the users name "
	.help.t insert end "and press the Modify Selected button.  The User Editor will appear.  Type in the new login name and press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos3 [ .help.t index end ]
	.help.t insert end "Modifying a Users Primary Group\n" bigCenter
	.help.t insert end "To modify a user you must first select Users from the Browse menu, or press the Users button.  Then "
	.help.t insert end "Double-click on the host where you want to modify the user.  The default is localhost, that is, this machine. "
	.help.t insert end "A list of all the users will be displayed.  Double-click on the user you wish to modify, or select the users name "
	.help.t insert end "and press the Modify Selected button.  The User Editor will appear.  Select the new primary group form the list.\n"
	.help.t insert end "NOTE:" big
	.help.t insert end "Only groups from the /etc/group file will be displayed.  NIS groups are not yet implimented.\n"
	.help.t insert end "After selecting the new group press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos4 [ .help.t index end ]
	.help.t insert end "Modifying a Users Descriptor\n" bigCenter
	.help.t insert end "To modify a user you must first select Users from the Browse menu, or press the Users button.  Then "
	.help.t insert end "Double-click on the host where you want to modify the user.  The default is localhost, that is, this machine. "
	.help.t insert end "A list of all the users will be displayed.  Double-click on the user you wish to modify, or select the users name "
	.help.t insert end "and press the Modify Selected button.  The User Editor will appear.\n"
	.help.t insert end "NOTE:" big
	.help.t insert end "The users descriptor (comment) is made by appending the Surname entry to the Firstname entry\n"
	.help.t insert end "To change the descriptor type in a new Firstname, and Surname.  Other information can be included in the comment, "
	.help.t insert end "such as phone number, or location.  This can be done by placing the full name in the Firstname entry field, and "
	.help.t insert end "using the Surname field for any other information.\n"
	.help.t insert end "After entering the new information press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos5 [ .help.t index end ]
	.help.t insert end "Changing a Users Password\n" bigCenter
	.help.t insert end "To change a users password you have to go to the options window, by pressing the "
	.help.t insert end "Options " green
	.help.t insert end "button from the User Editor.  To open the User Editor Double-click on the host where you want to modify the user.  "
	.help.t insert end "Then Double-click on the user who's password you want to change.  From the Options window type in the new password "
	.help.t insert end "in the Password field.  Press Return, or Enter to move the the Confirm field.  Type in the new password again in the "
	.help.t insert end "Confirm field.  Press the "
	.help.t insert end "OK " red
	.help.t insert end "button, and then press the "
	.help.t insert end "Apply " red
	.help.t insert end "button to update the password.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos6 [ .help.t index end ]
	.help.t insert end "Changing a Users Home Directory\n" bigCenter
	.help.t insert end "To change a users Home Directory you have to go to the options window, by pressing the "
	.help.t insert end "Options " green
	.help.t insert end "button from the User Editor.  To open the User Editor Double-click on the host where you want to modify the user.  "
	.help.t insert end "Then Double-click on the user who's home location you want to change.  From the Options window click on the Home Dir, "
	.help.t insert end "and type in the new home directory location.  Press the "
	.help.t insert end "OK " red
	.help.t insert end "button, and then press the "
	.help.t insert end "Apply " red
	.help.t insert end "button to update the users home directory.  If possible all files in the users old home directory will be moved to "
	.help.t insert end "the new home directory. \n"
	.help.t insert end "NOTE: " big
	.help.t insert end "This operation can take several minutes to complete!  Ownership and groups of the files in the users directory is "
	.help.t insert end "preserved.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos7 [ .help.t index end ]
	.help.t insert end "Changing a Users ID Number (UID)\n" bigCenter
	.help.t insert end "To change a users ID Number you have to go to the options window, by pressing the "
	.help.t insert end "Options " green
	.help.t insert end "button from the User Editor.  To open the User Editor Double-click on the host where you want to modify the user.  "
	.help.t insert end "Then Double-click on the user who's UID you want to change.  From the Options window click on Select in the UID options.  "
	.help.t insert end "Type in the new UID in the entry field beside the Select button. Press the "
	.help.t insert end "OK " red
	.help.t insert end "button, and then press the "
	.help.t insert end "Apply " red
	.help.t insert end "button to update the UID.  If possible all files in the users home directory will be updated to the new UID.  "
	.help.t insert end "This functionallity is supplied for completeness.  Under most cases it should never be needed.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos8 [ .help.t index end ]
	.help.t insert end "Changing a Users Shell\n" bigCenter
	.help.t insert end "To change a users Shell you have to go to the options window, by pressing the "
	.help.t insert end "Options " green
	.help.t insert end "button from the User Editor.  To open the User Editor Double-click on the host where you want to modify the user.  "
	.help.t insert end "Then Double-click on the user who's shell you want to change.  From the Options window click on the desired shell in "
	.help.t insert end "the Shell frame.   Press the "
	.help.t insert end "OK " red
	.help.t insert end "button, and then press the "
	.help.t insert end "Apply " red
	.help.t insert end "button to update the users shell.\n"
	.help.t insert end "NOTE: " big
	.help.t insert end "Only the shells listed in the /etc/shells file on the host will be displayed.  If you are using other shells you will "
	.help.t insert end "need to update this file (/etc/shells).\n"
	.help.t insert end "<--Top\n" toTop

	foreach tag {toTop t10 t20 t30 t40 t50 t60 t70 t80 t90 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind toTop <1> ".help.t see 0.0 "
	.help.t tag bind t10 <1> { help help }
	.help.t tag bind t20 <1> ".help.t see $pos1 "
	.help.t tag bind t30 <1> ".help.t see $pos2 "
	.help.t tag bind t40 <1> ".help.t see $pos3 "
	.help.t tag bind t50 <1> ".help.t see $pos4 "
	.help.t tag bind t60 <1> ".help.t see $pos5 "
	.help.t tag bind t70 <1> ".help.t see $pos6 "
	.help.t tag bind t80 <1> ".help.t see $pos7 "
	.help.t tag bind t90 <1> ".help.t see $pos8 "
    } elseif { $topic == "groups" } {
	.help.t insert end "Groups Administration Tool\n" title
	.help.t insert end "<-- Back\n" t10
	.help.t insert end "The group administration tool allows you to add, or modify groups.  It provides an easy to use interface for "
	.help.t insert end "editing group membership.  This section will cover:\n"
	.help.t insert end "    What are groups for.\n" t20
	.help.t insert end "    Adding a new group.\n" t30
	.help.t insert end "    Changing group members.\n" t40
	.help.t insert end "    Changing group name, or ID.\n" t50
	.help.t insert end "    Deleting groups.\n" t60
	.help.t insert end "\n"
	set pos1 [ .help.t index end ]
	.help.t insert end "What are groups for?\n" bigCenter
	.help.t insert end "Groups provide a means of controlling access to sensitive areas of your computing environment.  Consider the "
	.help.t insert end "following example.  Widgets Inc have a Development and Administration section which both share the same server.  " 
	.help.t insert end "The primary group for everyone is widget.  A users primary group is controlled from the User Editor.  The Development "
	.help.t insert end "department has some sensitive information, which everyone in development needa access too, but which is too "
	.help.t insert end "dangerous for the Administration department.  To protect the data you can make a secondary group called devel, in "
	.help.t insert end "which you would include all those from the development department.  Any sensitive files or directories should have "
	.help.t insert end "group permission bits set to allow only those in the correct group access.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos2 [ .help.t index end ]
	.help.t insert end "Adding a new group.\n" bigCenter
	.help.t insert end "Adding a new group is a simple procedure.  The tool is designed to be as simple as possible.  To add a new group go to the "
	.help.t insert end "Group Editor.\n" big
	.help.t insert end "This can be reached by first selecting: Groups from the Browse menu, or by Double-clicking on the Groups icon.  " 
	.help.t insert end "Double-click the host you want to add the group to to see the Groups icon.  Press the "
	.help.t insert end "New " green
	.help.t insert end "button.\n  Once in the Group Editor you need to provide some basic information about the group.\n"
	.help.t insert end "In the Group entry box type the name of the group you want to create.  The group name should not exist on the system "
	.help.t insert end "already.  The group name should be kept short, no more than 8 characters.\n"
	.help.t insert end "In the GID# box type in the group identification number.  This is a unique number from 100 to 65535.  Numbers below "
	.help.t insert end "100 are possible, but NOT recommended for new groups, because the system uses some of these.  For this field just pick "
	.help.t insert end "any unused GID number.  The main GUI lists all of the GID's currently in use\n"
	.help.t insert end "If there are any users to add to the new group, type in the users login name in the Add box, and press the Add button.  "
	.help.t insert end "To create the new group press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.  The command output window will display the results of the operation e.g. \n"
	.help.t insert end "MAT agent started on darkstar\n" courier
	.help.t insert end "Authentication Passed\n" courier
	.help.t insert end "File updated\n" courier
	.help.t insert end "The new group is now added.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos3 [ .help.t index end ]
	.help.t insert end "Changing Group Members\n" bigCenter
	.help.t insert end "Changing group members is done from within the Group Editor for secondary groups, and from within the User Editor for " 
	.help.t insert end "primary groups. "
	.help.t insert end "To modify secondary group members you must first select Groups from the Browse menu, or press the Groups button.  Then "
	.help.t insert end "Double-click on the host where you want to modify the group.  The default is localhost, that is, this machine. "
	.help.t insert end "A list of all the groups will be displayed.  Double-click on the group you wish to modify, or select the group "
	.help.t insert end "and press the Modify Selected button.  The Group Editor will appear.  \nTo add a new group member type in the users "
	.help.t insert end "login name in the Add box, and press the Add button.  \nTo delete a user from a group follow the above procedure, but "
	.help.t insert end "this time select the users login from the member list and press the "
	.help.t insert end "Delete " red
	.help.t insert end "button.\n  To apply the change to the group list press"
	.help.t insert end "Apply " red
	.help.t insert end "button, or to abort the changes press the "
	.help.t insert end "Cancel " blue
	.help.t insert end "button.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos4 [ .help.t index end ]
	.help.t insert end "Changing a Group Name or ID number\n" bigCenter
	.help.t insert end "Changing a group is done from within the Group Editor.  " 
	.help.t insert end "To modify a group you must first select Groups from the Browse menu, or Double-click the Groups icon.  To see the "
	.help.t insert end "Groups icon Double-click on the host where you want to modify the group.  The default is localhost, that is, this machine.\n"
	.help.t insert end "A list of all the groups will be displayed.  Double-click on the group you wish to modify, or select the group "
	.help.t insert end "and press the Modify Selected button.  The Group Editor will appear.  " 
	.help.t insert end "If you want to change the group name type in the new name in the Group box, and then press the "
	.help.t insert end "Apply " red
	.help.t insert end "button. \n"
	.help.t insert end "NOTE: " big
	.help.t insert end "Changing the group identification number (GID) is NOT recommended ever!  However it can be done by tyyping in the "
	.help.t insert end "new GID number and pressing the "
	.help.t insert end "Apply " red
	.help.t insert end "button.  All files and directorys using this GID will be affected.  The group for the files and directories will "
	.help.t insert end "no longer be recognized.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos5 [ .help.t index end ]
	.help.t insert end "Deleting Groups\n" bigCenter
	.help.t insert end "Deleting groups is done from the main GUI.  "
	.help.t insert end "To delete a you must first select Groups from the Browse menu, or Double-click the Groups icon.  The "
	.help.t insert end "Groups icon is visable after Double-click on the host where you want to delete the group."
	.help.t insert end "A list of all the groups will be displayed.  Select the group "
	.help.t insert end "and press the Delete Selected button.  The group will then be deleted.  Use with care!\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop

	foreach tag {toTop t10 t20 t30 t40 t50 t60 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind toTop <1> ".help.t see 0.0 "
	.help.t tag bind t10 <1> { help help }
	.help.t tag bind t20 <1> ".help.t see $pos1 "
	.help.t tag bind t30 <1> ".help.t see $pos2 "
	.help.t tag bind t40 <1> ".help.t see $pos3 "
	.help.t tag bind t50 <1> ".help.t see $pos4 "
	.help.t tag bind t60 <1> ".help.t see $pos5 "
    } elseif { $topic == "hosts" } {
	.help.t insert end "Host Administration Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "A host is any PC, workstation, or device on your TCP/IP network.  Each host one the network must have a unique "
	.help.t insert end "Internet Protocol (IP) address."
	.help.t insert end "This window is for adding/modifing entries in the /etc/hosts file.  This file is consulted when no name service is running.\n\n"
	.help.t insert end "NOTE:  Do NOT use an arbitary IP address.  If you are connected to the Internet you will conflict with Internet IP addresses."
	.help.t insert end "  Several IP address ranges have reserved for private networks, such as 192.168.1.0 to 192.168.1.255.  If you have not been"
	.help.t insert end " assigned an IP address, use one of these.\n\n"
	.help.t insert end "At a minimum you need to provide two pieces of information:  The IP address of the host, and the name of the host. \n\n"
	.help.t insert end "IP Address:\n" big
	.help.t insert end "           The IP address of a host.  The IP address\n"
	.help.t insert end "           is the numeric address of the machine, \n"
	.help.t insert end "           expressed as four dot seperated numbers,\n"
	.help.t insert end "           ranging from 0 to 255 e.g.  123.45.67.89\n"
	.help.t insert end "           Use IP addresses that are valid for your\n"
	.help.t insert end "           network.\n\n"
	.help.t insert end "Host Name:" big
	.help.t insert end "
            The name of the host associated 
            with the IP address.\n\n"
	.help.t insert end "Alias(es):" big
	.help.t insert end "
            Any other names the host may be 
            known as, e.g.  www, or ftp.\n\n"
	.help.t insert end "Adding a new host.\n" bigCenter
	.help.t insert end "Under most conditions it is not necessary to add new hosts to a hosts file.  They are only needed when no "
	.help.t insert end "name service, such as DNS, or NIS(+), is running."
	.help.t insert end "Adding a new host is a simple procedure.  To add a new host go to the "
	.help.t insert end "Host Editor.\n" big
	.help.t insert end "This can be reached by first selecting: Hosts from the Browse menu, or by Double-clicking on the Hosts icon.  " 
	.help.t insert end "Double-click the host you want to add the host to to see the Hosts icon.  Press the "
	.help.t insert end "New " green
	.help.t insert end "button.\nOnce in the Hosts Editor you need to provide some basic information about the host.  "
	.help.t insert end "Type in the IP address of the host in the address field.  Typing the \".\" will move cursor to the next field.  "
	.help.t insert end "Type in the name of the host in the name field.  If the machine has any other names, such as a WWW or FTP server, "
	.help.t insert end "type them in the Alias(es) field.  Press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.  The command result window will display the result of the command.\n\n"
	.help.t insert end "Changing a Host name, alias, or IP\n" bigCenter
	.help.t insert end "Changing a host is done from within the Host Editor.  " 
	.help.t insert end "To modify a host you must first select Hosts from the Browse menu, or Double-click the Hosts icon.  To see the "
	.help.t insert end "Hosts icon Double-click on the host where you want to modify the host.  The default is localhost, that is, this machine."
	.help.t insert end "A list of all the hosts will be displayed.  Double-click on the host you wish to modify, or select the host "
	.help.t insert end "and press the Modify Selected button.  The Host Editor will appear.  " 
	.help.t insert end "Edit the field you want to change, and then press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.  The command result window will display the result of the command.\n\n"
	.help.t insert end "Deleting Hosts\n" bigCenter
	.help.t insert end "Deleting hostss is done from the main GUI.  "
	.help.t insert end "To delete a you must first select Hosts from the Browse menu, or Double-click the Hosts icon.  The "
	.help.t insert end "Hosts icon is visable after Double-click on the host where you want to delete the host."
	.help.t insert end "A list of all the hosts will be displayed.  Select the host "
	.help.t insert end "and press the Delete Selected button.  The host's entry will then be deleted.  Use with care!\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	foreach tag {toTop t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind toTop <1> ".help.t see 0.0 "
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "mail" } {
	.help.t insert end "Email Administration Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "The email tool is used to create mailing lists, and to redirect email.  Mailing lists are handy for sending email "
	.help.t insert end "to groups within your organization, for example to might create a mail list for all those in the Admin department, "
	.help.t insert end "called 'admin'.  Sending an email to 'admin' would send the email to all those in the 'admin' mailing list.  "
	.help.t insert end "The tool also allows you to redirect email to one or more other recipients.  This is useful for short mailing lists, "
	.help.t insert end "or to send the email to another location.  This can also be used to give a person the appearence of multiple email "
	.help.t insert end "names, for example the user John Smith, might have a login of 'john', yet receive email addressed to 'jsmith', or "
	.help.t insert end "'john.smith'.  By default every users login is their email name, this can be used to change it, or even stop the user "
	.help.t insert end "from receiving email.\n\n"
	.help.t insert end "Mail Alias: " big
	.help.t insert end "This is the name of the email list, or the email address to redirect from.  Users will send email to this name.  Type "
	.help.t insert end "in the name for the mail alias.\n\n"
	.help.t insert end "Alias Type: " big
	.help.t insert end "Select the type of email alias you wish to create.  List, is used to create a mailing list.  Redirect, is used to "
	.help.t insert end "send the email to another email address(s).  Once you select the alias type the window will change accordingly. \n\n"
	.help.t insert end "For redirected emial you will be asked for:\n"
	.help.t insert end "Email address to redirect to: " big
	.help.t insert end "This is one or more, comma seperated, email addresses.  It can contain external emails, of the form name@location, or "
	.help.t insert end "internal email addresses of the form 'login_name', or even the names of mailing lists.\n\n"
	.help.t insert end "For email lists you will be asked for:\n"
	.help.t insert end "List File: " big
	.help.t insert end "This is the name of the file containing the mailing list.\n\n"
	.help.t insert end "To add entries to the list type the email address in the entry box and press the "
 	.help.t insert end "Add " big
	.help.t insert end "button.  To remove an entry from the list use the scrollbar to scroll to the desired entry, and right click on the "
	.help.t insert end "entry and press the "
	.help.t insert end "Delete " red
	.help.t insert end "button.\n"
	.help.t insert end "After all the changes have been applied press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.  This will update the mail aliases, and if necessary write the mailing list.\n"
	.help.t insert end "\n"

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "files" } {
	.help.t insert end "Filesystem Administration Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "This window is for adding/modifing mounted 
filesystems.  A variety of filesystems are 
supported.  You must provide the following 
information:\n
Type:         Click the button corresponding to the 
              type of filesystem you wish to mount.
              Note:  The kernel MUST be compiled to 
              support the type of filesystem you
              want to mount.\n
Device:       This is the name of the local device
              which contains the filesystem you 
              want to mount.\n
NFS Server:   The name, or IP, of the NFS server.\n
Remote Filesystem:  The name of the filesystem 
              exported (shared) from the server.\n
Mount Point:  The location on the machine to 
              mount (graft) the filesystem to.  
              Mount points are directories.  If 
              the directory does not exist it 
              will be created.\n
Type:         Only NFS filesystems are supported
              in this version.\n
Options:      These are the mounting options.  
              See the man pages for details."

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "dnsc" } {
	.help.t insert end "DNS Client Administration Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "All machines on the Internet rely on the Domain Name Service (DNS) to provide hostname to IP address mappings.  "
	.help.t insert end "DNS is a database of the hosts on the Internet, which is distributed accross thousands DNS servers.  To use DNS "
	.help.t insert end "a machine must be told about the DNS domain it is part off.  It must be told the address of at least one DNS server, "
	.help.t insert end "and the domain to which it belongs.\n\n"
	.help.t insert end "In the domain field type the name of the domain to which the host belongs e.g.  stimpy.org\n\n"
	.help.t insert end "In the DNS servers field type the IP number of your DNS server, and press the "
	.help.t insert end "Add" big
	.help.t insert end " button.\n\n"
	
	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "cronedit" } {
	.help.t insert end "Crontab Editing Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "Cron allows you to run programs at scheduled times.  Cron is useful for routine administrative tasks, such as backups.  "
	.help.t insert end "This tool allows you to easily modify and add cron jobs.   There are two basic requirements for a cron job namely the "
	.help.t insert end "job, script, or program to run, and a schedule for running it.\n\n"
	.help.t insert end "In the Process: field type the name of the program, or script, you would like to run.  Remember to put in any redirects "
	.help.t insert end "if you need them e.g.  To not see stderr add 2>/dev/null to the end of the process field.  Any jobs which produce an "
	.help.t insert end "output to stdout, or stderr will produce an email message for root, so it is sometimes desirable to redirect stdout with "
	.help.t insert end "1>/dev/null.\n\n"
	.help.t insert end "You can place an optional comment in the Comment field.  \n\n" 
	.help.t insert end "The minute, and hour fields control the time of day to run the process.  The process may be run several times during the day.  "
	.help.t insert end "For example setting the minutes to 30, and the hours to 8,20 will cause the process to be run at 8:30am, and 8:30pm.  "
	.help.t insert end "Likewise setting setting the minutes 15,45, and the hours to Any will cause the process to be run 48 times a day at "
	.help.t insert end "15 and 45 minutes past each hour.  \nClicking on the "
	.help.t insert end "Minutes: " big
	.help.t insert end "button provides a list of choices, or you can enter the minutes in the entry box at the side, in a comma seperated list.  \n"
	.help.t insert end "Clicking on the "
	.help.t insert end "Hours: " big
	.help.t insert end "button provides a list of all the hour choices, or you can enter the hours in the entry box at the side, in a comma "
	.help.t insert end "seperated list.  Selecting Any will cause the process to run on the selected day every hour when the minutes match the " 
	.help.t insert end "current time minutes.  \n"
	.help.t insert end "The next three buttons are for selecting the day to run the process.  The process will run when the Week day is satisfied, OR " 
	.help.t insert end "the combination of Month Day, and Month.  For example selecting Monday for the Week Day, and 15 for the Month Day, and Any "
	.help.t insert end "Month, would allow the process to run every Monday, and every 15th of the month.\n\n"
	.help.t insert end "After providing the information press the "
	.help.t insert end "Apply" red
	.help.t insert end " button.  The information is transfered to the host, and the process will run at the scheduled time."
	
	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "matpass" } {
	.help.t insert end "MAT Login and Passwords\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "MAT has it's own password for each of the MAT users.  They are host specific. "
	.help.t insert end " The login name is like a UNIX login.  It can be made from the characters: "
	.help.t insert end "0-9, a-z, and A-Z, with no spaces.  The password can be up to 16 characters "
	.help.t insert end "long.  Keep it secure!\n"
	.help.t insert end "The passwords are stored in   \$MATHOME/etc/MATpass.  Copying this file "
	.help.t insert end "to all the hosts with MAT installed will add those MAT users you have "
	.help.t insert end "created to that host.  The replication tool is ideal for doing this.\n"
	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "mathost" } {
	.help.t insert end "MAT Hosts and Boxes\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "The MAT console, the tool you are using now, needs to know all the hosts "
	.help.t insert end "where the MAT agent and MAT daemon are installed.  The MAT Host Editor is "
	.help.t insert end "for managing the lists of hosts managed by this console.  The GUI is also "
	.help.t insert end "used for creating \"Boxes\".  A Box is simply a collection of hosts.  They "
	.help.t insert end "can reflect the logical, physical, or organizational arrangement of hosts.  "
	.help.t insert end "When a new Host or Box is added it will be added to the current box.  "
	.help.t insert end "The minimum requirements for the GUI are the name and type.  These can be "
	.help.t insert end "found under the General tab.\n\n"
	.help.t insert end "Name:  " big
	.help.t insert end "This is the name of the machine, or the box.  Un-qualified host names must "
	.help.t insert end "resolve to an IP address correctly, i.e. if you can't ping with that host "
	.help.t insert end "name don't use it.  The Box name cannot contain : .  Any spaces in the " 
	.help.t insert end "box name will be converted to _ automatically.\n\n"
	.help.t insert end "Type:  " big
	.help.t insert end "This identifies the icon as either a host or a box.  Select Host if it is "
	.help.t insert end "a machine.  Select Box if it is to be a host grouping.  After creating "
	.help.t insert end "a Host or Box do NOT change it's type.\n\n"
	.help.t insert end "The view under the Properties tab changes according to the type.  Hosts "
	.help.t insert end "will have a list of services, and optional parameters.  A Box will only "
	.help.t insert end "have optional parameters.\n\n"
	.help.t insert end "For a Host select all the services it provides.  See the release notes "
	.help.t insert end "for migration information for DNS and NIS masters.\n\n"
	.help.t insert end "The Optional entries are not required as they will be generated "
	.help.t insert end "automatically.  It's use is to move hosts to different Boxes.  "
	.help.t insert end "An existing host can be moved to another box by giving it's id.  "
	.help.t insert end "The base id is \"0\".  Find the ID of the container you want to move a "
	.help.t insert end "host to by looking at the box id of an existing host in the box and using "
	.help.t insert end "that.\n\n"
	.help.t insert end "NOTE: DO NOT DELETE BOXES\n" big
	.help.t insert end "If you do this all the hosts in the box will disappear.\n"
	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "dnsm" } {
	.help.t insert end "DNS Master Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "Domain Name Service (DNS) is a name resolution service.  It's function is to convert between "
	.help.t insert end "IP numbers and host names.  IP numbers are difficult for most people to remember, whereas host names "
	.help.t insert end "are much easire to remember.  In simple terms DNS is the Internets phonebook.  Given a name it "
	.help.t insert end "return the IP number, or given an IP it can return the name.\n"
	.help.t insert end "DNS is a distributed database.  The MAT DNS tool allows you to manage a portion of this database "
	.help.t insert end "known as a domain.  With the tool you will be able to create and manage domains.  "
	.help.t insert end "The tool greatly simplifies the setup of a DNS server, and management DNS host records.  "
	.help.t insert end "The following topics are covered in this section:\n\n"
	.help.t insert end "Look for updated help in the next revision."

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "dnssoa" } {
	.help.t insert end "DNS Domain Editor\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "The DNS Domain Editor is used to modify the properties of the DNS server.  With it you can easily "
	.help.t insert end "change the networks comprising a domain, primary DNS server, contact information, and the cache "
	.help.t insert end "parameters.\n\n"
	.help.t insert end "Domain Name:\n" big
	.help.t insert end "The name of the domain you are creating, or editing.  NOTE: It is not advisable to change the name "
	.help.t insert end "of an existing domain.\n\n"
	.help.t insert end "Network Addresses Comprising Domain:\n"
	.help.t insert end "These are the IP addresses of the networks which form the DNS domain.  A class C network will end in "
	.help.t insert end "0, while a class B will end in 0.0.  Non-byte oriented network boundries are untested.\n\n"
	.help.t insert end "Primary Server Name:\n" big
	.help.t insert end "This is the fully qualified name of the DNS server host.  If the domain name is not added in this "  
	.help.t insert end "field pressing enter in this field will fill it in.\n\n"
	.help.t insert end "Primary Server IP:\n" big
	.help.t insert end "This is the IP address of the primary DNS server.  It should be a part of the networks comprising "
	.help.t insert end "the domain. "

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "dnsh" } {
	.help.t insert end "DNS Host Editor Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "The DNS host editot tool is used to input and modify the DNS records for a specific host.  Data entered "
	.help.t insert end "here will be available to other hosts through DNS lookups.  After making any changes to the data "
	.help.t insert end "remember to restart the deamon. \n\n"
	.help.t insert end "Unqualified Host Name:\n" big
	.help.t insert end "The unqualified host name is simply the name of the host without the domain name being present.  "
	.help.t insert end "For the host \"buggs.your.net\" you would simply enter \"buggs\". \n\n"
	.help.t insert end "Host IP:\n" big
	.help.t insert end "This is the IP address of the host.  The address must be part of the IP address range assigned to "
	.help.t insert end "the domain.  Currently MAT only supports one IP address per host.  \n\n" 
	.help.t insert end "Other names for this host\n" big
	.help.t insert end "These are aliases for the host.  It corresponds to a DNS CNAME entry.  This is usefull for servers "
	.help.t insert end "such as \"www\", \"ftp\" or \"mailhost\".\n\n"
	.help.t insert end "Mail Hubs:\n" big
	.help.t insert end "This is a list of hosts where mail directed to this host should be sent to.  "
	.help.t insert end "Those sites using a mailhost will use this to direct their mail to the mail hub for processing.  "
	.help.t insert end "More than one host can be given.  Mail will will be directed to the first one on the list, unless "
	.help.t insert end "it is down, in which case it will direct it to the next one on the list.  If that one is down it will "
	.help.t insert end "be directed to the next one.\n\n"
	.help.t insert end "Comment:\n" big
	.help.t insert end "The comment is a general text field which can be used to for anything.  It should be less than 256 "
	.help.t insert end "characters in length.\n\n"
	.help.t insert end "The "
	.help.t insert end "Advanced" big
	.help.t insert end " button is used to invoke the Domain Editor.  With this you will be able to modify the properties "
	.help.t insert end "of the DNS server for the selected domain.\n"

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "nism" } {
	.help.t insert end "NIS Master Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "Sorry, no help is available on DNS client configuration in this version.\n"
	.help.t insert end "Look for updated help in the next revision."

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "nfs" } {
	.help.t insert end "NFS Server Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "The NFS server tool allows you to quickly add, modify, or delete shared (exported) filesystems.\n"
	.help.t insert end "Type the name of the directory you wish to share or export in the \"Shared Directory\" files, and then "
	.help.t insert end "set the Minimum Access level for the exported filesystem.  This specifies the global sharing "
	.help.t insert end "policy for a filesystem.\n"
	.help.t insert end "    Read/Write - Shares the filesystem with read and write access to all.\n"
	.help.t insert end "    Read only  - Shares the filesystem with read only access to all.\n"
	.help.t insert end "    None       - Shares the filesystem using the OS default.  It also allows you "
	.help.t insert end "to specify a combination of Read/Write and Read Only access to specific hosts"
	.help.t insert end ""

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "tape" } {
	.help.t insert end "Tape Archive Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "MAT has a flexable tape backup and restore module.  The Tape module has many useful features including: \n"
	.help.t insert end "  - The ability to backup remote hosts.\n"
	.help.t insert end "  - The ability to backup many hosts at at time.\n"
	.help.t insert end "  - The ability to coordinate all backups from a single tape server.\n"
	.help.t insert end "  - The ability to handle multiple SCSI tape devices on a single host.\n"
	.help.t insert end "  - Online indexes to eliminate the need to search through tapes.\n"
	.help.t insert end "\n"
	.help.t insert end "When a host is set as a 'Backup Host' in the MAT host configuration file it provides access to the tape "
	.help.t insert end "backup tools.  All hosts will have the 'Restore' icon within the Archive window, but only tape servers "
	.help.t insert end "will have a 'Backup' icon.\n"
	.help.t insert end "\n"
	.help.t insert end "What follows is a brief description of how to configure a backup server.\n"
	.help.t insert end "\n"
	.help.t insert end "On the backup host select Archive then Backup.  The window that is displayed is for configuring all aspects "
	.help.t insert end "of the backup.  A backup job is defined by who, what, when and where.  Who is defined by the Backup Group.  "
	.help.t insert end "What is defined by the Backup Job.  Where is determined by the Backup Devices.  When is set by the Backup Schedule.  "
	.help.t insert end "More indepth descriptions of the backup UI are provided in the help sections:\n"
	.help.t insert end "   Backup Devices\n" t2
	.help.t insert end "   Backup Group\n" t3
	.help.t insert end "   Backup Job\n" t4
	.help.t insert end "   Media Management\n" t5
	.help.t insert end "   Backup Schedule\n" t6
	.help.t insert end "   Restore\n" t7


	foreach tag {t1 t2 t3 t4 t5 t6 t7 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help tape }
	.help.t tag bind t2 <1> { help tapedevice }
	.help.t tag bind t3 <1> { help tapegroup }
	.help.t tag bind t4 <1> { help tapejob }
	.help.t tag bind t5 <1> { help tapemedia }
	.help.t tag bind t6 <1> { help matd }
	.help.t tag bind t7 <1> { help restore }

    } elseif { $topic == "tapegroup" } {
	.help.t insert end "Backup / Replication Groups\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "\n"
	.help.t insert end "The backup group defines a group of hosts for a backup job.  Backups are performed on groups "
	.help.t insert end "of hosts.  A backup group should have at least one member.  In this GUI you can Add/Delete/Modify group members, "
	.help.t insert end "and provide a descriptive name for the group.  The GUI prompts for:\n"
	.help.t insert end "GID # " big 
	.help.t insert end "- This is a numeric value representing the group of hosts.  Use anything from 0 - 65535.  "
	.help.t insert end "Take care not to use the number used by another group.\n\n"
	.help.t insert end "Group: " big 
	.help.t insert end "- This is a decsriptive name for the group.\n\n" 
	.help.t insert end "Member Hosts " big 
	.help.t insert end "- This section is used to list all the hosts in a backup group.  A "
        .help.t insert end "backup job will consult this list and start backups on all the hosts in this list.   The list"
        .help.t insert end "should have atleast one member, and no more than 64."
	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help tape }

    } elseif { $topic == "tapedevice" } {
	.help.t insert end "Backup Devices\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "\n"
	.help.t insert end "From this GUI you define the tape devices which are available for MAT to backup to.  "
	.help.t insert end "At least one tape device must be configured.  The tape GUI will prompt for:\n\n"
	.help.t insert end "ID # " big 
        .help.t insert end "- This is just a number which MAT will use internally to represent the tape "
	.help.t insert end "device.  Anything from 0-255 is valid, but it should not match any other tape device "
	.help.t insert end "on the tape server.\n\n"
	.help.t insert end "Name: " big 
	.help.t insert end "This a descriptive string you can use for identifing the tape devices.\n\n" 
	.help.t insert end "Path: " big 
	.help.t insert end "- This is the path for the tape device.  The non-rewinding device must be "
	.help.t insert end "used.  It may look like one of the following:\n"
	.help.t insert end "   /dev/nst0   - Linux \n"
	.help.t insert end "   /dev/rmt/0hn   - Solaris\n" 
	.help.t insert end "If the tape device supports multiple densities, you should use the highest density. \n\n"
	.help.t insert end "Picker Path: " big 
        .help.t insert end "- This field is not used in the current release of MAT.  It is for the "
	.help.t insert end "path of the SCSI library device.  If you don't have a jukebox just set it to /dev/null.\n\n" 
	.help.t insert end "Number of slots: " big 
        .help.t insert end "- This field is not used in the current release.  In later releases "
	.help.t insert end "this will be used to tell MAT how many slots are in the Jukebox.  Set it to 1 for "
	.help.t insert end "tape-drives."
	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help tape }

    } elseif { $topic == "tapemedia" } {
	.help.t insert end "Backup Media\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "The media management icon will display the contents of all the MAT tapes.  It is also used to "
	.help.t insert end "label a tape so MAT can use it.  To add a new tape for MAT to use hit the New button.  The "
	.help.t insert end "resulting GUI will prompt for:\n"
	.help.t insert end "Name: " big 
        .help.t insert end "- This is a string containing a descriptive name for the tape. \n\n"
	.help.t insert end "Backup Pool: " big 
        .help.t insert end "- This is for later use.  Later tape pools will be used to distinguise "
	.help.t insert end "backup sets.  Just put in 0.\n\n" 
	.help.t insert end "Backup Device: " big 
        .help.t insert end "- Select the device to use for the backup.  Note you must have "
	.help.t insert end "defined the tape devices before you try to label a tape.  Hit the ... button for a list of "
	.help.t insert end "all the devices and select one. \n\n"
	.help.t insert end "Backup Device: " big 
	.help.t insert end "- This is the uncompressed tape and tape drive capacity. "
	.help.t insert end "Hit the ... for a list of some common capacities, or just type it in.\n\n"
	.help.t insert end "When labeling a tape, the tape must be in the drive.  Labeling the tape will write a small header on "
	.help.t insert end "the tape.  The header is used by the backup and restore functions to identify the tape. "
	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help tape }

    } elseif { $topic == "tapejob" } {
	.help.t insert end "Backup Jobs\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "From this icon the backup jobs are defined.  Selecting this gives a list of the backup jobs.  To "
	.help.t insert end "create a new job just hit the New button.  The resulting GUI will prompt for: \n\n"
	.help.t insert end "Job # " big 
        .help.t insert end "- This is just a numeric value MAT uses to identiy jobs.  It can be anything "
	.help.t insert end "from 0 to 65535.  It must be unique. \n\n"
	.help.t insert end "Decsription: " big 
        .help.t insert end "- This is a string describing the backup job.\n\n" 
	.help.t insert end "Backup Group: " big 
        .help.t insert end "- This selects the hosts to be included in the backup.  The actual "
	.help.t insert end "group members are edited by the Backup Group GUI.  Hit the ... button for the "
	.help.t insert end "GID of the groups defined on the tape drive. \n\n" 
	.help.t insert end "Backup Device: " big 
        .help.t insert end "- This is the name of the SCSI backup device to write to.  Use "
	.help.t insert end "the ... button to see the devices which are configured on the tape server. \n\n" 
	.help.t insert end "Retention: " big 
        .help.t insert end "- This is the number of weeks to keep a backup before it has expired.  "
	.help.t insert end "Each backup has a time stamp.  After the retention period has elapsed, the volume "
	.help.t insert end "can be overwritten.  Once all volumes on the tape have expired the tape can be "
	.help.t insert end "reused.  \n\n"
	.help.t insert end "Backup Pool: " big 
        .help.t insert end "- This is not used in this release.  It can be set to 0.  \n\n"
	.help.t insert end "Browse Host: " big 
        .help.t insert end "- The GUI allows you to look through the directories of any of the "
	.help.t insert end "hosts in the backup pool to select the filesystems you want to include in the backup "
	.help.t insert end "set.  You can select up to 128 items to backup.  Directories such as /, or /usr count "
	.help.t insert end "as 1 item eventhough their contents are included in the backup.  On the left listbox "
	.help.t insert end "will be displayed the contents of the current directory on the current host.  To "
	.help.t insert end "change directories just double-click on it.  To include it in the backup job "
	.help.t insert end "Right-click on it, or select it and hit Add.  Note changes to the backup request list "
	.help.t insert end "are applied to the tape server immediately."


	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help tape }

    } elseif { $topic == "restore" } {
	.help.t insert end "Restoring from Tape\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "\n"
	.help.t insert end "This restore GUI is not complete at this time, however restores came be performed from the command line "
	.help.t insert end "interface (cmd).  The command is in the \$MATHOME/bin directory.  The interface accepts a command and "
	.help.t insert end "performs the requested action.  The cmd gives you access to all MAT functions.  From it to can add users, "
	.help.t insert end "change DNS tables, or in this case restore files.  The following steps outline how to restore files:\n\n"
	.help.t insert end "Verify that the tape library is installed with: \n"
	.help.t insert end "  \/var\/mat\/bin#  "
	.help.t insert end ".\/cmd\n" courier 
	.help.t insert end "  TAPE version \n" courier
	.help.t insert end "  0.190000 \n"
	.help.t insert end "  TRANSFER OK \n"
	.help.t insert end "  \/var\/mat\/bin# \n\n"

	.help.t insert end "Get the Tape drive ID numbers with: \n"
	.help.t insert end "  \/var\/mat\/bin# "
	.help.t insert end ".\/cmd\n" courier 
	.help.t insert end "  TAPE get drives \n" courier
	.help.t insert end "  1:Archive Python:/dev/nst0:/dev/null:1: \n"
	.help.t insert end "  TRANSFER OK \n"
	.help.t insert end "\n"
	.help.t insert end "In this example the Archive Python has tape ID # 1.  We will use the tape drive ID to query for all the "
	.help.t insert end "tapes made on this drive with: \n"
	
	.help.t insert end "  /var/mat/bin# "
	.help.t insert end "./cmd\n" courier 
	.help.t insert end "  TAPE get tapes 1 \n" courier
	.help.t insert end "  0:This is first tape \n"
	.help.t insert end "  1:This is the second tape\n" 
	.help.t insert end "  2:This is another tape \n"
	.help.t insert end "  TRANSFER OK \n"
	.help.t insert end "\n"
	
	.help.t insert end "Here we see that tape drive 1 has wrote to three tapes 0, 1, and 2.  To see the actual tape jobs on the "
	.help.t insert end "tape we can use the following command: \n"
	.help.t insert end "  \/var\/mat\/bin# "
	.help.t insert end ".\/cmd\n" courier 
	.help.t insert end "  TAPE get vols 1 0\n" courier
	.help.t insert end "  0:22\/6\/99:0:Usr local on darkstar and localhost \n"
	.help.t insert end "  1:23\/6\/99:0:Usr local on darkstar and localhost \n"
	.help.t insert end "  2:24\/6\/99:0:Usr local on darkstar and localhost \n"
	.help.t insert end "  3:25\/6\/99:0:Usr local on darkstar and localhost \n"
	.help.t insert end "  4:26\/6\/99:0:Usr local on darkstar and localhost \n"
	.help.t insert end "  5:27\/6\/99:0:Usr local on darkstar and localhost \n"
	.help.t insert end "\n"
	
	.help.t insert end "Here we see that tape 0 on drive 1 has 6 backup jobs on it.  If we want restore from the backup on the "
	.help.t insert end "24/6/99 we need to look at volume 2.  The catalog of the backup contents are stored on the tape server. "
	.help.t insert end "We can look at the contents of the volume with the following commands: \n"
	.help.t insert end "  \/var\/mat\/bin# "
	.help.t insert end ".\/cmd\n" courier 
	.help.t insert end "  TAPE get cat 1 0 2 darkstar \/\n" courier
	.help.t insert end "  0:etc\/ \n"
	.help.t insert end "\n"
	
	.help.t insert end "In the above we already knew wanted to restore the files from the host darkstar.  Darkstar had to be a "
	.help.t insert end "member of the group which was used for the backup.  In the above drive 1, tape 0, volume 2, contains "
	.help.t insert end "some or all of darkstar's /etc.  We can look further with: \n"
	
	.help.t insert end "  /var/mat/bin# "
	.help.t insert end ".\/cmd\n" courier 
	.help.t insert end "  TAPE get cat 1 0 2 darkstar \/etc\/\n" courier

	.help.t insert end "  0: \n"
	.help.t insert end "  1:mtools.conf \n" 
	.help.t insert end "  2:devinfo \n"
	.help.t insert end "  3:makedev.cfg\n" 
	.help.t insert end "  4:ttys \n"
	.help.t insert end "  5:fdprm \n"
	.help.t insert end "  6:group \n"
	.help.t insert end "  7:issue \n"
	.help.t insert end "  8:motd \n"
	.help.t insert end "  9:profile \n"
	.help.t insert end "  10:securetty \n"
	.help.t insert end "  11:shells \n"
	.help.t insert end "    : \n"
	.help.t insert end "    : \n"
	.help.t insert end "\n"
	.help.t insert end "Note the trailing / in /etc/ is significant.   We can use the TAPE get cat command to look through the "
	.help.t insert end "directories or files we want.  After you find the files of directories you want, make note of the index "
	.help.t insert end "number of each file or directory you want.  Recovering a directory restores both the directory and it's "
	.help.t insert end "contents.  In this example if we want /etc/mtools.conf, and /etc/shells, which are index 1 and 11, we use "
	.help.t insert end "the following: \n"
	.help.t insert end "\n"
	.help.t insert end "  /var/mat/bin# "
	.help.t insert end ".\/cmd\n" courier 
	.help.t insert end "  TAPE restore 1 0 2 darkstar /tmp 4 1,11\n" courier
	.help.t insert end "\n"
	.help.t insert end "NOTE:  There is a bug in the volume representation in the restore command.  The real volume "
	.help.t insert end "number given above will not work, instead multiply it by 2 and add 1 \n"
	.help.t insert end "eg    Restore_Vol# = ( 2 * Vol#_given ) + 1 \n"
	.help.t insert end "In the above example it should really be:\n"
	.help.t insert end "  /var/mat/bin# "
	.help.t insert end ".\/cmd\n" courier 
	.help.t insert end "  TAPE restore 1 0 5 darkstar /tmp 4 1,11\n" courier
	.help.t insert end "\n"
	.help.t insert end "The restore will start restoring the files with index 1 and 11 to /tmp on darkstar.  The ownership, "
	.help.t insert end "permissions, and time will be reset to their original value.  It is not necessary to restore to /tmp.  You can "
	.help.t insert end "use / to return the files to their original location.  The number 4 is a flag to tell the restore what to do in "
	.help.t insert end "the event of another file in the restore location.  The following are defined, but only "
	.help.t insert end "action 4 is fully tested: \n"
	.help.t insert end "\n"
	.help.t insert end "    0 - Rename all files where the name conflicts\n" 
	.help.t insert end "    1 - Skip all files where the name conflicts \n"
	.help.t insert end "    2 - Replace all files were the time differs \n"
	.help.t insert end "    4 - Replace all files even if there is no difference \n"
	.help.t insert end "    8 - Replace all newer files. "

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help tape }

    } elseif { $topic == "replication" } {
	.help.t insert end "File/Directory Replication\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "\n"
	.help.t insert end "The file/directory replication module is an easy to use tool for the synchronization of "
	.help.t insert end "files and directories across a group of machines.  Files are copied from a replication "
	.help.t insert end "master to the client machines, presarving the directory structure of the requested directories.  "
	.help.t insert end "The replication master has several useful features, including the parallel synchronization.  "
	.help.t insert end "The replication master will try to synchronize up to eight client machines at the same time.  "
	.help.t insert end "To save network bandwith only the files requested by the client will be send.  The client has "
	.help.t insert end "three synchronization modes:\n"
	.help.t insert end " 1.  Replace all files\n"
	.help.t insert end " 2.  Skip duplicate files\n"
	.help.t insert end " 1.  Replace files where the times differ\n"
	.help.t insert end "The replicated files and directories do not have to be replicated to their original location.  "
	.help.t insert end "Sometimes it is desirable to change the ownership, group, and permissions of the replicated "
	.help.t insert end "files and directories.  This can be set in the replication job definition.\n\n"
	.help.t insert end "A replication job it defined by the files to replicate, and the hosts to replicate to.  "
	.help.t insert end "The replication group is the same as a backup group.  Backup groups can be used for replication.\n"
	.help.t insert end "Click here for more information on Replication Groups\n" t2
	.help.t insert end "Click here for more information on Replication Jobs\n" t3

	foreach tag {t1 t2 t3} {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
	.help.t tag bind t2 <1> { help tapegroup }
	.help.t tag bind t3 <1> { help repljob }
    } elseif { $topic == "repljob" } {
	.help.t insert end "File/Directory Replication Jobs\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "\n"
	.help.t insert end "From this GUI replication jobs are configured.  This tools allows the selection of what "
	.help.t insert end "tp replicate, who to replicate to, and how to replicate.  If needed the "
	.help.t insert end "Replicate Now " big
	.help.t insert end "buttom can be used to start the replication immediately.  "
	.help.t insert end "The GUI has five sections:\n"
	.help.t insert end "Description:\n" big
	.help.t insert end "In this view the job is given a name.  This is the name which will be displayed by the "
	.help.t insert end "MAT console.  The job number can be any unique number from 0 to 99999.  The description "
	.help.t insert end "should be less that 256 characters\n"
	.help.t insert end "Files:\n" big
	.help.t insert end "In this view the files and directories to be replicated can be selected.  Double-click on the "
	.help.t insert end "files to be replicated.\n"
	.help.t insert end "Target:\n" big
	.help.t insert end "The target view selects both the group of machines to replicate to as well as the location "
	.help.t insert end "on the client system to replicate to.  Click the \"...\" button to select on of the available "
	.help.t insert end "replication groups.  When one is selected the group decsription will be displayed.  The "
	.help.t insert end "Location defines where to copy the files.  Normally this will be \"\/\".\n" 
	.help.t insert end "Permissions:\n" big
	.help.t insert end "The permissions view controls the ownership, group, and permissions of the replicated files"
	.help.t insert end "and directories. \nOwnership sets the owner of the replicated files and directories.  "
	.help.t insert end "The \"...\" button gives a list of some of the available owners, but any UID can be entered.\n"
	.help.t insert end "Group sets the GID of the replicated files and directories.   The \"...\" button gives a list "
	.help.t insert end "of some of the available GID's, but any GID number can be entered.\n"
	.help.t insert end "Set UID can be used to disable set UID programs.  The file will still be replicated, but the "
	.help.t insert end "Set UID flag can be removed.\n"
	.help.t insert end "The permissions of the files and directories can be set independly\n"
	.help.t insert end "Action:\n" big
	.help.t insert end "The action view specifies how to deal with files that already exist on the client.  The client "
	.help.t insert end "can either replace all duplicate file, skip duplicate, or replicate it if the masters version "
	.help.t insert end "is newer."

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help replication }
    } elseif { $topic == "matd" } {
	.help.t insert end "MATd Monitoring Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "MATd is a useful system monitoring tool.  It provides information on a systems \"health\".  "
	.help.t insert end "With it an administrator can see many of the common system parameters, making capacity planning easier.  "
	.help.t insert end "\n\n"
	.help.t insert end "MATd periodically checks the status of a monitored parameter, and if needed can run user "
	.help.t insert end "supplied scripts when a monitored parameter exceeds a preset threshold.  For example this allows MATd "
	.help.t insert end "to generate warnings when disk freespace is low, attempt to restart sendmail should it die, or "
	.help.t insert end "email the administrator should a system be unreachable."
	.help.t insert end "\n\n"
	.help.t insert end "For several of the monitored parameters MATd provides a graphical output from the monitored parameter.  " 
	.help.t insert end "This is particulary useful for looking at usage pattern, including machine load."
	.help.t insert end "Currently the MATd program can can graph the history of:\n"
	.help.t insert end "    Disk usage\n"
	.help.t insert end "    CPU usage\n"
	.help.t insert end "    Number of logins\n"
	.help.t insert end "    Run Queue\n"
	.help.t insert end "    NIC trafic\n"
	.help.t insert end "A textual output is also provided for the following:\n"
	.help.t insert end "    Sendmail Status\n"
	.help.t insert end "    Required prosesses status\n"
	.help.t insert end "    FTP daemon status\n"
	.help.t insert end "    Router status\n"
	.help.t insert end "    User supplied script status\n"
	.help.t insert end "\n"
	.help.t insert end "The monitoring tool and the monitored parameters can be found from the MATd icon "
	.help.t insert end "in the Config screen.  Double-Clicking on it will bring you to the MATd screen.  "
	.help.t insert end "From here you will be able to add, modify, or delete monitored parameters.  "
	.help.t insert end "The MATd icon provides a list of all the parameters it monitors, and any other "
	.help.t insert end "tasks the MATd daemon runs.  Right-clicking on the parameter, or selecting from the "
	.help.t insert end "scheduled task list allows you to modify the operation of MATd with respect to the "
	.help.t insert end "monitored parameter.  From the Task editor you can control the following:\n"
	.help.t insert end "    Task ID #         - A unique number for each task\n"
	.help.t insert end "    Run condition     - When to run/sample\n"
	.help.t insert end "    Job Type          - Monitor, Backup, Cleanup, User defined\n"
	.help.t insert end "    Timeout interval  - How long to wait before killing the task\n"
	.help.t insert end "    Log to file       - Where to save the output\n"
	.help.t insert end "    Lines to Retain   - Length of history of events to store\n"
	.help.t insert end "\n"
	.help.t insert end "Run Condition:\n" big
	.help.t insert end "Selecting the "
	.help.t insert end "Run Condition"
	.help.t insert end " button will allow you to set/modify the time or interval at which a task is run.  "
	.help.t insert end "The task can run after a certain interval, or at specific times.  Selecting "
	.help.t insert end "Interval " big
	.help.t insert end "will allow you to select the time between succesive samples/tasks.  Selecting "
	.help.t insert end "Timed " big
	.help.t insert end "Will allow you to select the system time at which a task will run.  Multiple times "
	.help.t insert end "can be selected, just like a crontab entry."
	.help.t insert end "\n\n"
	.help.t insert end "Job Type:\n" big
	.help.t insert end "This button allows you to select the type of job to run.  The job types listed are:\n"
	.help.t insert end "    Monitor      - This is for teh monitored parameter section.\n"
	.help.t insert end "    User Script  - The MATd daemon can be used to run any user script.\n"
	.help.t insert end "    Clean Log    - This is for truncating log files to a maximum number of lines, but not files which are always open.\n"
	.help.t insert end "    Backup       - When complete this will be for scheduling backups.\n"
	.help.t insert end "\n\n"
	.help.t insert end "Monitoring Jobs\n" big
	.help.t insert end "When a monitor job is selected the GUI will prompt for additional information.  Clicking the "
	.help.t insert end "Monitor " big
	.help.t insert end "button will list all the supported monitored parameters such as:\n"
	.help.t insert end "    Run Queue\n"
	.help.t insert end "    CPU Use\n"
	.help.t insert end "    Disk Use\n"
	.help.t insert end "    Processes\n"
	.help.t insert end "    Connectivity\n"
	.help.t insert end "    Network Activity\n"
	.help.t insert end "    FTP daemon\n"
	.help.t insert end "    SMTP Mail system\n"
	.help.t insert end "From which one can be selected.\n\n"
	.help.t insert end "Warning Threshold " big
	.help.t insert end "is a numeric value which is used as a trigger for the warning script.  The warning script will "
	.help.t insert end "be run when the monitored parameter meets the condition outlined by the warning threshold.  For "
	.help.t insert end "example with disk use monitoring if the threshold were set to <= 20000, the warinig script would "
	.help.t insert end "run when the available disk space drops below 20 Meg.  For monitored parameters which only provide "
	.help.t insert end "a pass/fail result the threshold should be set to <= 0.  Using this value with the SMTP mail would cause the "
	.help.t insert end "Warning script to run if the daemon was not responding.  "
	.help.t insert end "\n\n"
	.help.t insert end "Warning Script " big
	.help.t insert end "is the script to run when the warning threshold condition has been met.  The script should NOT rely on"
	.help.t insert end "environment variables from the calling process e.g. PATH.  The warning script can run any task you require "
	.help.t insert end "to rectify the problem.\n\n"
	.help.t insert end "Warn After \# " big
	.help.t insert end "is the number of successive times a monitored parameter must exceed the threshold before the warning "
	.help.t insert end "script will run.  Setting it to 0 disables the warning threshold, and warning script.\n\n"
	.help.t insert end "Optional Data " big
	.help.t insert end "is needed by some of the monitored parameters.  The following lists the parameter and the extra data needed:\n"
	.help.t insert end "    Processes     - Needs the location of the process list file.\n"
	.help.t insert end "    Connectivity  - Needs the IP address of the host/gateway to monitor.\n"
	.help.t insert end "    Disk Use      - Needs the filesystem to monitor.\n"
	.help.t insert end "\n\n"
	.help.t insert end "User Script\n" big
	.help.t insert end "Selecting a user script will cause the GUI to prompt for the script or program to run.  The full path of "
	.help.t insert end "the program should be given.  No environment variables will be passed to the user script, so it should "
	.help.t insert end "contain any environment variables it requires."
	.help.t insert end "\n\n"
	.help.t insert end "Clean Log\n" big
	.help.t insert end "This task type is for truncating log files.  It can be used to keep log files from getting too large to "
	.help.t insert end "deal with.  Note it should NOT be used for log files which are constantly open, like syslog files.  "
	.help.t insert end "MATd's log files are maintained automatically by the MATd Log cleaner."
	.help.t insert end "\n\n"
	.help.t insert end "Backup\n" big
	.help.t insert end "This is for scheduling backups, and for selecting what and where to backup.  It is not functional in this "
	.help.t insert end "release.  Look for it in later versions."
	.help.t insert end ""
	.help.t insert end ""
	.help.t insert end ""

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "startup" } {
	.help.t insert end "MAT Startup\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "Thank you for trying MAT. \n"
	.help.t insert end "\n"
	.help.t insert end "To start you need to add the hosts to the MAT hosts file.  Select "
	.help.t insert end "Agent" big
	.help.t insert end " and in the menu choose: "
	.help.t insert end "MAT Hosts" big
	.help.t insert end ".  At the bottom of the screen click the "
	.help.t insert end "NEW" green
	.help.t insert end " button.  A new window will open.  Add the hosts name in the MAT Host field, and select the services which the "
	.help.t insert end "host provides.\n"
	.help.t insert end "Note:" big
	.help.t insert end "The backup module is an alpha.\n\n "
	.help.t insert end "An icon will appear for the just added host.  Click the "
	.help.t insert end "NEW" green
	.help.t insert end " button to add as many hosts as you like.\n\n"
	.help.t insert end "The default password used by the root account is not secure, and MUST be changed.  Double-click on the hosts icon.  "
	.help.t insert end "Select "
	.help.t insert end "Agent" big
	.help.t insert end " from the top of the window and choose: "
	.help.t insert end "Login" big
	.help.t insert end ".  The login window will appear.  Click on the "
	.help.t insert end "Change Password" red
	.help.t insert end " button.  Do not remove the default password.  Enter the new password twice, and click the "
	.help.t insert end "Okay" green
	.help.t insert end " button.  This new password will be needed to control the MAT agent on that host, so don't loose it.\n"
	.help.t insert end "Enjoy......"
	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } else {
	.help.t insert end "Sorry\n" title
	.help.t insert end "No help is available on the selected item.  Look for improved help in the next release.\n"
	.help.t insert end "\n"
	.help.t insert end "Go to Main Menu\n" t10
	.help.t tag bind t10 <Any-Enter> ".help.t tag configure t10 $bold"
	.help.t tag bind t10 <Any-Leave> ".help.t tag configure t10 $normal"
	.help.t tag configure t10 -foreground #4040a0
	.help.t tag bind t10 <1> { help help }
    }
}



