# gconfig.tcl Library
#
# Copyright (c) 1997, 1998 Mark Black
#
# Rebuild index using "auto_mkindex /home/mark/mat/lib *.tcl"
#
# This library contains the following functions:
#   Groups     - Group update GUI
#   Hosts      - Hosts update GUI
#   hostUpdate - Host IP check, and update procedure
#   User       - User update GUI
#   useropt    - User options GUI
#   services   - Services GUI
#   -------------- Task Procedures ----------------


#
# Group update procedure
#
# USE Group CurrentHost CurrentLine SelectedData
#             CurrentHost = host to update
#             CurrentLine = Line number of selected line
#                           If 9999 then it is a new entry
#             SelectedData = line of data to modify
# NOTE: Data must be seperated by a single space or a singel tab
#
proc Groups { currenthost currentline line } {
    global errno
    set host $currenthost
    if { [winfo exists .group ] == 0 } {
	toplevel .group -class Dialog
	wm title .group "Groups Editor: $currenthost"
	wm iconname .group "Groups Editor"
	entry .group.hidden1 
	entry .group.hidden2
	# NOT GOOD
	.group.hidden1 insert end $currenthost
	if { $currentline != 9999 } {
	    .group.hidden2 insert end [lindex [split $line ":"] 0]
	} else {
	    .group.hidden2 insert end $currentline
	}
	frame .group.f1 -bd 2 -relief "raised"
	label .group.f1.l1 -text "Group:" -width 6
	entry .group.f1.e1 -width 10
	pack .group.f1.l1 .group.f1.e1 -fill both -side left -expand 1
	frame .group.f2 -bd 2 -relief "raised"
	label .group.f2.l1 -text "GID #:" -width 6
	entry .group.f2.e1 -width 10
	pack .group.f2.l1 .group.f2.e1 -fill both -side left -expand 1
	frame .group.f3 -bd 2 -relief "raised"
	label .group.f3.l1 -text "Users" 
	pack .group.f3.l1 -fill x
	frame .group.f3.f1 -bd 2 -relief "flat"
	entry .group.f3.f1.e1 -width 10
	button .group.f3.f1.b1 -text "Add" -command {
	    if { [.group.f3.f1.e1 get] != "" } {
		.group.f3.f2.text insert end [.group.f3.f1.e1 get]
	    }
	    .group.f3.f1.e1 delete 0 end
	}
	pack .group.f3.f1.e1 .group.f3.f1.b1 -fill both -side left -expand 1
	frame .group.f3.f2 -bd 2 -relief "flat"
	scrollbar .group.f3.f2.vscroll -orient vertical -command ".group.f3.f2.text yview" 
	listbox .group.f3.f2.text -selectforeground white -selectbackground #000080 -yscrollcommand {.group.f3.f2.vscroll set } -height 5 -width 10
	.group.f3.f2.text config -cursor hand2
	pack .group.f3.f2.vscroll -side left -fill y
	pack .group.f3.f2.text -side left -expand 1 -fill both
	button .group.f3.f2.b1 -text "Delete" -foreground red -activeforeground #a00000 -command {
	    if { [.group.f3.f2.text curselection ] != "" } {
		.group.f3.f2.text delete [.group.f3.f2.text curselection ]
	    }
	}
	pack .group.f3.f2.b1 -side left
	pack .group.f3.f1 .group.f3.f2 -side top -fill both -expand 1
	frame .group.f4 -bd 2 -relief "flat"
	button .group.f4.b1 -text "Apply" -foreground red -activeforeground #a00000 -command {
	    if { [.group.f2.e1 get] > -2 || [.group.f2.e1 get] < 65536 } {
		if { [.group.f1.e1 get] != "" } {
		    set tmpline "[ string tolower [.group.f1.e1 get]]::[ string tolower [.group.f2.e1 get]]:"
		    foreach user [.group.f3.f2.text get 0 end] {
			append tmpline "[string tolower [string trimright $user]],"
		    }
		    set newline [string trimright $tmpline "," ] 
		    set currentline [.group.hidden2 get]
		    if { $currentline == 9999 } {
			set cmd "CON add group $newline"
		    } else {
			set cmd "CON mod group [.group.hidden2 get] $newline"
		    }
		    set returnval [queryHost $currenthost $cmd 1 ]
		    if { $errno != 0 } {
			error 91
			puts stdout "ERROR:  Unable to update the /etc/group file on $currenthost\n       Check the files permissions"
		    } else {
			repack 2
			destroy .group
		    }
		}
	    }
	}
	button .group.f4.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    repack 2
	    destroy .group
	}
	button .group.f4.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help groups
	}
	pack .group.f4.b1 .group.f4.b2 .group.f4.b3 -side left -fill x 
	pack .group.f1 .group.f2 .group.f3 .group.f4 -fill both -expand 1
	# ----- Bindings -----
	bind .group.f1.e1 <Return> {
	    focus .group.f2.e1
	}
	bind .group.f2.e1 <Return> {
	    focus .group.f3.f1.e1
	}
	bind .group.f3.f1.e1 <Return> {
	    if { [.group.f3.f1.e1 get] != "" } {
		.group.f3.f2.text insert end [.group.f3.f1.e1 get]
	    }
	    .group.f3.f1.e1 delete 0 end
	}
    } else {
	.group.hidden1 delete 0 end
	.group.hidden2 delete 0 end
	.group.hidden1 insert end $currenthost
	if { $currentline != 9999 } {
	    .group.hidden2 insert end [lindex [split $line ":"] 0]
	} else {
	    .group.hidden2 insert end $currentline
	}
	wm title .group "Groups Editor: $currenthost"
    }

    # Fill boxes with data
    if { $currentline != 9999 } {
	.group.f1.e1 delete 0 end
	.group.f2.e1 delete 0 end
	.group.f3.f2.text delete 0 end
	.group.f1.e1 insert end [lindex [split $line ":"] 0]
	.group.f2.e1 insert end [lindex [split $line ":"] 2]
	set tmp [lindex [split $line ":"] 3]
	foreach user [split $tmp ","] {
	    .group.f3.f2.text insert end $user
	}
	    
    }	
}


#
# Hosts Update procedure
#
# USE:  Hosts CurrentHost CurrentLine SelectedData
#             CurrentHost = host to update
#             CurrentLine = Line number of selected line
#             SelectedData = line of data to modify
# NOTE: Data must be seperated by a single space or a singel tab
#
proc Hosts { currenthost currentline line args } {
    set host $currenthost
    if { [string length $args ] != 0 } {
	append line " $args"
    }
    if { [winfo exists .host ] == 0 } {
	toplevel .host -class Dialog
	wm title .host "Hosts Editor: $currenthost"
	wm iconname .host "Hosts Editor"
	entry .host.hidden1 
	entry .host.hidden2
	# NOT GOOD
	.host.hidden1 insert end $currenthost
	if { $currentline != 9999 } {
	    .host.hidden2 insert end [lindex [split $line ] 0 ]
	} else {
	    .host.hidden2 insert end $currentline
	}
	frame .host.f1 -bd 2 -relief "raised"
	label .host.f1.label -text "IP address:" -width 12
	entry .host.f1.e1 -width 3
	label .host.f1.l1 -text "."
	entry .host.f1.e2 -width 3
	label .host.f1.l2 -text "."
	entry .host.f1.e3 -width 3
	label .host.f1.l3 -text "."
	entry .host.f1.e4 -width 3
	
	pack .host.f1.label .host.f1.e1 .host.f1.l1 .host.f1.e2 .host.f1.l2 .host.f1.e3 .host.f1.l3 .host.f1.e4 -fill both -side left -expand 1
	frame .host.f2 -bd 2 -relief "raised"
	label .host.f2.label -text "Host name:" -width 12
	entry .host.f2.entry 
	pack .host.f2.label .host.f2.entry -fill both -side left -expand 1
	frame .host.f3 -bd 2 -relief "raised"
	label .host.f3.label -text "Alias(es):" -width 12
	entry .host.f3.entry 
	pack .host.f3.label .host.f3.entry -fill x -side left -expand 1
	pack .host.f1 .host.f2 .host.f3 -fill both
	button .host.ok -text "Okay" -foreground red -activeforeground #a00000 -command {
	    hostUpdate [.host.hidden1 get] [.host.hidden2 get] [ .host.f1.e1 get] [ .host.f1.e2 get] [ .host.f1.e3 get] [ .host.f1.e4 get] [ .host.f2.entry get] [ .host.f3.entry get]
	    repack 1
	    destroy .host
	}
	button .host.app -text "Apply" -foreground red -activeforeground #a00000 -command {
	    hostUpdate [.host.hidden1 get] [.host.hidden2 get] [ .host.f1.e1 get] [ .host.f1.e2 get] [ .host.f1.e3 get] [ .host.f1.e4 get] [ .host.f2.entry get] [ .host.f3.entry get]
	    .host.f1.e1 delete 0 end
	    .host.f1.e2 delete 0 end
	    .host.f1.e3 delete 0 end
	    .host.f1.e4 delete 0 end
	    .host.f2.entry delete 0 end
	    .host.f3.entry delete 0 end
	    .host.hidden2 delete 0 end
	    .host.hidden2 insert end 9999
	    repack 1
	}
	button .host.can -text "Cancel"  -foreground blue -activeforeground #000080 -command {
	    destroy .host
	}
	button .host.help -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help hosts
	}
	pack .host.ok .host.app .host.can .host.help -fill x -side left -expand 1
	
	# -----------  Bindings for Hosts  -------------------------
	bind .host.f1.e1 <Return> {
	    focus .host.f1.e2 
	}
	bind .host.f1.e1 . {
	    after 250 {
		.host.f1.e1 delete [expr [string length [.host.f1.e1 get]] -1] end
	    }
	    focus .host.f1.e2 
	}
	bind .host.f1.e2 <Return> {
	    focus .host.f1.e3 
	}
	bind .host.f1.e2 . {
	    after 250 {
		.host.f1.e2 delete [expr [string length [.host.f1.e2 get]] -1] end
	    }
	    focus .host.f1.e3 
	}
	bind .host.f1.e3 <Return> {
	    focus .host.f1.e4 
	}
	bind .host.f1.e3 . {
	    after 250 {
		.host.f1.e3 delete [expr [string length [.host.f1.e3 get]] -1] end
	    }
	    focus .host.f1.e4 
	}
	bind .host.f1.e4 <Return> {
	    focus .host.f2.entry 
	}
	bind .host.f2.entry <Return> {
	    focus .host.f3.entry 
	}
	bind .host.f3.entry <Return> {
	    #	focus .host.f1.entry 
	}
    } else {
	wm title .host "Hosts Editor: $currenthost"
	.host.hidden1 delete 0 end
	.host.hidden2 delete 0 end
	.host.hidden1 insert end $currenthost
	if { $currentline != 9999 } {
	    .host.hidden2 insert end [lindex [split $line ] 0 ]
	} else {
	    .host.hidden2 insert end $currentline
	}
    }

    if { $currentline != "9999" && [lindex [split $line {} ] 0] != "#" } {
	set tmp [lindex [split $line ] 0]
	.host.f1.e1 delete 0 end
	.host.f1.e2 delete 0 end
	.host.f1.e3 delete 0 end
	.host.f1.e4 delete 0 end
	.host.f2.entry delete 0 end
	.host.f3.entry delete 0 end
	.host.f1.e1 insert end [lindex [split $tmp "."] 0]
	.host.f1.e2 insert end [lindex [split $tmp "."] 1]
	.host.f1.e3 insert end [lindex [split $tmp "."] 2]
	.host.f1.e4 insert end [lindex [split $tmp "."] 3]
	.host.f2.entry insert end [lindex [split $line " 	"] 1]
#	.host.f3.entry insert end [lindex [split $line " 	"] 2]
	for { set position 2 } { $position < [llength [split $line " 	"] ] } { incr position 1 } {
	    .host.f3.entry insert end [lindex [split $line " 	"] $position ]
	    .host.f3.entry insert end { }
	}
    }
}


	    
#
# ---- Procedure to build the update line
#
proc hostUpdate { currenthost oldip ip1 ip2 ip3 ip4  name alias } {
    global errno
    if { $ip1 > 255 || $ip1 < 0 } {
	error 50
	return -1
    } elseif { $ip2 > 255 || $ip2 < 0 } {
	error 50
	return -1
    } elseif { $ip3 > 255 || $ip3 < 0 } {
	error 50
	return -1
    } elseif { $ip4 > 255 || $ip4 < 0 } {
	error 50
	return -1
    } else { 
	if { $oldip != 9999 } {
	    set cmd "CON mod hosts $oldip $ip1.$ip2.$ip3.$ip4	[string tolower $name ]	[string tolower $alias]"
	} else {
	    set cmd "CON add hosts $ip1.$ip2.$ip3.$ip4	[string tolower $name ]	[string tolower $alias]"
	}
	set returnval [queryHost $currenthost $cmd 1 ]
	if { $errno != 0 } {
	    error 51
	    puts stdout "ERROR:  Unable to update the /etc/hosts file on $currenthost\n        Check the files permissions"
	}
    }
}


#
# User Update procedure
#
# USE:  User  CurrentUser CurrentLine SelectedData
#
#             CurrentUser = User to update
#             CurrentLine = Line number of selected line  (9999 = no data)
#             SelectedData = line of data to modify
# NOTE: Data must be seperated by a single space or a singel tab
#
proc User { currenthost currentline line args } {
    global errno
    global userkey
    # This is the minimum allowable gid.  It protects the more sensiteve groups from less sensitive administerators
    set mingid 10
    # This is the minimum allowable User ID
    set minuid 10
    set homedir "/home"
    # NOTE:   modify apply button to reflect any changes here
    set shell "/bin/sh"
    set key {}
    if { [string length $args ] != 0 } {
	append line " $args"
    }
    set host $currenthost
    if { [winfo exists .opt ] != 0 } {
	destroy .opt
    }
    if { [winfo exists .user ] == 0 } {
	toplevel .user -class Dialog
	wm title .user "User Editor: $currenthost"
	wm iconname .user "User Editor"
	entry .user.hidden1 
	entry .user.hidden2
	entry .user.hidden3
	entry .user.hidpass
	entry .user.hiduid
	entry .user.hidgid
	entry .user.hidshell
	entry .user.hiddir
	listbox .user.hiddenlist
	# NOT GOOD
	.user.hidden1 insert end $currenthost
	if { $currentline != 9999 } {
	    .user.hidden2 insert end [lindex [split $line {:} ] 0 ]
	} else {
	    .user.hidden2 insert end $currentline
	}
	.user.hidden3 insert end $line
	.user.hidpass delete 0 end
	frame .user.f1 -bd 2 -relief "raised"
	label .user.f1.label -text "First Name" -width 10
	entry .user.f1.e1 -width 16
	pack .user.f1.label .user.f1.e1 -fill both -side left -expand 1
	frame .user.f2 -bd 2 -relief "raised"
	label .user.f2.label -text "Surname" -width 10
	entry .user.f2.entry -width 16
	pack .user.f2.label .user.f2.entry -fill both -side left -expand 1
	frame .user.f3 -bd 2 -relief "raised"
	label .user.f3.label -text "Login" -width 10
	entry .user.f3.entry -width 16
	pack .user.f3.label .user.f3.entry -fill both -side left -expand 1
	frame .user.f4 -bd 2 -relief "raised"
	label .user.f4.l1 -text "Primary Group"
	pack .user.f4.l1 -fill x
	scrollbar .user.f4.vscroll -orient vertical -command ".user.f4.text yview" 
	listbox .user.f4.text -selectforeground white -selectbackground #000080 -yscrollcommand {.user.f4.vscroll set } -height 5 -width 10
	.user.f4.text config -cursor hand2
	pack .user.f4.vscroll -side left -fill y
	pack .user.f4.text -side left -expand 1 -fill both

	frame .user.f5 -bd 2 -relief "raised"
	button .user.f5.b1 -text "Apply" -foreground red -activeforeground #a00000 -command {
	    global userkey
	    set flag 0
	    if { [.user.f4.text curselection ] != "" } {
		set gid [lindex [split [.user.hiddenlist get [lindex $userkey [ .user.f4.text curselection ]]] ":" ] 2]
	    } else {
		set gid [ .user.hidgid get ]
	    }
	    if { [.user.hiddir get] == "" } {
		.user.hiddir insert end "/home/[.user.f3.entry get]"
	    }
	    if { [.user.f2.entry get] == "" } {
#		set newline "[.user.f3.entry get]:[.user.hidpass get]:[.user.hiduid get]:[.user.hidgid get]:[.user.f1.e1 get]:[.user.hiddir get]:[.user.hidshell get]"
set newline "[.user.f3.entry get]:[.user.hidpass get]:[.user.hiduid get]:$gid:[.user.f1.e1 get]:[.user.hiddir get]:[.user.hidshell get]"
	    } else {
#		set newline "[.user.f3.entry get]:[.user.hidpass get]:[.user.hiduid get]:[.user.hidgid get]:[.user.f1.e1 get] [.user.f2.entry get]:[.user.hiddir get]:[.user.hidshell get]"
		set newline "[.user.f3.entry get]:[.user.hidpass get]:[.user.hiduid get]:$gid:[.user.f1.e1 get] [.user.f2.entry get]:[.user.hiddir get]:[.user.hidshell get]"
	    }
	    if { [.user.hidden2 get] == 9999 } {
		set cmd "CON add pass $newline"
	    } else {
		set cmd "CON mod pass [.user.hidden2 get] $newline"
	    }
	    set returnval [queryHost $currenthost $cmd 1 ]
	    if { $errno != 0 } {
		error 91
		puts stdout "ERROR:  Unable to update the /etc/passwd file on $currenthost\n       Check the file and directory permissions"
	    }
	    # Close window
	    repack 5
	    destroy .user
	}

	button .user.f5.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    if { [winfo exists .opt ] != 0 } {
		destroy .opt
	    }
	    destroy .user
	}
	button .user.f5.b3 -text "Options" -foreground #008000 -command {
	    useropt 
	}
	button .user.f5.b4 -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help users
	}
	pack .user.f5.b1 .user.f5.b2 .user.f5.b3 .user.f5.b4 -fill x -side left -expand 1

	frame .user.f6 -bd 2 -relief "raised"
	button .user.f6.b1 -text "Lock Account" -foreground red -activeforeground #a00000 -command {
	    .user.hidpass delete 0 end
	    .user.hidpass insert end "LOCK"
	}
	button .user.f6.b2 -text "Unlock Account" -foreground red -activeforeground #a00000 -command {
	    .user.hidpass delete 0 end
	    .user.hidpass insert end "UNLOCK"
	}
	pack .user.f6.b1 .user.f6.b2 -fill x -side left -expand 1

	pack .user.f1 .user.f2 .user.f3 .user.f4 .user.f5 .user.f6 -fill x -side top -expand 1

	bind .user.f1.e1 <Return> {
	    focus .user.f2.entry 
	}
	bind .user.f2.entry <Return> {
	    puts stdout "Got to bind  .usr.hidden2 = [ .user.hidden2 get ]"
	    focus .user.f3.entry
	    if { [ .user.hidden2 get ] == 9999 } {
		puts stdout "1.  .user.f1.e1 = [ .user.f1.e1 get ]"
		.user.f3.entry insert end [ string tolower [ lindex [ split [ .user.f1.e1 get ] {} ] 0 ] ]
		set splt_name [ split [ .user.f2.entry get ] {} ]
		set max [ llength $splt_name ]
		if { $max > 0 } {
		    if { $max >= 7 } {
			set max 7
		    }
		    set i 0
		    while { $i < $max } {
			.user.f3.entry insert end [ string tolower [ lindex $splt_name $i ] ]
			incr i
		    }
		}
	    }
	}
	bind .user.f3.entry <Return> {
	    focus .user.f1.e1 
	}
    } else {
	# --- Window open already ---
	wm title .user "User Editor: $currenthost"
	.user.hidden1 delete 0 end
	.user.hidden2 delete 0 end
	.user.hidden3 delete 0 end
	.user.hidden1 insert end $currenthost
	if { $currentline != 9999 } {
	    .user.hidden2 insert end [lindex [split $line {:} ] 0 ]
	} else {
	    .user.hidden2 insert end $currentline
	}
	.user.hidden3 insert end $line
    }
    .user.f4.text delete 0 end
    set userkey {}
    set cnt1 0
    .user.hidpass delete 0 end
    .user.hidpass insert end "PASSWORD"
    .user.hiduid delete 0 end
    .user.hiduid insert end "AUTO"
    .user.hidgid delete 0 end
    .user.hidshell delete 0 end
    .user.hidshell insert end $shell
    .user.hiddir delete 0 end
    
    set index 0
    set returndata [queryHost $currenthost "CON get group" 0 ]
    for { set position 0 } { $position < [llength $returndata] } { incr position 1 } {
	set tmp [string trimright [lindex $returndata $position ] ]
	# Maintain an actual list of the file in a hidden list
	.user.hiddenlist insert end $tmp
	set tmp2 [split $tmp ":" ]
	if { [lindex $tmp2 2 ] >= $mingid } {
	    set gidnum [lindex $tmp2 2 ]
	    set gid2index($gidnum) $index
	    incr index 1
	    .user.f4.text insert end [lindex $tmp2 0 ]
	    lappend userkey $cnt1
	}
	incr cnt1 1
    }
    if { $currentline != 9999 } {
	#####   Set values from the supplied list
	.user.hidpass delete 0 end
	.user.hidpass insert end [lindex [split $line ":"] 1]
	.user.hiduid delete 0 end
	.user.hiduid insert end [lindex [split [.user.hidden3 get] ":"] 2]
	.user.hidshell delete 0 end
	.user.hidshell insert end [lindex [split [.user.hidden3 get] ":"] 6]
	.user.hiddir delete 0 end
	.user.hiddir insert end [lindex [split [.user.hidden3 get] ":"] 5]
	.user.f1.e1 delete 0 end
	.user.f2.entry delete 0 end
	.user.f3.entry delete 0 end
	.user.f1.e1 insert end [lindex [split [lindex [split $line ":"] 4] " "] 0]
	.user.f2.entry insert end [lindex [split [lindex [split $line ":"] 4] " "] 1]
	.user.f3.entry insert end [lindex [split $line ":"] 0]
	#####   Find and select the appropriate gid
	set defgid [lindex [split $line ":"] 3]
	.user.hidgid delete 0 end
	.user.hidgid insert end $defgid
	focus .user.f4.text
	catch ".user.f4.text selection set $gid2index($defgid)" fail
	if { $fail == {} } {
	    .user.f4.text see $gid2index($defgid)
	    .user.f4.text activate $gid2index($defgid)
	} else {
	    if { $defgid != 0 } {
		# GID not listed in group file
		puts stdout "GID not in group file.  Failed with: $fail"
		error 310
	    } else {
		error 311
	    }
	}
    }
}

#
# ------- User Options Menu -----------
#
proc useropt {} {
    if { [winfo exists .opt ] == 0 } {
	toplevel .opt -class Dialog
	wm title .opt "Options for: [ .user.f3.entry get ]"
	wm iconname .opt "Options"
	frame .opt.f1 -bd 2 -relief "raised"
	label .opt.f1.label -text "Password" -width 9
	entry .opt.f1.e1 -width 16 -show "*"
	label .opt.f1.label2 -text "Confirm" -width 9
	entry .opt.f1.e2 -width 16 -show "*"
	pack .opt.f1.label .opt.f1.e1 .opt.f1.label2 .opt.f1.e2 -fill both -side left -expand 1
	frame .opt.f2 -bd 2 -relief "raised"
	label .opt.f2.label -text "UID" -width 8
	set uid "a"
	radiobutton .opt.f2.rb1 -text "Auto" -variable uid -value "1" -command {
	    .opt.f2.e1 delete 0 end
	    .user.hiduid delete 0 end
	    .opt.f2.e1 insert end "AUTO"
	    .user.hiduid insert end "AUTO"
	    .opt.f2.e1 configure -state disabled
	}
	radiobutton .opt.f2.rb2 -text "Select" -variable uid -value 0 -command {
	    .opt.f2.e1 configure -state normal
	    .user.hiduid delete 0 end
	    .opt.f2.e1 delete 0 end
	    focus .opt.f2.e1
	}
	entry .opt.f2.e1 -width 6
	pack .opt.f2.label .opt.f2.rb1 .opt.f2.rb2 .opt.f2.e1 -side left -fill both -expand 1
	frame .opt.f3 -bd 2 -relief "raised"
	label .opt.f3.label -text "Shell" -width 10
	entry .opt.f3.entry -width 24
	pack .opt.f3.label .opt.f3.entry -fill both -side left -expand 1
	frame .opt.f4 -bd 2 -relief "raised"
	label .opt.f4.label -text "Home Dir" -width 10
	entry .opt.f4.entry -width 24
	pack .opt.f4.label .opt.f4.entry -fill both -side left -expand 1
	frame .opt.f5 -bd 2 -relief "raised" 
	button .opt.f5.b1 -text "OK" -foreground red -activeforeground #a00000 -command {
	    if { [.user.hidden2 get] == 9999 } {
		#####   New Password
		if { [.opt.f1.e1 get] != "" } {
		    if { [.opt.f1.e1 get] != [.opt.f1.e2 get] } {
			.opt.f1.e1 delete 0 end
			.opt.f1.e2 delete 0 end
			focus .opt.f1.e1
			error 102
		    } else {
			.user.hidpass delete 0 end
			.user.hidpass insert end [.opt.f1.e1 get]
			.user.hiduid delete 0 end
			.user.hiduid insert end [.opt.f2.e1 get]
			.user.hiddir delete 0 end
			.user.hiddir insert end [.opt.f4.entry get]
			.user.hidshell delete 0 end
			.user.hidshell insert end [.opt.f3.entry get]
			destroy .opt
		    }
		} else {
		    .user.hidshell delete 0 end
		    .user.hidshell insert end [.opt.f3.entry get]
		    .user.hiduid delete 0 end
		    .user.hiduid insert end [.opt.f2.e1 get]
		    .user.hiddir delete 0 end
		    .user.hiddir insert end [.opt.f4.entry get]
		    destroy .opt
		}
	    } else {
		#####  Old Password
		if { [.opt.f1.e1 get] != "" } {
		    #####  Update password
		    if { [.opt.f1.e1 get] != [.opt.f1.e2 get] } {
			.opt.f1.e1 delete 0 end
			.opt.f1.e2 delete 0 end
			focus .opt.f1.e1
			error 102
		    } else {
			.user.hidpass delete 0 end
			.user.hidpass insert end [.opt.f1.e1 get]
			.user.hiduid delete 0 end
			.user.hiduid insert end [.opt.f2.e1 get]
			.user.hiddir delete 0 end
			.user.hiddir insert end [.opt.f4.entry get]
			.user.hidshell delete 0 end
			.user.hidshell insert end [.opt.f3.entry get]
			destroy .opt
		    }
		} else {
		    .user.hidshell delete 0 end
		    .user.hidshell insert end [.opt.f3.entry get]
		    .user.hiduid delete 0 end
		    .user.hiduid insert end [.opt.f2.e1 get]
		    .user.hiddir delete 0 end
		    .user.hiddir insert end [.opt.f4.entry get]
		    destroy .opt
		}  
	    }
	}
	button .opt.f5.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    destroy .opt
	}
	button .opt.f5.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help users
	}
	pack .opt.f5.b1 .opt.f5.b2 -side left -anchor w 
	pack .opt.f1 .opt.f2 .opt.f3 .opt.f4 .opt.f5 -side top -fill both -expand 1
	
    } else {
	for { set entry 0 } { $entry < $num } { incr entry 1 } {
	    destroy .opt.f3.$entry
	}
    }
    #####  Fill the Entrys with the appropriate values
    .opt.f4.entry delete 0 end
    .user.hiddir delete 0 end
    .user.hiduid delete 0 end
    .user.hidshell delete 0 end
    .opt.f2.e1 delete 0 end
    if { [.user.hidden2 get] != 9999 } {
	#####  Set the Appropriate values
	##  Home Dir
	.opt.f4.entry insert end [lindex [split [.user.hidden3 get] ":"] 5]
	.user.hiddir insert end [lindex [split [.user.hidden3 get] ":"] 5]
	##  UID
	.opt.f2.e1 insert end [lindex [split [.user.hidden3 get] ":"] 2]
	.user.hiduid insert end [lindex [split [.user.hidden3 get] ":"] 2]
	.opt.f2.rb2 select
	## SHell 
	.opt.f3.entry insert end [lindex [split [.user.hidden3 get] ":"] 6]
	.user.hidshell insert end [lindex [split [.user.hidden3 get] ":"] 6]
    } else {
	.opt.f4.entry delete 0 end
	.opt.f4.entry insert end "/home/[.user.f3.entry get]"
	.opt.f3.entry delete 0 end
	.opt.f3.entry insert end "/bin/sh"
	.opt.f2.rb1 invoke
    }
    if { [.opt.f2.e1 get] != "AUTO" } {
	set uid 1000
    }
#-------------  Support for the Shell's file -------------------------------
#    set returnval [queryHost [.user.hidden1 get] "get shells" 0 ]
    set num 0 
#    set tmpline [lindex [split [.user.hidden3 get] ":"] 6]
#    foreach line $returnval {
#	if { [lindex [split $line {} ] 0 ] == "/" } {
#	    radiobutton .opt.f3.$num -text "$line" -selectcolor #000080 -variable shell -value $line -command "
#	        .user.hidshell delete 0 end
#		.user.hidshell insert end $line 
#	    "
#	    if {$line == $tmpline } {
#		set shell $line
#		.opt.f3.$num select
#		.user.hidshell delete 0 end
#		.user.hidshell insert end $line
#	    }
#	    pack .opt.f3.$num -side left
#	    incr num 1
#	}
#    }
    # -----------------  Bindings Option Menu  ----------------------------
    bind .opt.f1.e1 <Return> {
	focus .opt.f1.e2
    }
    bind .opt.f1.e2 <Return> {
	if { [.opt.f1.e1 get] != [.opt.f1.e2 get] } {
	    .opt.f1.e1 delete 0 end
	    .opt.f1.e2 delete 0 end
	    focus .opt.f1.e1
	    error 102
	} else {
	    focus .opt.f4.entry
	}
    }
}




#
# Services update procedure
#
# USE:  services CurrentHost  ServicePort/type SelectedData
#            CurrentHost = host to update
#            ServiceName = The services port and type, set to 9999 for a new one
#            SelectedData = data
#
proc services { chost servptyp line args } {
    global errno
    set host $chost
    if { [string length $args ] != 0 } {
	append line " $args"
    }
    if { [winfo exists .servs ] == 0 } {
	toplevel .servs -class Dialog
	wm title .servs "Services Editor: $chost"
	wm iconname .servs "Services Editor"
	entry .servs.hidden1 
	entry .servs.hidden2
	# NOT GOOD
	.servs.hidden1 insert end $chost
	.servs.hidden2 insert end $servptyp
	frame .servs.f1 -bd 2 -relief "raised"
	label .servs.f1.l1 -text "Name:" -width 6
	entry .servs.f1.e1 -width 10
	pack .servs.f1.l1 .servs.f1.e1 -fill both -side left -expand 1
	frame .servs.f2 -bd 2 -relief "raised"
	label .servs.f2.l1 -text "Port:" -width 6
	entry .servs.f2.e1 -width 10
	label .servs.f2.l2 -text "/" -width 1
	button .servs.f2.b1 -text "tcp" -width 3 -command "flipstate"
	pack .servs.f2.l1 .servs.f2.e1 .servs.f2.l2 .servs.f2.b1 -fill both -side left -expand 1
	frame .servs.f3 -bd 2 -relief "raised"
	label .servs.f3.l1 -text "Aliases:" -width 6
	entry .servs.f3.e1 -width 10
	pack .servs.f3.l1 .servs.f3.e1 -fill both -side left -expand 1
        frame .servs.f4 -bd 2 -relief "raised"
	label .servs.f4.l1 -text "Comment" -width 6
	entry .servs.f4.e1 -width 10
	pack .servs.f4.l1 .servs.f4.e1 -fill x -side top -expand 1

	frame .servs.f8 -bd 2 -relief "raised"
	button .servs.f8.app -text "Apply" -foreground red -activeforeground #a00000 -command {
	    if { [ .servs.f1.e1 get] != "" } {
		if { [ .servs.f2.e1 get] != "" } {
		    # Got the minimum amount of data
		    if { [.servs.hidden2 get] == "9999" } {
			set cmd "CON add services "
		    } else {
			set cmd "CON mod services [.servs.hidden2 get] "
		    }
		    append cmd "[ .servs.f1.e1 get]	[ .servs.f2.e1 get]/[ .servs.f2.b1 cget -text ]	[ .servs.f3.e1 get]	# [ .servs.f4.e1 get]"
		    set returnval [queryHost [.servs.hidden1 get] $cmd 1 ]
		    if { $errno != 0 } {
			error 402
			puts stdout "ERROR:  Unable to update the services file on $currenthost"
		    } else {
			repack 13
			destroy .servs
		    }
		} else {
		    error 401
		}
	    } else {
		error 400
	    }
	}
	button .servs.f8.can -text "Cancel"  -foreground blue -activeforeground #000080 -command {
	    destroy .servs
	}
	button .servs.f8.help -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help services
	}
	pack .servs.f8.app .servs.f8.can .servs.f8.help -fill x -side left -expand 1

	pack .servs.f1 .servs.f3 .servs.f2 .servs.f4 .servs.f8 -side top -fill both -expand 1
	
	# ----------  Bindings  ---------------------
	bind .servs.f1.e1 <Return> {
	    focus .servs.f3.e1
	}
	bind .servs.f3.e1 <Return> {
	    focus .servs.f2.e1
	}
	bind .servs.f2.e1 <Return> {
	    focus .servs.f4.e1
	}
    } else {
	# Window Exists
	.servs.hidden1 delete 0 end
	.servs.hidden2 delete 0 end
	.servs.hidden1 insert end $chost
	.servs.hidden2 insert end $line
    }
    .servs.f1.e1 delete 0 end
    .servs.f2.e1 delete 0 end
    .servs.f3.e1 delete 0 end
    .servs.f4.e1 delete 0 end

    # Fill the widgets
    if { $servptyp != "9999" } {
	set tmp [string trim [lindex $line 1 ] { } ] 
	.servs.f1.e1 insert end [lindex $line 0 ]
	.servs.f2.e1 insert end [lindex [split $tmp {/} ] 0]
	if { [lindex [split $tmp {/} ] 1] == "tcp" } {
	    .servs.f2.b1 configure -text "tcp"
	} else {
	    .servs.f2.b1 configure -text "udp"
	}
	set tmp [string trim [lrange $line 2 end ] { } ]
	.servs.f3.e1 insert end [lindex [split $tmp {#} ] 0 ]
	.servs.f4.e1 insert end [string trim [lindex [split $tmp {#} ] 1 ] { } ]
    }
}

#
# flipstate
#
proc flipstate {} {
    if { [ .servs.f2.b1 cget -text ] == {tcp} } {
	.servs.f2.b1 configure -text {udp}
    } else {
	.servs.f2.b1 configure -text {tcp} 
    } 
}



